/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.indexes;

import com.basho.riak.client.api.commands.indexes.SecondaryIndexQuery;
import com.basho.riak.client.core.StreamingRiakFuture;
import com.basho.riak.client.core.operations.SecondaryIndexQueryOperation;
import com.basho.riak.client.core.query.Namespace;
import com.basho.riak.client.core.util.BinaryValue;

public class IntIndexQuery
extends SecondaryIndexQuery<Long, Response, IntIndexQuery> {
    private final SecondaryIndexQuery.IndexConverter<Long> converter = new SecondaryIndexQuery.IndexConverter<Long>(){

        @Override
        public Long convert(BinaryValue input) {
            return Long.valueOf(input.toStringUtf8());
        }

        @Override
        public BinaryValue convert(Long input) {
            if (input == null) {
                return null;
            }
            return BinaryValue.createFromUtf8(String.valueOf(input));
        }
    };

    @Override
    protected SecondaryIndexQuery.IndexConverter<Long> getConverter() {
        return this.converter;
    }

    protected IntIndexQuery(Init<Long, ?> builder) {
        super(builder, Response::new, Response::new);
    }

    public static class Response
    extends SecondaryIndexQuery.Response<Long, SecondaryIndexQuery.Response.Entry<Long>> {
        Response(Namespace queryLocation, SecondaryIndexQuery.IndexConverter<Long> converter, int timeout, StreamingRiakFuture<SecondaryIndexQueryOperation.Response, SecondaryIndexQueryOperation.Query> coreFuture) {
            super(queryLocation, converter, timeout, coreFuture);
        }

        protected Response(Namespace queryLocation, SecondaryIndexQueryOperation.Response coreResponse, SecondaryIndexQuery.IndexConverter<Long> converter) {
            super(queryLocation, coreResponse, converter);
        }
    }

    public static class Builder
    extends Init<Long, Builder> {
        public Builder(Namespace namespace, String indexName, byte[] coverContext) {
            super(namespace, indexName, coverContext);
        }

        public Builder(Namespace namespace, String indexName, Long start, Long end) {
            super(namespace, indexName, start, end);
        }

        public Builder(Namespace namespace, String indexName, Long match) {
            super(namespace, indexName, match);
        }

        @Override
        protected Builder self() {
            return this;
        }

        public IntIndexQuery build() {
            return new IntIndexQuery(this);
        }
    }

    protected static abstract class Init<S, T extends Init<S, T>>
    extends SecondaryIndexQuery.Init<S, T> {
        public Init(Namespace namespace, String indexName, S start, S end) {
            super(namespace, indexName + (Object)((Object)SecondaryIndexQuery.Type._INT), start, end);
        }

        public Init(Namespace namespace, String indexName, byte[] coverContext) {
            super(namespace, indexName + (Object)((Object)SecondaryIndexQuery.Type._INT), coverContext);
        }

        public Init(Namespace namespace, String indexName, S match) {
            super(namespace, indexName + (Object)((Object)SecondaryIndexQuery.Type._INT), match);
        }

        @Override
        public T withRegexTermFilter(String filter) {
            throw new IllegalArgumentException("Cannot use term filter with _int query");
        }
    }
}

