/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.indexes;

import com.basho.riak.client.api.StreamableRiakCommand;
import com.basho.riak.client.api.commands.ChunkedResponseIterator;
import com.basho.riak.client.core.FutureOperation;
import com.basho.riak.client.core.StreamingRiakFuture;
import com.basho.riak.client.core.operations.SecondaryIndexQueryOperation;
import com.basho.riak.client.core.query.ConvertibleIterator;
import com.basho.riak.client.core.query.Location;
import com.basho.riak.client.core.query.Namespace;
import com.basho.riak.client.core.util.BinaryValue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class SecondaryIndexQuery<T, S extends Response<T, ?>, U extends SecondaryIndexQuery>
extends StreamableRiakCommand<S, U, SecondaryIndexQueryOperation.Response, SecondaryIndexQueryOperation.Query> {
    protected final Namespace namespace;
    protected final String indexName;
    protected final BinaryValue continuation;
    protected final T match;
    protected final T start;
    protected final T end;
    protected final Integer maxResults;
    protected final boolean returnTerms;
    protected final boolean paginationSort;
    protected final String termFilter;
    protected Integer timeout;
    protected final byte[] coverageContext;
    protected final boolean returnBody;
    private final StreamableResponseCreator<T, S> streamableResponseCreator;
    private final GatherableResponseCreator<T, S> gatherableResponseCreator;

    protected SecondaryIndexQuery(Init<T, ?> builder, StreamableResponseCreator<T, S> streamableCreator, GatherableResponseCreator<T, S> gatherableResponseCreator) {
        this.namespace = ((Init)builder).namespace;
        this.indexName = ((Init)builder).indexName;
        this.continuation = ((Init)builder).continuation;
        this.match = ((Init)builder).match;
        this.start = ((Init)builder).start;
        this.end = ((Init)builder).end;
        this.maxResults = ((Init)builder).maxResults;
        this.returnTerms = ((Init)builder).returnTerms;
        this.paginationSort = ((Init)builder).paginationSort;
        this.termFilter = ((Init)builder).termFilter;
        this.timeout = ((Init)builder).timeout;
        this.coverageContext = ((Init)builder).coverageContext;
        this.returnBody = ((Init)builder).returnBody;
        this.streamableResponseCreator = streamableCreator;
        this.gatherableResponseCreator = gatherableResponseCreator;
    }

    protected abstract IndexConverter<T> getConverter();

    public Namespace getNamespace() {
        return this.namespace;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public T getMatchValue() {
        return this.match;
    }

    public T getRangeStart() {
        return this.start;
    }

    public T getRangeEnd() {
        return this.end;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public boolean getReturnKeyAndIndex() {
        return this.returnTerms;
    }

    public boolean getPaginationSort() {
        return this.paginationSort;
    }

    public String getTermFilter() {
        return this.termFilter;
    }

    public BinaryValue getContinuation() {
        return this.continuation;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    protected SecondaryIndexQueryOperation buildCoreOperation(boolean streamResults) {
        IndexConverter<T> converter = this.getConverter();
        SecondaryIndexQueryOperation.Query.Builder coreQueryBuilder = new SecondaryIndexQueryOperation.Query.Builder(this.namespace, BinaryValue.create(this.indexName)).withContinuation(this.continuation).withReturnKeyAndIndex(this.returnTerms).withPaginationSort(this.paginationSort).withReturnBody(this.returnBody);
        if (this.termFilter != null) {
            coreQueryBuilder.withRegexTermFilter(BinaryValue.create(this.termFilter));
        }
        if (this.match != null) {
            coreQueryBuilder.withIndexKey(converter.convert(this.match));
        } else {
            coreQueryBuilder.withRangeStart(converter.convert(this.start)).withRangeEnd(converter.convert(this.end));
        }
        if (this.maxResults != null) {
            coreQueryBuilder.withMaxResults(this.maxResults);
        }
        if (this.timeout != null) {
            coreQueryBuilder.withTimeout(this.timeout);
        }
        if (this.coverageContext != null) {
            coreQueryBuilder.withCoverageContext(this.coverageContext);
        }
        return new SecondaryIndexQueryOperation.Builder(coreQueryBuilder.build()).streamResults(streamResults).build();
    }

    @Override
    protected S convertResponse(FutureOperation<SecondaryIndexQueryOperation.Response, ?, SecondaryIndexQueryOperation.Query> request, SecondaryIndexQueryOperation.Response coreResponse) {
        return this.gatherableResponseCreator.createResponse(this.namespace, coreResponse, this.getConverter());
    }

    @Override
    protected U convertInfo(SecondaryIndexQueryOperation.Query coreInfo) {
        return (U)this;
    }

    @Override
    protected S createResponse(int timeout, StreamingRiakFuture<SecondaryIndexQueryOperation.Response, SecondaryIndexQueryOperation.Query> coreFuture) {
        return this.streamableResponseCreator.createResponse(this.namespace, this.getConverter(), timeout, coreFuture);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SecondaryIndexQuery)) {
            return false;
        }
        SecondaryIndexQuery that = (SecondaryIndexQuery)o;
        if (this.returnTerms != that.returnTerms) {
            return false;
        }
        if (this.paginationSort != that.paginationSort) {
            return false;
        }
        if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
            return false;
        }
        if (this.indexName != null ? !this.indexName.equals(that.indexName) : that.indexName != null) {
            return false;
        }
        if (this.continuation != null ? !this.continuation.equals(that.continuation) : that.continuation != null) {
            return false;
        }
        if (this.match != null ? !this.match.equals(that.match) : that.match != null) {
            return false;
        }
        if (this.start != null ? !this.start.equals(that.start) : that.start != null) {
            return false;
        }
        if (this.end != null ? !this.end.equals(that.end) : that.end != null) {
            return false;
        }
        if (this.maxResults != null ? !this.maxResults.equals(that.maxResults) : that.maxResults != null) {
            return false;
        }
        if (this.termFilter != null ? !this.termFilter.equals(that.termFilter) : that.termFilter != null) {
            return false;
        }
        return !(this.timeout == null ? that.timeout != null : !this.timeout.equals(that.timeout));
    }

    public int hashCode() {
        int result = this.namespace != null ? this.namespace.hashCode() : 0;
        result = 31 * result + (this.indexName != null ? this.indexName.hashCode() : 0);
        result = 31 * result + (this.continuation != null ? this.continuation.hashCode() : 0);
        result = 31 * result + (this.match != null ? this.match.hashCode() : 0);
        result = 31 * result + (this.start != null ? this.start.hashCode() : 0);
        result = 31 * result + (this.end != null ? this.end.hashCode() : 0);
        result = 31 * result + (this.maxResults != null ? this.maxResults.hashCode() : 0);
        result = 31 * result + (this.returnTerms ? 1 : 0);
        result = 31 * result + (this.paginationSort ? 1 : 0);
        result = 31 * result + (this.termFilter != null ? this.termFilter.hashCode() : 0);
        result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SecondaryIndexQuery{, continuation: " + this.continuation + ", namespace: " + this.namespace + ", indexName: " + this.indexName + ", match: " + this.match + ", start: " + this.start + ", end: " + this.end + ", maxResults: " + this.maxResults + ", returnTerms: " + this.returnTerms + ", paginationSort: " + this.paginationSort + ", termFilter: '" + this.termFilter + '\'' + ", timeout: " + this.timeout + '}';
    }

    public static class Response<T, E extends Entry<T>>
    extends StreamableRiakCommand.StreamableResponse<E, SecondaryIndexQueryOperation.Response.Entry> {
        protected final IndexConverter<T> converter;
        protected final SecondaryIndexQueryOperation.Response coreResponse;
        protected final Namespace queryLocation;

        protected Response(Namespace queryLocation, final IndexConverter<T> converter, int timeout, StreamingRiakFuture<SecondaryIndexQueryOperation.Response, SecondaryIndexQueryOperation.Query> coreFuture) {
            this.queryLocation = queryLocation;
            this.converter = converter;
            this.coreResponse = null;
            this.chunkedResponseIterator = new ChunkedResponseIterator<E, SecondaryIndexQueryOperation.Response, SecondaryIndexQueryOperation.Response.Entry>(coreFuture, timeout, null, SecondaryIndexQueryOperation.Response::iterator, SecondaryIndexQueryOperation.Response::getContinuation){

                @Override
                public E next() {
                    SecondaryIndexQueryOperation.Response.Entry coreEntity = (SecondaryIndexQueryOperation.Response.Entry)this.currentIterator.next();
                    return this.createEntry(queryLocation, coreEntity, converter);
                }
            };
        }

        protected Response(Namespace queryLocation, SecondaryIndexQueryOperation.Response coreResponse, IndexConverter<T> converter) {
            this.queryLocation = queryLocation;
            this.converter = converter;
            this.coreResponse = coreResponse;
        }

        @Override
        public Iterator<E> iterator() {
            if (this.isStreaming()) {
                return super.iterator();
            }
            return new ConvertibleIterator<SecondaryIndexQueryOperation.Response.Entry, E>(this.coreResponse.getEntryList().iterator()){

                @Override
                protected E convert(SecondaryIndexQueryOperation.Response.Entry e) {
                    return this.createEntry(queryLocation, e, converter);
                }
            };
        }

        public boolean hasContinuation() {
            if (this.isStreaming()) {
                return this.chunkedResponseIterator.hasContinuation();
            }
            return this.coreResponse.hasContinuation();
        }

        public BinaryValue getContinuation() {
            if (this.isStreaming()) {
                return this.chunkedResponseIterator.getContinuation();
            }
            return this.coreResponse.getContinuation();
        }

        public boolean hasEntries() {
            if (this.isStreaming()) {
                return this.chunkedResponseIterator.hasNext();
            }
            return !this.coreResponse.getEntryList().isEmpty();
        }

        public final List<E> getEntries() {
            if (this.isStreaming()) {
                throw new IllegalStateException("Use the iterator() while using the streaming API");
            }
            List<SecondaryIndexQueryOperation.Response.Entry> coreEntries = this.coreResponse.getEntryList();
            ArrayList<E> convertedList = new ArrayList<E>(coreEntries.size());
            for (SecondaryIndexQueryOperation.Response.Entry e : coreEntries) {
                E ce = this.createEntry(this.queryLocation, e, this.converter);
                convertedList.add(ce);
            }
            return convertedList;
        }

        protected E createEntry(Location location, SecondaryIndexQueryOperation.Response.Entry coreEntry, IndexConverter<T> converter) {
            return (E)new Entry<T>(location, coreEntry.getIndexKey(), converter);
        }

        protected final E createEntry(Namespace namespace, SecondaryIndexQueryOperation.Response.Entry coreEntry, IndexConverter<T> converter) {
            Location loc = new Location(this.queryLocation, coreEntry.getObjectKey());
            return this.createEntry(loc, coreEntry, converter);
        }

        public static class Entry<T> {
            private final Location riakObjectLocation;
            private final BinaryValue indexKey;
            private final IndexConverter<T> converter;

            protected Entry(Location riakObjectLocation, BinaryValue indexKey, IndexConverter<T> converter) {
                this.riakObjectLocation = riakObjectLocation;
                this.indexKey = indexKey;
                this.converter = converter;
            }

            public Location getRiakObjectLocation() {
                return this.riakObjectLocation;
            }

            public T getIndexKey() {
                return this.converter.convert(this.indexKey);
            }
        }
    }

    public static abstract class Init<S, T extends Init<S, T>> {
        private final Namespace namespace;
        private final String indexName;
        private volatile BinaryValue continuation;
        private volatile S match;
        private volatile S start;
        private volatile S end;
        private volatile Integer maxResults;
        private volatile boolean returnTerms;
        private volatile boolean paginationSort;
        private volatile String termFilter;
        private volatile Integer timeout;
        private volatile byte[] coverageContext;
        private volatile boolean returnBody;

        public Init(Namespace namespace, String indexName, S start, S end) {
            this.namespace = namespace;
            this.indexName = indexName;
            this.start = start;
            this.end = end;
        }

        public Init(Namespace namespace, String indexName, S match) {
            this.namespace = namespace;
            this.indexName = indexName;
            this.match = match;
        }

        protected abstract T self();

        public Init(Namespace namespace, String indexName, byte[] coverageContext) {
            this.namespace = namespace;
            this.indexName = indexName;
            this.coverageContext = coverageContext;
        }

        public T withContinuation(BinaryValue continuation) {
            this.continuation = continuation;
            return this.self();
        }

        public T withMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this.self();
        }

        public T withKeyAndIndex(boolean returnBoth) {
            this.returnTerms = returnBoth;
            return this.self();
        }

        public T withPaginationSort(boolean orderByKey) {
            this.paginationSort = orderByKey;
            return this.self();
        }

        public T withRegexTermFilter(String filter) {
            this.termFilter = filter;
            return this.self();
        }

        public T withTimeout(int timeout) {
            this.timeout = timeout;
            return this.self();
        }

        public T withCoverageContext(byte[] coverageContext) {
            this.coverageContext = coverageContext;
            return this.self();
        }

        protected T withReturnBody(boolean returnBody) {
            this.returnBody = returnBody;
            return this.self();
        }
    }

    protected static interface IndexConverter<T> {
        public T convert(BinaryValue var1);

        public BinaryValue convert(T var1);
    }

    public static enum Type {
        _INT("_int"),
        _BIN("_bin"),
        _BUCKET(""),
        _KEY("");

        private String suffix;

        private Type(String suffix) {
            this.suffix = suffix;
        }

        public String toString() {
            return this.suffix;
        }
    }

    @FunctionalInterface
    public static interface GatherableResponseCreator<T, R extends Response<T, ?>> {
        public R createResponse(Namespace var1, SecondaryIndexQueryOperation.Response var2, IndexConverter<T> var3);
    }

    @FunctionalInterface
    public static interface StreamableResponseCreator<T, R extends Response<T, ?>> {
        public R createResponse(Namespace var1, IndexConverter<T> var2, int var3, StreamingRiakFuture<SecondaryIndexQueryOperation.Response, SecondaryIndexQueryOperation.Query> var4);
    }
}

