/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.kv;

import com.basho.riak.client.api.AsIsRiakCommand;
import com.basho.riak.client.api.cap.Quorum;
import com.basho.riak.client.api.cap.VClock;
import com.basho.riak.client.api.commands.RiakOption;
import com.basho.riak.client.api.commands.kv.KvBuilderBase;
import com.basho.riak.client.core.RiakCluster;
import com.basho.riak.client.core.RiakFuture;
import com.basho.riak.client.core.operations.DeleteOperation;
import com.basho.riak.client.core.query.Location;
import java.util.HashMap;
import java.util.Map;

public final class DeleteValue
extends AsIsRiakCommand<Void, Location> {
    private final Location location;
    private final Map<Option<?>, Object> options = new HashMap();
    private final VClock vClock;

    public DeleteValue(Builder builder) {
        this.location = builder.location;
        this.options.putAll(builder.options);
        this.vClock = builder.vClock;
    }

    @Override
    protected RiakFuture<Void, Location> executeAsync(RiakCluster cluster) {
        return super.executeAsync(cluster);
    }

    protected DeleteOperation buildCoreOperation() {
        DeleteOperation.Builder builder = new DeleteOperation.Builder(this.location);
        if (this.vClock != null) {
            builder.withVclock(this.vClock);
        }
        for (Map.Entry<Option<?>, Object> optPair : this.options.entrySet()) {
            Option<?> option = optPair.getKey();
            if (option == Option.DW) {
                builder.withDw(((Quorum)optPair.getValue()).getIntValue());
                continue;
            }
            if (option == Option.N_VAL) {
                builder.withNVal((Integer)optPair.getValue());
                continue;
            }
            if (option == Option.PR) {
                builder.withPr(((Quorum)optPair.getValue()).getIntValue());
                continue;
            }
            if (option == Option.R) {
                builder.withR(((Quorum)optPair.getValue()).getIntValue());
                continue;
            }
            if (option == Option.PW) {
                builder.withPw(((Quorum)optPair.getValue()).getIntValue());
                continue;
            }
            if (option == Option.RW) {
                builder.withRw(((Quorum)optPair.getValue()).getIntValue());
                continue;
            }
            if (option == Option.SLOPPY_QUORUM) {
                builder.withSloppyQuorum((Boolean)optPair.getValue());
                continue;
            }
            if (option == Option.TIMEOUT) {
                builder.withTimeout((Integer)optPair.getValue());
                continue;
            }
            if (option != Option.W) continue;
            builder.withW(((Quorum)optPair.getValue()).getIntValue());
        }
        return builder.build();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
        result = 31 * result + this.options.hashCode();
        result = 31 * result + (this.vClock != null ? this.vClock.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteValue)) {
            return false;
        }
        DeleteValue other = (DeleteValue)obj;
        if (!(this.location == other.location || this.location != null && this.location.equals(other.location))) {
            return false;
        }
        if (!(this.options == other.options || this.options != null && this.options.equals(other.options))) {
            return false;
        }
        return this.vClock == other.vClock || this.vClock != null && this.vClock.equals(other.vClock);
    }

    public String toString() {
        return String.format("{location: %s, options: %s, vClock: %s}", this.location, this.options, this.vClock);
    }

    public static class Builder
    extends KvBuilderBase<DeleteValue> {
        private final Map<Option<?>, Object> options = new HashMap();
        private VClock vClock;

        public Builder(Location location) {
            super(location);
        }

        public Builder withVClock(VClock vClock) {
            this.vClock = vClock;
            return this;
        }

        public <T> Builder withOption(Option<T> option, T value) {
            this.options.put(option, value);
            return this;
        }

        public Builder withTimeout(int timeout) {
            this.withOption(Option.TIMEOUT, timeout);
            return this;
        }

        @Override
        public DeleteValue build() {
            return new DeleteValue(this);
        }
    }

    public static final class Option<T>
    extends RiakOption<T> {
        public static final Option<Quorum> RW = new Option("RW");
        public static final Option<Quorum> R = new Option("R");
        public static final Option<Quorum> W = new Option("W");
        public static final Option<Quorum> PR = new Option("PR");
        public static final Option<Quorum> PW = new Option("PW");
        public static final Option<Quorum> DW = new Option("DW");
        public static final Option<Integer> TIMEOUT = new Option("TIMEOUT");
        public static final Option<Boolean> SLOPPY_QUORUM = new Option("SLOPPY_QUORUM");
        public static final Option<Integer> N_VAL = new Option("N_VAL");

        private Option(String name) {
            super(name);
        }
    }
}

