/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.kv;

import com.basho.riak.client.api.StreamableRiakCommand;
import com.basho.riak.client.api.commands.ChunkedResponseIterator;
import com.basho.riak.client.core.FutureOperation;
import com.basho.riak.client.core.StreamingRiakFuture;
import com.basho.riak.client.core.operations.ListKeysOperation;
import com.basho.riak.client.core.query.ConvertibleIterator;
import com.basho.riak.client.core.query.Location;
import com.basho.riak.client.core.query.Namespace;
import com.basho.riak.client.core.util.BinaryValue;
import java.util.Iterator;
import java.util.List;

public final class ListKeys
extends StreamableRiakCommand.StreamableRiakCommandWithSameInfo<Response, Namespace, ListKeysOperation.Response> {
    private final Namespace namespace;
    private final int timeout;

    ListKeys(Builder builder) {
        this.namespace = builder.namespace;
        this.timeout = builder.timeout;
    }

    @Override
    protected Response convertResponse(FutureOperation<ListKeysOperation.Response, ?, Namespace> request, ListKeysOperation.Response coreResponse) {
        return new Response(this.namespace, coreResponse.getKeys());
    }

    @Override
    protected Response createResponse(int timeout, StreamingRiakFuture<ListKeysOperation.Response, Namespace> coreFuture) {
        return new Response(this.namespace, timeout, coreFuture);
    }

    protected ListKeysOperation buildCoreOperation(boolean streamResults) {
        ListKeysOperation.Builder builder = new ListKeysOperation.Builder(this.namespace);
        if (this.timeout > 0) {
            builder.withTimeout(this.timeout);
        }
        builder.streamResults(streamResults);
        return builder.build();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
        result = 31 * result + this.timeout;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListKeys)) {
            return false;
        }
        ListKeys other = (ListKeys)obj;
        if (!(this.namespace == other.namespace || this.namespace != null && this.namespace.equals(other.namespace))) {
            return false;
        }
        return this.timeout == other.timeout;
    }

    public String toString() {
        return String.format("{namespace: %s, timeout: %s}", this.namespace, this.timeout);
    }

    public static class Builder {
        private final Namespace namespace;
        private int timeout;

        public Builder(Namespace namespace) {
            if (namespace == null) {
                throw new IllegalArgumentException("Namespace cannot be null");
            }
            this.namespace = namespace;
        }

        public Builder withTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public ListKeys build() {
            return new ListKeys(this);
        }
    }

    public static class Response
    extends StreamableRiakCommand.StreamableResponse<Location, BinaryValue> {
        private final Namespace namespace;
        private final List<BinaryValue> keys;

        public Response(Namespace namespace, List<BinaryValue> keys) {
            this.namespace = namespace;
            this.keys = keys;
        }

        Response(Namespace namespace, int pollTimeout, StreamingRiakFuture<ListKeysOperation.Response, Namespace> coreFuture) {
            super(new ChunkedResponseIterator<Location, ListKeysOperation.Response, BinaryValue>(coreFuture, pollTimeout, key -> new Location(namespace, (BinaryValue)key), nextChunk -> nextChunk.getKeys().iterator()));
            this.namespace = namespace;
            this.keys = null;
        }

        @Override
        public Iterator<Location> iterator() {
            if (this.isStreaming()) {
                return super.iterator();
            }
            assert (this.keys != null);
            return new ConvertibleIterator<BinaryValue, Location>(this.keys.iterator()){

                @Override
                protected Location convert(BinaryValue key) {
                    return new Location(namespace, key);
                }
            };
        }
    }
}

