/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.kv;

import com.basho.riak.client.api.RiakCommand;
import com.basho.riak.client.api.commands.ListenableFuture;
import com.basho.riak.client.api.commands.RiakOption;
import com.basho.riak.client.api.commands.kv.KvBuilderBase;
import com.basho.riak.client.core.RiakCluster;
import com.basho.riak.client.core.RiakFuture;
import com.basho.riak.client.core.RiakFutureListener;
import com.basho.riak.client.core.query.Location;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class MultiCommand<BaseCommand extends RiakCommand<BaseResponseType, Location>, BaseBuilder extends KvBuilderBase<BaseCommand>, ResponseType extends Iterable<RiakFuture<BaseResponseType, Location>>, BaseResponseType>
extends RiakCommand<ResponseType, List<Location>> {
    private static final int DEFAULT_MAX_IN_FLIGHT = 10;
    private final ArrayList<Location> locations;
    protected final Map<RiakOption<?>, Object> options = new HashMap();
    private final int maxInFlight;

    MultiCommand(Builder builder) {
        this.locations = builder.locations;
        this.options.putAll(builder.options);
        this.maxInFlight = builder.maxInFlight;
    }

    @Override
    protected RiakFuture<ResponseType, List<Location>> executeAsync(RiakCluster cluster) {
        List<BaseCommand> operations = this.buildOperations();
        MultiFuture future = new MultiFuture(this.locations);
        Submitter submitter = new Submitter(operations, this.maxInFlight, cluster, future);
        Thread worker = new Thread(submitter);
        worker.setDaemon(true);
        worker.start();
        return future;
    }

    private List<BaseCommand> buildOperations() {
        LinkedList baseOperations = new LinkedList();
        for (Location location : this.locations) {
            BaseBuilder builder = this.createBaseBuilderType(location);
            for (RiakOption<?> option : this.options.keySet()) {
                ((KvBuilderBase)builder).addOption(option, this.options.get(option));
            }
            baseOperations.add(((KvBuilderBase)builder).build());
        }
        return baseOperations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiCommand that = (MultiCommand)o;
        if (this.maxInFlight != that.maxInFlight) {
            return false;
        }
        if (!this.locations.equals(that.locations)) {
            return false;
        }
        return this.options.equals(that.options);
    }

    public int hashCode() {
        int result = this.locations.hashCode();
        result = 31 * result + this.options.hashCode();
        result = 31 * result + this.maxInFlight;
        return result;
    }

    public String toString() {
        return String.format("%s {locations: %s, options: %s, maxInFlight: %s}", this.getClass().getSimpleName(), this.locations, this.options, this.maxInFlight);
    }

    protected abstract ResponseType createResponseType(List<RiakFuture<BaseResponseType, Location>> var1);

    protected abstract BaseBuilder createBaseBuilderType(Location var1);

    protected abstract RiakFuture<BaseResponseType, Location> executeBaseCommandAsync(BaseCommand var1, RiakCluster var2);

    class MultiFuture
    extends ListenableFuture<ResponseType, List<Location>> {
        private final CountDownLatch latch = new CountDownLatch(1);
        private final List<Location> locations;
        private final List<RiakFuture<BaseResponseType, Location>> futures;
        private volatile Throwable exception;

        MultiFuture(List<Location> locations) {
            this.locations = locations;
            this.futures = Collections.synchronizedList(new LinkedList());
            if (this.locations.isEmpty()) {
                this.setCompleted();
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public ResponseType get() throws InterruptedException {
            this.latch.await();
            return MultiCommand.this.createResponseType(this.futures);
        }

        @Override
        public ResponseType get(long timeout, TimeUnit unit) throws InterruptedException {
            this.latch.await(timeout, unit);
            if (this.isDone()) {
                return MultiCommand.this.createResponseType(this.futures);
            }
            return null;
        }

        @Override
        public ResponseType getNow() {
            if (this.isDone()) {
                return MultiCommand.this.createResponseType(this.futures);
            }
            return null;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.latch.getCount() != 1L;
        }

        @Override
        public void await() throws InterruptedException {
            this.latch.await();
        }

        @Override
        public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
            return this.latch.await(timeout, unit);
        }

        @Override
        public boolean isSuccess() {
            return this.isDone() && this.exception == null;
        }

        @Override
        public List<Location> getQueryInfo() {
            return this.locations;
        }

        @Override
        public Throwable cause() {
            return this.exception;
        }

        private void addFetchFuture(RiakFuture<BaseResponseType, Location> future) {
            this.futures.add(future);
        }

        private void setCompleted() {
            this.latch.countDown();
            this.notifyListeners();
        }

        private void setFailed(Throwable t) {
            this.exception = t;
            this.latch.countDown();
            this.notifyListeners();
        }
    }

    class Submitter
    implements Runnable,
    RiakFutureListener<BaseResponseType, Location> {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private final List<BaseCommand> commands;
        private final Semaphore inFlight;
        private final AtomicInteger received = new AtomicInteger();
        private final RiakCluster cluster;
        private final MultiFuture multiFuture;

        Submitter(List<BaseCommand> commands, int maxInFlight, RiakCluster cluster, MultiFuture multiFuture) {
            this.commands = commands;
            this.cluster = cluster;
            this.multiFuture = multiFuture;
            this.inFlight = new Semaphore(maxInFlight);
        }

        @Override
        public void run() {
            this.logger.debug("Running daemon worker thread.");
            for (RiakCommand command : this.commands) {
                try {
                    this.inFlight.acquire();
                }
                catch (InterruptedException ex) {
                    this.logger.error("Daemon worker thread interrupted.");
                    this.multiFuture.setFailed(ex);
                    break;
                }
                RiakFuture future = MultiCommand.this.executeBaseCommandAsync(command, this.cluster);
                future.addListener(this);
            }
        }

        @Override
        public void handle(RiakFuture<BaseResponseType, Location> f) {
            this.logger.debug("Received MultiCommand individual result.");
            this.multiFuture.addFetchFuture(f);
            this.inFlight.release();
            int completed = this.received.incrementAndGet();
            if (completed == this.commands.size()) {
                this.multiFuture.setCompleted();
            }
        }
    }

    public static class Response<BaseResponseType>
    implements Iterable<RiakFuture<BaseResponseType, Location>> {
        private final List<RiakFuture<BaseResponseType, Location>> responses;

        Response(List<RiakFuture<BaseResponseType, Location>> responses) {
            this.responses = responses;
        }

        @Override
        public Iterator<RiakFuture<BaseResponseType, Location>> iterator() {
            return Collections.unmodifiableList(this.responses).iterator();
        }

        public List<RiakFuture<BaseResponseType, Location>> getResponses() {
            return this.responses;
        }
    }

    protected static abstract class Builder<BuiltType, ConcreteBuilder extends Builder<BuiltType, ConcreteBuilder>> {
        private ArrayList<Location> locations = new ArrayList();
        private Map<RiakOption<?>, Object> options = new HashMap();
        private int maxInFlight = 10;

        protected Builder() {
        }

        public ConcreteBuilder addLocation(Location location) {
            this.locations.add(location);
            return this.self();
        }

        public ConcreteBuilder addLocations(Location ... location) {
            this.locations.addAll(Arrays.asList(location));
            return this.self();
        }

        public ConcreteBuilder addLocations(Iterable<Location> location) {
            for (Location loc : location) {
                this.locations.add(loc);
            }
            return this.self();
        }

        public ConcreteBuilder withMaxInFlight(int maxInFlight) {
            this.maxInFlight = maxInFlight;
            return this.self();
        }

        public <U> ConcreteBuilder withOption(RiakOption<U> option, U value) {
            this.options.put(option, value);
            return this.self();
        }

        protected abstract ConcreteBuilder self();

        public abstract BuiltType build();
    }
}

