/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.kv;

import com.basho.riak.client.api.GenericRiakCommand;
import com.basho.riak.client.api.cap.Quorum;
import com.basho.riak.client.api.cap.VClock;
import com.basho.riak.client.api.commands.RiakOption;
import com.basho.riak.client.api.commands.kv.KvResponseBase;
import com.basho.riak.client.api.convert.Converter;
import com.basho.riak.client.api.convert.ConverterFactory;
import com.basho.riak.client.core.FutureOperation;
import com.basho.riak.client.core.RiakCluster;
import com.basho.riak.client.core.RiakFuture;
import com.basho.riak.client.core.operations.StoreOperation;
import com.basho.riak.client.core.query.Location;
import com.basho.riak.client.core.query.Namespace;
import com.basho.riak.client.core.util.BinaryValue;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.HashMap;
import java.util.Map;

public final class StoreValue
extends GenericRiakCommand.GenericRiakCommandWithSameInfo<Response, Location, StoreOperation.Response> {
    private final Namespace namespace;
    private final BinaryValue key;
    private final Map<Option<?>, Object> options = new HashMap();
    private final Object value;
    private final TypeReference<?> typeReference;
    private final VClock vclock;

    StoreValue(Builder builder) {
        this.options.putAll(builder.options);
        this.namespace = builder.namespace;
        this.key = builder.key;
        this.value = builder.value;
        this.typeReference = builder.typeReference;
        this.vclock = builder.vclock;
    }

    @Override
    protected Response convertResponse(FutureOperation<StoreOperation.Response, ?, Location> request, StoreOperation.Response coreResponse) {
        Location loc = request.getQueryInfo();
        if (coreResponse.hasGeneratedKey()) {
            loc = new Location(loc.getNamespace(), coreResponse.getGeneratedKey());
        }
        return ((Response.Builder)((Response.Builder)((Response.Builder)new Response.Builder().withValues(coreResponse.getObjectList())).withGeneratedKey(loc.getKey())).withLocation(loc)).build();
    }

    @Override
    protected RiakFuture<Response, Location> executeAsync(RiakCluster cluster) {
        return super.executeAsync(cluster);
    }

    protected StoreOperation buildCoreOperation() {
        StoreOperation.Builder builder;
        Converter<Object> converter = this.typeReference == null ? ConverterFactory.getInstance().getConverter(this.value.getClass()) : ConverterFactory.getInstance().getConverter(this.typeReference);
        Converter.OrmExtracted orm = converter.fromDomain(this.value, this.namespace, this.key);
        if (orm.getRiakObject().getVClock() == null) {
            orm.getRiakObject().setVClock(this.vclock);
        }
        if (orm.hasKey()) {
            Location loc = new Location(orm.getNamespace(), orm.getKey());
            builder = new StoreOperation.Builder(loc);
        } else {
            builder = new StoreOperation.Builder(orm.getNamespace());
        }
        builder.withContent(orm.getRiakObject());
        for (Map.Entry<Option<?>, Object> opPair : this.options.entrySet()) {
            RiakOption option = opPair.getKey();
            if (option == Option.TIMEOUT) {
                builder.withTimeout((Integer)opPair.getValue());
                continue;
            }
            if (option == Option.RETURN_HEAD) {
                builder.withReturnHead((Boolean)opPair.getValue());
                continue;
            }
            if (option == Option.ASIS) {
                builder.withAsis((Boolean)opPair.getValue());
                continue;
            }
            if (option == Option.DW) {
                builder.withDw(((Quorum)opPair.getValue()).getIntValue());
                continue;
            }
            if (option == Option.IF_NONE_MATCH) {
                builder.withIfNoneMatch((Boolean)opPair.getValue());
                continue;
            }
            if (option == Option.IF_NOT_MODIFIED) {
                builder.withIfNotModified((Boolean)opPair.getValue());
                continue;
            }
            if (option == Option.N_VAL) {
                builder.withNVal((Integer)opPair.getValue());
                continue;
            }
            if (option == Option.PW) {
                builder.withPw(((Quorum)opPair.getValue()).getIntValue());
                continue;
            }
            if (option == Option.SLOPPY_QUORUM) {
                builder.withSloppyQuorum((Boolean)opPair.getValue());
                continue;
            }
            if (option == Option.W) {
                builder.withW(((Quorum)opPair.getValue()).getIntValue());
                continue;
            }
            if (option != Option.RETURN_BODY) continue;
            builder.withReturnBody((Boolean)opPair.getValue());
        }
        return builder.build();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        result = 31 * result + this.options.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.typeReference != null ? this.typeReference.hashCode() : 0);
        result = 31 * result + (this.vclock != null ? this.vclock.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StoreValue)) {
            return false;
        }
        StoreValue other = (StoreValue)obj;
        if (!(this.namespace == other.namespace || this.namespace != null && this.namespace.equals(other.namespace))) {
            return false;
        }
        if (!(this.key == other.key || this.key != null && this.key.equals(other.key))) {
            return false;
        }
        if (!(this.options == other.options || this.options != null && this.options.equals(other.options))) {
            return false;
        }
        if (!(this.value == other.value || this.value != null && this.value.equals(other.value))) {
            return false;
        }
        if (!(this.typeReference == other.typeReference || this.typeReference != null && this.typeReference.equals(other.typeReference))) {
            return false;
        }
        return this.vclock == other.vclock || this.vclock != null && this.vclock.equals(other.vclock);
    }

    public String toString() {
        return String.format("{namespace: %s, key: %s, options: %s, value: %s, typeReference: %s, vclock: %s}", this.namespace, this.key, this.options, this.value, this.typeReference, this.vclock);
    }

    public static class Builder {
        private final Map<Option<?>, Object> options = new HashMap();
        private final Object value;
        private Namespace namespace;
        private BinaryValue key;
        private TypeReference<?> typeReference;
        private VClock vclock;

        public Builder(Object value) {
            this.value = value;
        }

        public Builder(Object value, TypeReference<?> typeReference) {
            this.value = value;
            this.typeReference = typeReference;
        }

        public Builder withLocation(Location location) {
            this.namespace = location.getNamespace();
            this.key = location.getKey();
            return this;
        }

        public Builder withNamespace(Namespace namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder withTimeout(int timeout) {
            this.withOption(Option.TIMEOUT, timeout);
            return this;
        }

        public <T> Builder withOption(Option<T> option, T value) {
            this.options.put(option, value);
            return this;
        }

        public Builder withVectorClock(VClock vclock) {
            this.vclock = vclock;
            return this;
        }

        public StoreValue build() {
            return new StoreValue(this);
        }
    }

    public static class Response
    extends KvResponseBase {
        private final BinaryValue generatedKey;

        Response(Init<?> builder) {
            super(builder);
            this.generatedKey = ((Init)builder).generatedKey;
        }

        public boolean hasGeneratedKey() {
            return this.generatedKey != null;
        }

        public BinaryValue getGeneratedKey() {
            return this.generatedKey;
        }

        static class Builder
        extends Init<Builder> {
            Builder() {
            }

            @Override
            protected Builder self() {
                return this;
            }

            @Override
            Response build() {
                return new Response(this);
            }
        }

        protected static abstract class Init<T extends Init<T>>
        extends KvResponseBase.Init<T> {
            private BinaryValue generatedKey;

            protected Init() {
            }

            T withGeneratedKey(BinaryValue generatedKey) {
                this.generatedKey = generatedKey;
                return (T)((Init)this.self());
            }
        }
    }

    public static final class Option<T>
    extends RiakOption<T> {
        public static final Option<Quorum> W = new Option("W");
        public static final Option<Quorum> DW = new Option("DW");
        public static final Option<Quorum> PW = new Option("PW");
        public static final Option<Boolean> IF_NOT_MODIFIED = new Option("IF_NOT_MODIFIED");
        public static final Option<Boolean> IF_NONE_MATCH = new Option("IF_NONE_MATCH");
        public static final Option<Boolean> RETURN_BODY = new Option("RETURN_BODY");
        public static final Option<Boolean> RETURN_HEAD = new Option("RETURN_HEAD");
        public static final Option<Integer> TIMEOUT = new Option("TIMEOUT");
        public static final Option<Boolean> ASIS = new Option("ASIS");
        public static final Option<Boolean> SLOPPY_QUORUM = new Option("SLOPPY_QUORUM");
        public static final Option<Integer> N_VAL = new Option("N_VAL");

        private Option(String name) {
            super(name);
        }
    }
}

