/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.kv;

import com.basho.riak.client.api.RiakCommand;
import com.basho.riak.client.api.cap.VClock;
import com.basho.riak.client.api.commands.ListenableFuture;
import com.basho.riak.client.api.commands.kv.FetchValue;
import com.basho.riak.client.api.commands.kv.KvResponseBase;
import com.basho.riak.client.api.commands.kv.StoreValue;
import com.basho.riak.client.api.convert.ConversionException;
import com.basho.riak.client.api.convert.reflection.AnnotationUtil;
import com.basho.riak.client.core.RiakCluster;
import com.basho.riak.client.core.RiakFuture;
import com.basho.riak.client.core.RiakFutureListener;
import com.basho.riak.client.core.query.Location;
import com.basho.riak.client.core.query.RiakObject;
import com.fasterxml.jackson.core.type.TypeReference;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class UpdateValue
extends RiakCommand<Response, Location> {
    private final Location location;
    private final Update<?> update;
    private final TypeReference<?> typeReference;
    private final Map<FetchValue.Option<?>, Object> fetchOptions = new HashMap();
    private final Map<StoreValue.Option<?>, Object> storeOptions = new HashMap();

    UpdateValue(Builder builder) {
        this.location = builder.location;
        this.update = builder.update;
        this.typeReference = builder.typeReference;
        this.fetchOptions.putAll(builder.fetchOptions);
        this.storeOptions.putAll(builder.storeOptions);
    }

    @Override
    protected RiakFuture<Response, Location> executeAsync(RiakCluster cluster) {
        UpdateValueFuture updateFuture = new UpdateValueFuture(this.location);
        FetchValue.Builder fetchBuilder = new FetchValue.Builder(this.location);
        for (Map.Entry<FetchValue.Option<?>, Object> optPair : this.fetchOptions.entrySet()) {
            fetchBuilder.withOption(optPair.getKey(), optPair.getValue());
        }
        RiakFuture<FetchValue.Response, Location> fetchFuture = fetchBuilder.build().executeAsync(cluster);
        RiakFutureListener fetchListener = f -> {
            if (!f.isSuccess()) {
                updateFuture.setException(f.cause());
                return;
            }
            try {
                FetchValue.Response fetchResponse = (FetchValue.Response)f.get();
                Object resolved = null;
                VClock vclock = null;
                if (!fetchResponse.isNotFound()) {
                    if (this.typeReference == null) {
                        ParameterizedType pType = (ParameterizedType)this.update.getClass().getGenericSuperclass();
                        Type t = pType.getActualTypeArguments()[0];
                        if (t instanceof ParameterizedType) {
                            t = ((ParameterizedType)t).getRawType();
                        }
                        resolved = fetchResponse.getValue((Class)t);
                    } else {
                        resolved = fetchResponse.getValue((TypeReference)this.typeReference);
                    }
                    vclock = fetchResponse.getVectorClock();
                }
                Object updated = this.update.apply(resolved);
                if (this.update.isModified()) {
                    AnnotationUtil.setVClock(updated, vclock);
                    StoreValue.Builder store = new StoreValue.Builder(updated, this.typeReference).withLocation(this.location).withVectorClock(vclock);
                    for (Map.Entry<StoreValue.Option<?>, Object> optPair : this.storeOptions.entrySet()) {
                        store.withOption(optPair.getKey(), optPair.getValue());
                    }
                    RiakFuture<StoreValue.Response, Location> storeFuture = store.build().executeAsync(cluster);
                    storeFuture.addListener(updateFuture);
                } else {
                    Response updateResponse = ((Response.Builder)((Response.Builder)new Response.Builder().withLocation((Location)f.getQueryInfo())).withUpdated(false)).build();
                    updateFuture.setResponse(updateResponse);
                }
            }
            catch (ConversionException | InterruptedException | ExecutionException ex) {
                updateFuture.setException(ex);
            }
        };
        fetchFuture.addListener(fetchListener);
        return updateFuture;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
        result = 31 * result + (this.update != null ? this.update.hashCode() : 0);
        result = 31 * result + (this.typeReference != null ? this.typeReference.hashCode() : 0);
        result = 31 * result + this.fetchOptions.hashCode();
        result = 31 * result + this.storeOptions.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateValue)) {
            return false;
        }
        UpdateValue other = (UpdateValue)obj;
        if (!(this.location == other.location || this.location != null && this.location.equals(other.location))) {
            return false;
        }
        if (!(this.update == other.update || this.update != null && this.update.equals(other.update))) {
            return false;
        }
        if (!(this.typeReference == other.typeReference || this.typeReference != null && this.typeReference.equals(other.typeReference))) {
            return false;
        }
        if (!(this.fetchOptions == other.fetchOptions || this.fetchOptions != null && this.fetchOptions.equals(other.fetchOptions))) {
            return false;
        }
        return this.storeOptions == other.storeOptions || this.storeOptions != null && this.storeOptions.equals(other.storeOptions);
    }

    public String toString() {
        return String.format("{location: %s, update: %s, typeReference: %s, fetchOptions: %s, storeOptions: %s}", this.location, this.update, this.typeReference, this.fetchOptions, this.storeOptions);
    }

    private class UpdateValueFuture
    extends ListenableFuture<Response, Location>
    implements RiakFutureListener<StoreValue.Response, Location> {
        private final Location location;
        private final CountDownLatch latch = new CountDownLatch(1);
        private volatile Throwable exception;
        private volatile Response updateResponse;

        private UpdateValueFuture(Location location) {
            this.location = location;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public Response get() throws InterruptedException, ExecutionException {
            this.latch.await();
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            return this.updateResponse;
        }

        @Override
        public Response get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            boolean succeed = this.latch.await(timeout, unit);
            if (!succeed) {
                throw new TimeoutException();
            }
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            return this.updateResponse;
        }

        @Override
        public Response getNow() {
            return this.updateResponse;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.latch.getCount() != 1L;
        }

        @Override
        public void await() throws InterruptedException {
            this.latch.await();
        }

        @Override
        public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
            return this.latch.await(timeout, unit);
        }

        @Override
        public boolean isSuccess() {
            return this.isDone() && this.exception == null;
        }

        @Override
        public Throwable cause() {
            return this.exception;
        }

        private void setResponse(Response response) {
            this.updateResponse = response;
            this.latch.countDown();
            this.notifyListeners();
        }

        private void setException(Throwable t) {
            this.exception = t;
            this.latch.countDown();
            this.notifyListeners();
        }

        @Override
        public void handle(RiakFuture<StoreValue.Response, Location> f) {
            if (!f.isSuccess()) {
                this.setException(f.cause());
                return;
            }
            try {
                StoreValue.Response storeResponse = f.get();
                Response response = ((Response.Builder)((Response.Builder)((Response.Builder)new Response.Builder().withValues(storeResponse.getValues(RiakObject.class))).withLocation(f.getQueryInfo())).withUpdated(true)).build();
                this.setResponse(response);
            }
            catch (InterruptedException | ExecutionException ex) {
                this.setException(ex);
            }
        }

        @Override
        public Location getQueryInfo() {
            return this.location;
        }
    }

    public static class Builder {
        private final Location location;
        private final Map<FetchValue.Option<?>, Object> fetchOptions = new HashMap();
        private final Map<StoreValue.Option<?>, Object> storeOptions = new HashMap();
        private Update<?> update;
        private TypeReference<?> typeReference;

        public Builder(Location location) {
            this.location = location;
        }

        public <U> Builder withFetchOption(FetchValue.Option<U> option, U value) {
            this.fetchOptions.put(option, value);
            return this;
        }

        public <U> Builder withStoreOption(StoreValue.Option<U> option, U value) {
            this.storeOptions.put(option, value);
            return this;
        }

        public Builder withUpdate(Update<?> update) {
            this.update = update;
            return this;
        }

        public <T> Builder withUpdate(Update<T> update, TypeReference<T> typeReference) {
            this.update = update;
            this.typeReference = typeReference;
            return this;
        }

        public Builder withTimeout(int timeout) {
            this.withFetchOption(FetchValue.Option.TIMEOUT, timeout);
            this.withStoreOption(StoreValue.Option.TIMEOUT, timeout);
            return this;
        }

        public UpdateValue build() {
            return new UpdateValue(this);
        }
    }

    public static abstract class Update<T> {
        private boolean modified = true;

        public abstract T apply(T var1);

        public boolean isModified() {
            return this.modified;
        }

        protected void setModified(boolean modified) {
            this.modified = modified;
        }
    }

    public static class Response
    extends KvResponseBase {
        private final boolean wasUpdated;

        Response(Init<?> builder) {
            super(builder);
            this.wasUpdated = ((Init)builder).wasUpdated;
        }

        public boolean wasUpdated() {
            return this.wasUpdated;
        }

        static class Builder
        extends Init<Builder> {
            Builder() {
            }

            @Override
            protected Builder self() {
                return this;
            }

            @Override
            Response build() {
                return new Response(this);
            }
        }

        protected static abstract class Init<T extends Init<T>>
        extends KvResponseBase.Init<T> {
            private boolean wasUpdated;

            protected Init() {
            }

            T withUpdated(boolean updated) {
                this.wasUpdated = updated;
                return (T)((Init)this.self());
            }
        }
    }
}

