/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.mapreduce;

import com.basho.riak.client.api.commands.mapreduce.FunctionPhase;
import com.basho.riak.client.core.query.functions.Function;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;

class FunctionPhaseSerializer
extends JsonSerializer<FunctionPhase> {
    FunctionPhaseSerializer() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writePhaseFunction(JsonGenerator jg, FunctionPhase phase) throws IOException {
        Function function = phase.getFunction();
        jg.writeStartObject();
        jg.writeStringField("language", function.isJavascript() ? "javascript" : "erlang");
        if (function.isJavascript()) {
            if (function.isNamed()) {
                jg.writeStringField("name", function.getName());
            } else if (function.isStored()) {
                jg.writeStringField("bucket", function.getBucket());
                jg.writeStringField("key", function.getKey());
            } else {
                if (!function.isAnonymous()) throw new IllegalStateException("Cannot determine function type");
                jg.writeStringField("source", function.getSource());
            }
        } else if (!function.isJavascript()) {
            jg.writeStringField("module", function.getModule());
            jg.writeStringField("function", function.getFunction());
        }
        jg.writeBooleanField("keep", phase.isKeep().booleanValue());
        jg.writeObjectField("arg", phase.getArg());
        jg.writeEndObject();
    }

    public void serialize(FunctionPhase phase, JsonGenerator jg, SerializerProvider sp) throws IOException {
        jg.writeStartObject();
        jg.writeFieldName(phase.getType().toString());
        this.writePhaseFunction(jg, phase);
        jg.writeEndObject();
    }
}

