/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.timeseries;

import com.basho.riak.client.api.AsIsRiakCommand;
import com.basho.riak.client.core.operations.ts.ListKeysOperation;
import com.basho.riak.client.core.query.timeseries.QueryResult;

public class ListKeys
extends AsIsRiakCommand<QueryResult, String> {
    private final String tableName;
    private final int timeout;

    private ListKeys(Builder builder) {
        this.tableName = builder.tableName;
        this.timeout = builder.timeout;
    }

    protected ListKeysOperation buildCoreOperation() {
        ListKeysOperation.Builder builder = new ListKeysOperation.Builder(this.tableName);
        if (this.timeout > 0) {
            builder.withTimeout(this.timeout);
        }
        return builder.build();
    }

    public static class Builder {
        private final String tableName;
        private int timeout;

        public Builder(String tableName) {
            this.tableName = tableName;
        }

        public Builder withTimeout(int timeout) {
            if (timeout < 1) {
                throw new IllegalArgumentException("Timeout must be a positive integer");
            }
            this.timeout = timeout;
            return this;
        }

        public ListKeys build() {
            return new ListKeys(this);
        }
    }
}

