/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.timeseries;

import com.basho.riak.client.api.AsIsRiakCommand;
import com.basho.riak.client.core.operations.ts.QueryOperation;
import com.basho.riak.client.core.query.timeseries.QueryResult;
import com.basho.riak.client.core.util.BinaryValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Query
extends AsIsRiakCommand<QueryResult, String> {
    private final Builder builder;

    private Query(Builder builder) {
        this.builder = builder;
    }

    protected QueryOperation buildCoreOperation() {
        return new QueryOperation.Builder(this.builder.queryText).withCoverageContext(this.builder.coverageContext).build();
    }

    public static class Builder {
        private static final Logger logger = LoggerFactory.getLogger(Builder.class);
        private static final Pattern paramPattern = Pattern.compile("(:[a-zA-Z][0-9a-zA-Z_]*)");
        private final String queryText;
        private final Map<String, BinaryValue> interpolations = new HashMap<String, BinaryValue>();
        private final Set<String> knownParams;
        private byte[] coverageContext = null;

        public Builder(String queryText) {
            if (queryText == null || queryText.isEmpty()) {
                String msg = "Query Text must not be null or empty";
                logger.error(msg);
                throw new IllegalArgumentException(msg);
            }
            this.queryText = queryText;
            Matcher paramMatcher = paramPattern.matcher(queryText);
            if (!paramMatcher.matches()) {
                this.knownParams = Collections.emptySet();
                return;
            }
            this.knownParams = new HashSet<String>(paramMatcher.groupCount());
            for (int i = 0; i < paramMatcher.groupCount(); ++i) {
                this.knownParams.add(paramMatcher.group(i));
            }
        }

        public Builder(String queryText, byte[] coverageContext) {
            this(queryText);
            this.coverageContext = coverageContext;
        }

        private Builder addParameter(String keyString, String key, BinaryValue value) {
            this.checkParamValidity(keyString);
            this.interpolations.put(key, value);
            return this;
        }

        public Builder withCoverageContext(byte[] coverageContext) {
            this.coverageContext = coverageContext;
            return this;
        }

        private void checkParamValidity(String paramName) {
            if (!this.knownParams.contains(paramName)) {
                String msg = "Unknown query parameter: " + paramName;
                logger.error(msg);
                throw new IllegalArgumentException(msg);
            }
        }

        public Query build() {
            return new Query(this);
        }
    }
}

