/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core;

import com.basho.riak.client.core.OperationRetrier;
import com.basho.riak.client.core.RiakFuture;
import com.basho.riak.client.core.RiakFutureListener;
import com.basho.riak.client.core.RiakMessage;
import com.basho.riak.client.core.RiakNode;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FutureOperation<T, U, S>
implements RiakFuture<T, S> {
    private final Logger logger = LoggerFactory.getLogger(FutureOperation.class);
    private final CountDownLatch latch = new CountDownLatch(1);
    private volatile OperationRetrier retrier;
    private volatile int remainingTries = 1;
    private volatile List<U> rawResponses = new LinkedList<U>();
    private volatile Throwable exception;
    private volatile T converted;
    private volatile State state = State.CREATED;
    private volatile RiakNode lastNode;
    private final ReentrantLock listenersLock = new ReentrantLock();
    private final HashSet<RiakFutureListener<T, S>> listeners = new HashSet();
    private volatile boolean listenersFired = false;

    @Override
    public void addListener(RiakFutureListener<T, S> listener) {
        boolean fireNow = false;
        this.listenersLock.lock();
        try {
            if (this.listenersFired) {
                fireNow = true;
            } else {
                this.listeners.add(listener);
            }
        }
        finally {
            this.listenersLock.unlock();
        }
        if (fireNow) {
            listener.handle(this);
        }
    }

    @Override
    public void removeListener(RiakFutureListener<T, S> listener) {
        this.listenersLock.lock();
        try {
            if (!this.listenersFired) {
                this.listeners.remove(listener);
            }
        }
        finally {
            this.listenersLock.unlock();
        }
    }

    private void fireListeners() {
        boolean fireNow = false;
        this.listenersLock.lock();
        try {
            if (!this.listenersFired) {
                fireNow = true;
                this.listenersFired = true;
            }
        }
        finally {
            this.listenersLock.unlock();
        }
        if (fireNow) {
            for (RiakFutureListener<T, S> listener : this.listeners) {
                listener.handle(this);
            }
        }
    }

    final synchronized void setRetrier(OperationRetrier retrier, int numTries) {
        this.stateCheck(State.CREATED);
        this.retrier = retrier;
        this.remainingTries = numTries;
    }

    final RiakNode getLastNode() {
        return this.lastNode;
    }

    final void setLastNode(RiakNode node) {
        this.lastNode = node;
    }

    public final synchronized void setResponse(RiakMessage rawResponse) {
        this.stateCheck(State.CREATED, State.WRITTEN, State.RETRY);
        U decodedMessage = this.decode(rawResponse);
        this.processMessage(decodedMessage);
        this.exception = null;
        if (this.done(decodedMessage)) {
            this.logger.debug("Setting to Cleanup Wait State");
            --this.remainingTries;
            if (this.retrier != null) {
                this.retrier.operationComplete(this, this.remainingTries);
            }
            this.state = State.CLEANUP_WAIT;
        }
    }

    protected void processMessage(U decodedMessage) {
        this.processBatchMessage(decodedMessage);
    }

    protected void processBatchMessage(U decodedMessage) {
        this.rawResponses.add(decodedMessage);
    }

    public final synchronized void setComplete() {
        this.logger.debug("Setting Complete on future");
        this.stateCheck(State.CLEANUP_WAIT);
        this.state = State.COMPLETE;
        this.latch.countDown();
        this.fireListeners();
    }

    protected boolean done(U message) {
        return true;
    }

    final synchronized void setException(Throwable t) {
        this.stateCheck(State.CREATED, State.WRITTEN, State.RETRY);
        this.exception = t;
        --this.remainingTries;
        if (this.remainingTries == 0) {
            this.state = State.CLEANUP_WAIT;
            this.setComplete();
        } else {
            this.state = State.RETRY;
        }
        if (this.retrier != null) {
            this.retrier.operationFailed(this, this.remainingTries);
        }
    }

    public final synchronized Object channelMessage() {
        RiakMessage message = this.createChannelMessage();
        this.state = State.WRITTEN;
        return message;
    }

    @Override
    public final boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public final boolean isCancelled() {
        return this.state == State.CANCELLED;
    }

    @Override
    public final boolean isDone() {
        return this.state == State.COMPLETE || this.state == State.CLEANUP_WAIT;
    }

    @Override
    public final boolean isSuccess() {
        return this.isDone() && this.exception == null;
    }

    @Override
    public final Throwable cause() {
        if (this.isSuccess()) {
            return null;
        }
        return this.exception;
    }

    @Override
    public final T get() throws InterruptedException, ExecutionException {
        this.latch.await();
        this.throwExceptionIfSet();
        if (null == this.converted) {
            this.tryConvertResponse();
        }
        return this.converted;
    }

    private void throwExceptionIfSet() throws ExecutionException {
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
    }

    private void tryConvertResponse() throws ExecutionException {
        try {
            this.converted = this.convert(this.rawResponses);
        }
        catch (IllegalArgumentException ex) {
            this.exception = ex;
            this.throwExceptionIfSet();
        }
    }

    @Override
    public final T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        boolean succeed = this.latch.await(timeout, unit);
        if (!succeed) {
            throw new TimeoutException();
        }
        this.throwExceptionIfSet();
        if (null == this.converted) {
            this.tryConvertResponse();
        }
        return this.converted;
    }

    @Override
    public final T getNow() {
        if (this.latch.getCount() < 1L) {
            if (null == this.converted) {
                this.converted = this.convert(this.rawResponses);
            }
            return this.converted;
        }
        return null;
    }

    @Override
    public final void await() throws InterruptedException {
        this.latch.await();
    }

    @Override
    public final boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.latch.await(timeout, unit);
    }

    protected U checkAndGetSingleResponse(List<U> responses) {
        if (responses.size() > 1) {
            LoggerFactory.getLogger(this.getClass()).error("Received {} responses when only one was expected.", (Object)responses.size());
        }
        return responses.get(0);
    }

    private void stateCheck(State ... allowedStates) {
        if (Arrays.binarySearch((Object[])allowedStates, (Object)this.state) < 0) {
            this.logger.debug("IllegalStateException; required: {} current: {} ", (Object)Arrays.toString((Object[])allowedStates), (Object)this.state);
            throw new IllegalStateException("required: " + Arrays.toString((Object[])allowedStates) + " current: " + (Object)((Object)this.state));
        }
    }

    protected abstract T convert(List<U> var1);

    protected abstract RiakMessage createChannelMessage();

    protected abstract U decode(RiakMessage var1);

    @Override
    public abstract S getQueryInfo();

    private static enum State {
        CREATED,
        WRITTEN,
        RETRY,
        COMPLETE,
        CANCELLED,
        CLEANUP_WAIT;

    }
}

