/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.converters;

import com.basho.riak.client.api.cap.BasicVClock;
import com.basho.riak.client.core.query.RiakObject;
import com.basho.riak.client.core.query.UserMetadata.RiakUserMetadata;
import com.basho.riak.client.core.query.indexes.IndexType;
import com.basho.riak.client.core.query.indexes.RawIndex;
import com.basho.riak.client.core.query.indexes.RiakIndex;
import com.basho.riak.client.core.query.indexes.RiakIndexes;
import com.basho.riak.client.core.query.links.RiakLink;
import com.basho.riak.client.core.query.links.RiakLinks;
import com.basho.riak.client.core.util.BinaryValue;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.basho.riak.protobuf.RiakKvPB;
import shaded.com.basho.riak.protobuf.RiakPB;
import shaded.com.google.protobuf.ByteString;

public class RiakObjectConverter {
    private static final Logger logger = LoggerFactory.getLogger(RiakObjectConverter.class);

    private RiakObjectConverter() {
    }

    public static List<RiakObject> convert(List<RiakKvPB.RpbContent> contentList, ByteString contentVClock) {
        LinkedList<RiakObject> roList = new LinkedList<RiakObject>();
        BasicVClock vclock = new BasicVClock(contentVClock.toByteArray());
        for (RiakKvPB.RpbContent content : contentList) {
            RiakObject ro = new RiakObject();
            ro.setVClock(vclock);
            if (content.hasDeleted()) {
                ro.setDeleted(content.getDeleted());
            }
            if (content.hasContentType()) {
                ro.setContentType(content.getContentType().toStringUtf8());
            }
            if (content.hasCharset()) {
                ro.setCharset(content.getCharset().toStringUtf8());
            }
            if (content.hasLastMod()) {
                int lastMod = content.getLastMod();
                int lastModUsec = content.getLastModUsecs();
                ro.setLastModified((long)lastMod * 1000L + (long)lastModUsec / 1000L);
            }
            if (content.hasValue() && !content.getValue().isEmpty()) {
                ro.setValue(BinaryValue.unsafeCreate(content.getValue().toByteArray()));
            }
            if (content.hasVtag()) {
                ro.setVTag(content.getVtag().toStringUtf8());
            }
            if (content.getLinksCount() > 0) {
                List<RiakKvPB.RpbLink> pbLinkList = content.getLinksList();
                RiakLinks riakLinks = ro.getLinks();
                for (RiakKvPB.RpbLink pbLink : pbLinkList) {
                    RiakLink link = new RiakLink(pbLink.getBucket().toStringUtf8(), pbLink.getKey().toStringUtf8(), pbLink.getTag().toStringUtf8());
                    riakLinks.addLink(link);
                }
            }
            if (content.getIndexesCount() > 0) {
                RiakIndexes indexes = ro.getIndexes();
                for (RiakPB.RpbPair p : content.getIndexesList()) {
                    String name = p.getKey().toStringUtf8();
                    try {
                        IndexType type = IndexType.typeFromFullname(name);
                        ((RawIndex)indexes.getIndex(RawIndex.named(name, type))).add(BinaryValue.unsafeCreate(p.getValue().toByteArray()));
                    }
                    catch (IllegalArgumentException e) {
                        logger.error("Unknown index type during conversion: {};{}", (Object)name, (Object)e);
                    }
                }
            }
            if (content.getUsermetaCount() > 0) {
                RiakUserMetadata userMeta = ro.getUserMeta();
                for (int j = 0; j < content.getUsermetaCount(); ++j) {
                    RiakPB.RpbPair pair = content.getUsermeta(j);
                    userMeta.put(BinaryValue.unsafeCreate(pair.getKey().toByteArray()), BinaryValue.unsafeCreate(pair.getValue().toByteArray()));
                }
            }
            roList.add(ro);
        }
        return roList;
    }

    public static RiakKvPB.RpbContent convert(RiakObject ro) {
        RiakKvPB.RpbContent.Builder builder = RiakKvPB.RpbContent.newBuilder();
        builder.setContentType(ByteString.copyFromUtf8(ro.getContentType()));
        if (ro.hasCharset()) {
            builder.setCharset(ByteString.copyFromUtf8(ro.getCharset()));
        }
        if (ro.hasValue()) {
            builder.setValue(ByteString.copyFrom(ro.getValue().unsafeGetValue()));
        }
        if (ro.hasLinks()) {
            for (RiakLink riakLink : ro.getLinks()) {
                builder.addLinks(RiakKvPB.RpbLink.newBuilder().setBucket(ByteString.copyFrom(riakLink.getBucketAsBytes().unsafeGetValue())).setTag(ByteString.copyFrom(riakLink.getTagAsBytes().unsafeGetValue())).setKey(ByteString.copyFrom(riakLink.getKeyAsBytes().unsafeGetValue())));
            }
        }
        if (ro.hasIndexes()) {
            for (RiakIndex riakIndex : ro.getIndexes()) {
                for (BinaryValue value : riakIndex.rawValues()) {
                    RiakPB.RpbPair.Builder pair = RiakPB.RpbPair.newBuilder();
                    pair.setKey(ByteString.copyFrom(riakIndex.getFullname().getBytes()));
                    pair.setValue(ByteString.copyFrom(value.unsafeGetValue()));
                    builder.addIndexes(pair);
                }
            }
        }
        if (ro.hasUserMeta()) {
            for (Map.Entry entry : ro.getUserMeta().getUserMetadata()) {
                RiakPB.RpbPair.Builder pair = RiakPB.RpbPair.newBuilder();
                pair.setKey(ByteString.copyFrom(((BinaryValue)entry.getKey()).unsafeGetValue()));
                pair.setValue(ByteString.copyFrom(((BinaryValue)entry.getValue()).unsafeGetValue()));
                builder.addUsermeta(pair);
            }
        }
        return builder.build();
    }
}

