/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.netty;

import com.basho.riak.client.core.RiakMessage;
import com.basho.riak.client.core.netty.RiakResponseException;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLHandshakeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.basho.riak.protobuf.RiakPB;
import shaded.com.google.protobuf.ByteString;
import shaded.com.google.protobuf.InvalidProtocolBufferException;

public class RiakSecurityDecoder
extends ByteToMessageDecoder {
    private final CountDownLatch promiseLatch = new CountDownLatch(1);
    private final SSLEngine sslEngine;
    private final String username;
    private final String password;
    private final Logger logger = LoggerFactory.getLogger(RiakSecurityDecoder.class);
    private volatile DefaultPromise<Void> promise;
    private volatile State state = State.TLS_START;

    public RiakSecurityDecoder(SSLEngine engine, String username, String password) {
        this.sslEngine = engine;
        this.username = username;
        this.password = password;
    }

    protected void decode(ChannelHandlerContext chc, ByteBuf in, List<Object> out) throws Exception {
        this.logger.debug("RiakSecurityDecoder decode");
        if (in.readableBytes() >= 4) {
            in.markReaderIndex();
            int length = in.readInt();
            if (in.readableBytes() < length) {
                in.resetReaderIndex();
            } else {
                byte code = in.readByte();
                byte[] protobuf = new byte[length - 1];
                in.readBytes(protobuf);
                block0 : switch (this.state) {
                    case TLS_WAIT: {
                        switch (code) {
                            case -1: {
                                this.logger.debug("Received MSG_RpbStartTls reply");
                                this.state = State.SSL_WAIT;
                                SslHandler sslHandler = new SslHandler(this.sslEngine);
                                Future hsFuture = sslHandler.handshakeFuture();
                                hsFuture.addListener((GenericFutureListener)new SslListener());
                                chc.channel().pipeline().addFirst("sslHandler", (ChannelHandler)sslHandler);
                                break block0;
                            }
                            case 0: {
                                this.logger.debug("Received MSG_ErrorResp reply to startTls");
                                this.promise.tryFailure((Throwable)this.riakErrorToException(protobuf));
                                break block0;
                            }
                        }
                        this.promise.tryFailure((Throwable)new RiakResponseException(0, "Invalid return code during StartTLS; " + code));
                        break;
                    }
                    case AUTH_WAIT: {
                        chc.channel().pipeline().remove((ChannelHandler)this);
                        switch (code) {
                            case -2: {
                                this.logger.debug("Received MSG_RpbAuthResp reply");
                                this.promise.trySuccess(null);
                                break block0;
                            }
                            case 0: {
                                this.logger.debug("Received MSG_ErrorResp reply to auth");
                                this.promise.tryFailure((Throwable)this.riakErrorToException(protobuf));
                                break block0;
                            }
                        }
                        this.promise.tryFailure((Throwable)new RiakResponseException(0, "Invalid return code during Auth; " + code));
                        break;
                    }
                    default: {
                        this.logger.error("Received message while not in TLS_WAIT or AUTH_WAIT");
                        this.promise.tryFailure((Throwable)new IllegalStateException("Received message while not in TLS_WAIT or AUTH_WAIT"));
                    }
                }
            }
        }
    }

    private RiakResponseException riakErrorToException(byte[] protobuf) {
        try {
            RiakPB.RpbErrorResp error = RiakPB.RpbErrorResp.parseFrom(protobuf);
            return new RiakResponseException(error.getErrcode(), error.getErrmsg().toStringUtf8());
        }
        catch (InvalidProtocolBufferException ex) {
            return null;
        }
    }

    private void init(ChannelHandlerContext ctx) {
        this.state = State.TLS_WAIT;
        this.promise = new DefaultPromise(ctx.executor());
        this.promiseLatch.countDown();
        ctx.channel().writeAndFlush((Object)new RiakMessage(-1, new byte[0]));
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.logger.debug("Handler Added");
        if (ctx.channel().isActive()) {
            this.init(ctx);
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.logger.debug("Channel Active");
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.logger.debug("Channel Inactive");
        this.promise.tryFailure((Throwable)new IOException("Channel closed during auth"));
        ctx.fireChannelInactive();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.logger.debug("Exception Caught: {}", cause);
        if (!(cause.getCause() instanceof SSLHandshakeException)) {
            ctx.fireExceptionCaught(cause);
        }
    }

    public DefaultPromise<Void> getPromise() throws InterruptedException {
        this.promiseLatch.await();
        return this.promise;
    }

    private class SslListener
    implements GenericFutureListener<Future<Channel>> {
        private SslListener() {
        }

        public void operationComplete(Future<Channel> future) throws Exception {
            if (future.isSuccess()) {
                RiakSecurityDecoder.this.logger.debug("SSL Handshake success!");
                Channel c = (Channel)future.getNow();
                RiakSecurityDecoder.this.state = State.AUTH_WAIT;
                RiakPB.RpbAuthReq authReq = RiakPB.RpbAuthReq.newBuilder().setUser(ByteString.copyFromUtf8(RiakSecurityDecoder.this.username)).setPassword(ByteString.copyFromUtf8(RiakSecurityDecoder.this.password)).build();
                c.writeAndFlush((Object)new RiakMessage(-3, authReq.toByteArray()));
            } else {
                RiakSecurityDecoder.this.logger.error("SSL Handshake failed: ", future.cause());
                RiakSecurityDecoder.this.promise.tryFailure(future.cause());
            }
        }
    }

    private static enum State {
        TLS_START,
        TLS_WAIT,
        SSL_WAIT,
        AUTH_WAIT;

    }
}

