/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.operations;

import com.basho.riak.client.api.cap.VClock;
import com.basho.riak.client.core.FutureOperation;
import com.basho.riak.client.core.RiakMessage;
import com.basho.riak.client.core.operations.Operations;
import com.basho.riak.client.core.query.Location;
import java.util.List;
import shaded.com.basho.riak.protobuf.RiakKvPB;
import shaded.com.google.protobuf.ByteString;

public class DeleteOperation
extends FutureOperation<Void, Void, Location> {
    private final RiakKvPB.RpbDelReq.Builder reqBuilder;
    private final Location location;

    private DeleteOperation(Builder builder) {
        this.reqBuilder = builder.reqBuilder;
        this.location = builder.location;
    }

    @Override
    protected Void convert(List<Void> rawResponse) {
        return null;
    }

    @Override
    protected Void decode(RiakMessage rawResponse) {
        Operations.checkPBMessageType(rawResponse, (byte)14);
        return null;
    }

    @Override
    protected RiakMessage createChannelMessage() {
        return new RiakMessage(13, this.reqBuilder.build().toByteArray());
    }

    @Override
    public Location getQueryInfo() {
        return this.location;
    }

    public static class Builder {
        private final Location location;
        private final RiakKvPB.RpbDelReq.Builder reqBuilder = RiakKvPB.RpbDelReq.newBuilder();

        public Builder(Location location) {
            if (location == null) {
                throw new IllegalArgumentException("Location can not be null");
            }
            this.reqBuilder.setBucket(ByteString.copyFrom(location.getNamespace().getBucketName().unsafeGetValue()));
            this.reqBuilder.setKey(ByteString.copyFrom(location.getKey().unsafeGetValue()));
            this.reqBuilder.setType(ByteString.copyFrom(location.getNamespace().getBucketType().unsafeGetValue()));
            this.location = location;
        }

        public Builder withR(int r) {
            this.reqBuilder.setR(r);
            return this;
        }

        public Builder withPr(int pr) {
            this.reqBuilder.setPr(pr);
            return this;
        }

        public Builder withW(int w) {
            this.reqBuilder.setW(w);
            return this;
        }

        public Builder withDw(int dw) {
            this.reqBuilder.setDw(dw);
            return this;
        }

        public Builder withPw(int pw) {
            this.reqBuilder.setPw(pw);
            return this;
        }

        public Builder withRw(int rw) {
            this.reqBuilder.setRw(rw);
            return this;
        }

        public Builder withVclock(VClock vclock) {
            this.reqBuilder.setVclock(ByteString.copyFrom(vclock.getBytes()));
            return this;
        }

        public Builder withTimeout(int timeout) {
            this.reqBuilder.setTimeout(timeout);
            return this;
        }

        public Builder withNVal(int nval) {
            this.reqBuilder.setNVal(nval);
            return this;
        }

        public Builder withSloppyQuorum(boolean sloppyQuorum) {
            this.reqBuilder.setSloppyQuorum(sloppyQuorum);
            return this;
        }

        public DeleteOperation build() {
            return new DeleteOperation(this);
        }
    }
}

