/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.operations;

import com.basho.riak.client.api.cap.BasicVClock;
import com.basho.riak.client.core.FutureOperation;
import com.basho.riak.client.core.RiakMessage;
import com.basho.riak.client.core.converters.RiakObjectConverter;
import com.basho.riak.client.core.operations.Operations;
import com.basho.riak.client.core.query.Location;
import com.basho.riak.client.core.query.RiakObject;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.basho.riak.protobuf.RiakKvPB;
import shaded.com.google.protobuf.ByteString;
import shaded.com.google.protobuf.InvalidProtocolBufferException;

public class FetchOperation
extends FutureOperation<Response, RiakKvPB.RpbGetResp, Location> {
    private final RiakKvPB.RpbGetReq.Builder reqBuilder;
    Location location;
    private final Logger logger = LoggerFactory.getLogger(FetchOperation.class);

    private FetchOperation(Builder builder) {
        this.reqBuilder = builder.reqBuilder;
        this.location = builder.location;
    }

    @Override
    protected RiakKvPB.RpbGetResp decode(RiakMessage message) {
        Operations.checkPBMessageType(message, (byte)10);
        try {
            byte[] data = message.getData();
            if (data.length == 0) {
                return null;
            }
            return RiakKvPB.RpbGetResp.parseFrom(data);
        }
        catch (InvalidProtocolBufferException e) {
            this.logger.error("Invalid message received; {}", (Throwable)e);
            throw new IllegalArgumentException("Invalid message received", e);
        }
    }

    @Override
    protected Response convert(List<RiakKvPB.RpbGetResp> responses) {
        if (responses.size() > 1) {
            this.logger.error("Received {} responses when only one was expected.", (Object)responses.size());
        }
        RiakKvPB.RpbGetResp response = responses.get(0);
        return FetchOperation.convert(response);
    }

    static Response convert(RiakKvPB.RpbGetResp response) {
        Response.Builder responseBuilder = new Response.Builder();
        if (null == response) {
            responseBuilder.withNotFound(true);
        } else {
            if (response.getContentCount() == 0) {
                RiakObject ro = new RiakObject().setDeleted(true).setVClock(new BasicVClock(response.getVclock().toByteArray()));
                responseBuilder.addObject(ro);
            } else {
                responseBuilder.addObjects(RiakObjectConverter.convert(response.getContentList(), response.getVclock()));
            }
            responseBuilder.withUnchanged(response.hasUnchanged() ? response.getUnchanged() : false);
        }
        return responseBuilder.build();
    }

    @Override
    protected RiakMessage createChannelMessage() {
        RiakKvPB.RpbGetReq req = this.reqBuilder.build();
        return new RiakMessage(9, req.toByteArray());
    }

    @Override
    public Location getQueryInfo() {
        return this.location;
    }

    public static class Response
    extends KvResponseBase {
        private final boolean notFound;
        private final boolean unchanged;

        private Response(Init<?> builder) {
            super(builder);
            this.notFound = ((Init)builder).notFound;
            this.unchanged = ((Init)builder).unchanged;
        }

        public boolean isNotFound() {
            return this.notFound;
        }

        public boolean isUnchanged() {
            return this.unchanged;
        }

        static class Builder
        extends Init<Builder> {
            Builder() {
            }

            @Override
            protected Builder self() {
                return this;
            }

            @Override
            protected Response build() {
                return new Response(this);
            }
        }

        protected static abstract class Init<T extends Init<T>>
        extends KvResponseBase.Init<T> {
            private boolean notFound;
            private boolean unchanged;

            protected Init() {
            }

            T withNotFound(boolean notFound) {
                this.notFound = notFound;
                return (T)((Init)this.self());
            }

            T withUnchanged(boolean unchanged) {
                this.unchanged = unchanged;
                return (T)((Init)this.self());
            }
        }
    }

    protected static abstract class KvResponseBase {
        private final List<RiakObject> objectList;

        protected KvResponseBase(Init<?> builder) {
            this.objectList = ((Init)builder).objectList;
        }

        public List<RiakObject> getObjectList() {
            return this.objectList;
        }

        protected static abstract class Init<T extends Init<T>> {
            private final List<RiakObject> objectList = new LinkedList<RiakObject>();

            protected Init() {
            }

            protected abstract T self();

            protected abstract KvResponseBase build();

            T addObject(RiakObject object) {
                this.objectList.add(object);
                return this.self();
            }

            T addObjects(List<RiakObject> objects) {
                this.objectList.addAll(objects);
                return this.self();
            }
        }
    }

    public static class Builder {
        private final RiakKvPB.RpbGetReq.Builder reqBuilder = RiakKvPB.RpbGetReq.newBuilder();
        private final Location location;

        public Builder(Location location) {
            if (location == null) {
                throw new IllegalArgumentException("Location can not be null.");
            }
            this.reqBuilder.setKey(ByteString.copyFrom(location.getKey().unsafeGetValue()));
            this.reqBuilder.setBucket(ByteString.copyFrom(location.getNamespace().getBucketName().unsafeGetValue()));
            this.reqBuilder.setType(ByteString.copyFrom(location.getNamespace().getBucketType().unsafeGetValue()));
            this.location = location;
        }

        public Builder withR(int r) {
            this.reqBuilder.setR(r);
            return this;
        }

        public Builder withPr(int pr) {
            this.reqBuilder.setPr(pr);
            return this;
        }

        public Builder withNotFoundOK(boolean notFoundOk) {
            this.reqBuilder.setNotfoundOk(notFoundOk);
            return this;
        }

        public Builder withBasicQuorum(boolean useBasicQuorum) {
            this.reqBuilder.setBasicQuorum(useBasicQuorum);
            return this;
        }

        public Builder withReturnDeletedVClock(boolean returnDeletedVClock) {
            this.reqBuilder.setDeletedvclock(returnDeletedVClock);
            return this;
        }

        public Builder withHeadOnly(boolean headOnly) {
            this.reqBuilder.setHead(headOnly);
            return this;
        }

        public Builder withIfNotModified(byte[] vclock) {
            this.reqBuilder.setIfModified(ByteString.copyFrom(vclock));
            return this;
        }

        public Builder withTimeout(int timeout) {
            this.reqBuilder.setTimeout(timeout);
            return this;
        }

        public Builder withNVal(int nval) {
            this.reqBuilder.setNVal(nval);
            return this;
        }

        public Builder withSloppyQuorum(boolean sloppyQuorum) {
            this.reqBuilder.setSloppyQuorum(sloppyQuorum);
            return this;
        }

        public FetchOperation build() {
            return new FetchOperation(this);
        }
    }
}

