/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.operations;

import com.basho.riak.client.core.PBStreamingFutureOperation;
import com.basho.riak.client.core.util.BinaryValue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import shaded.com.basho.riak.protobuf.RiakKvPB;
import shaded.com.google.protobuf.ByteString;

public class ListBucketsOperation
extends PBStreamingFutureOperation<Response, RiakKvPB.RpbListBucketsResp, BinaryValue> {
    private final BinaryValue bucketType;

    private ListBucketsOperation(Builder builder) {
        super((byte)15, (byte)16, builder.reqBuilder, RiakKvPB.RpbListBucketsResp.PARSER, builder.streamResults);
        this.bucketType = builder.bucketType;
    }

    @Override
    protected boolean done(RiakKvPB.RpbListBucketsResp message) {
        return message.getDone();
    }

    @Override
    protected Response convert(List<RiakKvPB.RpbListBucketsResp> rawResponse) {
        ArrayList<BinaryValue> buckets = new ArrayList<BinaryValue>(rawResponse.size());
        for (RiakKvPB.RpbListBucketsResp resp : rawResponse) {
            buckets.addAll(this.convertSingleResponse(resp));
        }
        return new Response(this.bucketType, buckets);
    }

    private List<BinaryValue> convertSingleResponse(RiakKvPB.RpbListBucketsResp resp) {
        ArrayList<BinaryValue> buckets = new ArrayList<BinaryValue>(resp.getBucketsCount());
        for (ByteString bucket : resp.getBucketsList()) {
            buckets.add(BinaryValue.unsafeCreate(bucket.toByteArray()));
        }
        return buckets;
    }

    @Override
    protected Response processStreamingChunk(RiakKvPB.RpbListBucketsResp rawResponseChunk) {
        List<BinaryValue> buckets = this.convertSingleResponse(rawResponseChunk);
        return new Response(this.bucketType, buckets);
    }

    @Override
    public BinaryValue getQueryInfo() {
        return this.bucketType;
    }

    public static class Response
    implements Iterable<BinaryValue> {
        private final BinaryValue bucketType;
        private final List<BinaryValue> buckets;

        Response(BinaryValue bucketType, List<BinaryValue> buckets) {
            this.bucketType = bucketType;
            this.buckets = buckets;
        }

        public BinaryValue getBucketType() {
            return this.bucketType;
        }

        public List<BinaryValue> getBuckets() {
            return this.buckets;
        }

        @Override
        public Iterator<BinaryValue> iterator() {
            return this.getBuckets().iterator();
        }
    }

    public static class Builder {
        private final RiakKvPB.RpbListBucketsReq.Builder reqBuilder = RiakKvPB.RpbListBucketsReq.newBuilder().setStream(true);
        private boolean streamResults = false;
        private BinaryValue bucketType = BinaryValue.create("default");

        public Builder withTimeout(int timeout) {
            if (timeout <= 0) {
                throw new IllegalArgumentException("Timeout can not be zero or less.");
            }
            this.reqBuilder.setTimeout(timeout);
            return this;
        }

        public Builder withBucketType(BinaryValue bucketType) {
            if (null == bucketType || bucketType.length() == 0) {
                throw new IllegalArgumentException("Bucket type can not be null or zero length");
            }
            this.reqBuilder.setType(ByteString.copyFrom(bucketType.unsafeGetValue()));
            this.bucketType = bucketType;
            return this;
        }

        public Builder streamResults(boolean streamResults) {
            this.streamResults = streamResults;
            return this;
        }

        public ListBucketsOperation build() {
            return new ListBucketsOperation(this);
        }
    }
}

