/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.operations;

import com.basho.riak.client.core.PBStreamingFutureOperation;
import com.basho.riak.client.core.query.Namespace;
import com.basho.riak.client.core.util.BinaryValue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import shaded.com.basho.riak.protobuf.RiakKvPB;
import shaded.com.google.protobuf.ByteString;

public class ListKeysOperation
extends PBStreamingFutureOperation<Response, RiakKvPB.RpbListKeysResp, Namespace> {
    private final Namespace namespace;

    private ListKeysOperation(Builder builder) {
        super((byte)17, (byte)18, builder.reqBuilder, RiakKvPB.RpbListKeysResp.PARSER, builder.streamResults);
        this.namespace = builder.namespace;
    }

    @Override
    protected Response convert(List<RiakKvPB.RpbListKeysResp> rawResponse) {
        Response.Builder builder = new Response.Builder();
        for (RiakKvPB.RpbListKeysResp resp : rawResponse) {
            builder.addKeys(this.convertSingleResponse(resp));
        }
        return builder.build();
    }

    private List<BinaryValue> convertSingleResponse(RiakKvPB.RpbListKeysResp resp) {
        ArrayList<BinaryValue> keys = new ArrayList<BinaryValue>(resp.getKeysCount());
        for (ByteString key : resp.getKeysList()) {
            keys.add(BinaryValue.unsafeCreate(key.toByteArray()));
        }
        return keys;
    }

    @Override
    protected boolean done(RiakKvPB.RpbListKeysResp message) {
        return message.getDone();
    }

    @Override
    public Namespace getQueryInfo() {
        return this.namespace;
    }

    @Override
    protected Response processStreamingChunk(RiakKvPB.RpbListKeysResp rawResponseChunk) {
        return new Response.Builder().addKeys(this.convertSingleResponse(rawResponseChunk)).build();
    }

    public static class Response
    implements Iterable<BinaryValue> {
        private final List<BinaryValue> keys;

        private Response(Builder builder) {
            this.keys = builder.keys;
        }

        public List<BinaryValue> getKeys() {
            return this.keys;
        }

        @Override
        public Iterator<BinaryValue> iterator() {
            return this.keys.iterator();
        }

        static class Builder {
            private List<BinaryValue> keys = new ArrayList<BinaryValue>();

            Builder() {
            }

            Builder addKeys(List<BinaryValue> keys) {
                this.keys.addAll(keys);
                return this;
            }

            Builder addKey(BinaryValue key) {
                this.keys.add(key);
                return this;
            }

            Response build() {
                return new Response(this);
            }
        }
    }

    public static class Builder {
        private final RiakKvPB.RpbListKeysReq.Builder reqBuilder = RiakKvPB.RpbListKeysReq.newBuilder();
        private final Namespace namespace;
        private boolean streamResults;

        public Builder(Namespace namespace) {
            if (namespace == null) {
                throw new IllegalArgumentException("Namespace cannot be null");
            }
            this.reqBuilder.setBucket(ByteString.copyFrom(namespace.getBucketName().unsafeGetValue()));
            this.reqBuilder.setType(ByteString.copyFrom(namespace.getBucketType().unsafeGetValue()));
            this.namespace = namespace;
        }

        public Builder withTimeout(int timeout) {
            if (timeout <= 0) {
                throw new IllegalArgumentException("Timeout can not be zero or less");
            }
            this.reqBuilder.setTimeout(timeout);
            return this;
        }

        public Builder streamResults(boolean streamResults) {
            this.streamResults = streamResults;
            return this;
        }

        public ListKeysOperation build() {
            return new ListKeysOperation(this);
        }
    }
}

