/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.operations;

import com.basho.riak.client.core.PBStreamingFutureOperation;
import com.basho.riak.client.core.util.BinaryValue;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.basho.riak.protobuf.RiakKvPB;
import shaded.com.google.protobuf.ByteString;

public class MapReduceOperation
extends PBStreamingFutureOperation<Response, RiakKvPB.RpbMapRedResp, BinaryValue> {
    private final BinaryValue mapReduce;
    private final Logger logger = LoggerFactory.getLogger(MapReduceOperation.class);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final JsonNodeFactory jsonNodeFactory = JsonNodeFactory.instance;

    private MapReduceOperation(Builder builder) {
        super((byte)23, (byte)24, builder.reqBuilder, RiakKvPB.RpbMapRedResp.PARSER, builder.streamResults);
        this.mapReduce = builder.mapReduce;
    }

    @Override
    protected Response convert(List<RiakKvPB.RpbMapRedResp> rawResponse) {
        LinkedHashMap<Integer, ArrayNode> resultMap = new LinkedHashMap<Integer, ArrayNode>();
        for (RiakKvPB.RpbMapRedResp response : rawResponse) {
            this.convertSingleResponse(resultMap, response);
        }
        return new Response(resultMap);
    }

    private void convertSingleResponse(Map<Integer, ArrayNode> resultMap, RiakKvPB.RpbMapRedResp response) {
        int phase = 0;
        if (response.hasPhase()) {
            phase = response.getPhase();
        }
        if (response.hasResponse()) {
            JsonNode responseJson;
            ArrayNode jsonArray;
            if (resultMap.containsKey(phase)) {
                jsonArray = resultMap.get(phase);
            } else {
                jsonArray = this.jsonNodeFactory.arrayNode();
                resultMap.put(phase, jsonArray);
            }
            try {
                responseJson = this.objectMapper.readTree(response.getResponse().toStringUtf8());
            }
            catch (IOException ex) {
                this.logger.error("Mapreduce job returned non-JSON; {}", (Object)response.getResponse().toStringUtf8());
                throw new RuntimeException("Non-JSON response from MR job", ex);
            }
            if (responseJson.isArray()) {
                jsonArray.addAll((ArrayNode)responseJson);
            } else {
                this.logger.error("Mapreduce job returned JSON that wasn't an array; {}", (Object)response.getResponse().toStringUtf8());
            }
        }
    }

    @Override
    protected boolean done(RiakKvPB.RpbMapRedResp message) {
        return message.getDone();
    }

    @Override
    public BinaryValue getQueryInfo() {
        return this.mapReduce;
    }

    @Override
    protected Response processStreamingChunk(RiakKvPB.RpbMapRedResp rawResponseChunk) {
        LinkedHashMap<Integer, ArrayNode> resultMap = new LinkedHashMap<Integer, ArrayNode>();
        this.convertSingleResponse(resultMap, rawResponseChunk);
        return new Response(resultMap);
    }

    public static class Response {
        private final Map<Integer, ArrayNode> resultMap;

        Response(Map<Integer, ArrayNode> results) {
            this.resultMap = results;
        }

        public Map<Integer, ArrayNode> getResults() {
            return this.resultMap;
        }
    }

    public static class Builder {
        private final RiakKvPB.RpbMapRedReq.Builder reqBuilder = RiakKvPB.RpbMapRedReq.newBuilder();
        private final BinaryValue mapReduce;
        private boolean streamResults;

        public Builder(BinaryValue mapReduce) {
            if (null == mapReduce || mapReduce.length() == 0) {
                throw new IllegalArgumentException("MapReduce can not be null or empty.");
            }
            this.reqBuilder.setRequest(ByteString.copyFrom(mapReduce.unsafeGetValue())).setContentType(ByteString.copyFromUtf8("application/json"));
            this.mapReduce = mapReduce;
        }

        public Builder streamResults(boolean streamResults) {
            this.streamResults = streamResults;
            return this;
        }

        public MapReduceOperation build() {
            return new MapReduceOperation(this);
        }
    }
}

