/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.operations;

import com.basho.riak.client.core.FutureOperation;
import com.basho.riak.client.core.RiakMessage;
import com.basho.riak.client.core.operations.Operations;
import org.slf4j.LoggerFactory;
import shaded.com.google.protobuf.GeneratedMessage;
import shaded.com.google.protobuf.InvalidProtocolBufferException;
import shaded.com.google.protobuf.Parser;

public abstract class PBFutureOperation<T, U, S>
extends FutureOperation<T, U, S> {
    protected final GeneratedMessage.Builder<?> reqBuilder;
    private final Parser<U> respParser;
    protected final byte reqMessageCode;
    private final byte respMessageCode;

    protected PBFutureOperation(byte reqMessageCode, byte respMessageCode, GeneratedMessage.Builder<?> reqBuilder, Parser<U> respParser) {
        this.reqBuilder = reqBuilder;
        this.respParser = respParser;
        this.reqMessageCode = reqMessageCode;
        this.respMessageCode = respMessageCode;
    }

    @Override
    protected RiakMessage createChannelMessage() {
        return new RiakMessage(this.reqMessageCode, this.reqBuilder.build().toByteArray());
    }

    @Override
    protected U decode(RiakMessage rawMessage) {
        Operations.checkPBMessageType(rawMessage, this.respMessageCode);
        try {
            byte[] data = rawMessage.getData();
            if (data.length == 0) {
                return null;
            }
            return this.respParser.parseFrom(data);
        }
        catch (InvalidProtocolBufferException e) {
            LoggerFactory.getLogger(this.getClass()).error("Invalid message received '{}', whereas the {} code was expected", (Object)rawMessage.getCode(), (Object)this.respMessageCode);
            throw new IllegalArgumentException("Invalid message received", e);
        }
    }
}

