/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.operations;

import com.basho.riak.client.core.PBStreamingFutureOperation;
import com.basho.riak.client.core.RiakMessage;
import com.basho.riak.client.core.operations.FetchOperation;
import com.basho.riak.client.core.query.Namespace;
import com.basho.riak.client.core.util.BinaryValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import shaded.com.basho.riak.protobuf.RiakKvPB;
import shaded.com.basho.riak.protobuf.RiakPB;
import shaded.com.google.protobuf.ByteString;
import shaded.com.google.protobuf.InvalidProtocolBufferException;

public class SecondaryIndexQueryOperation
extends PBStreamingFutureOperation<Response, Object, Query> {
    private final RiakKvPB.RpbIndexReq pbReq;
    private final Query query;

    private SecondaryIndexQueryOperation(Builder builder) {
        super((byte)25, (byte)26, builder.pbReqBuilder, null, builder.streamResults);
        builder.pbReqBuilder.setStream(true);
        this.query = builder.query;
        this.pbReq = builder.pbReqBuilder.build();
    }

    @Override
    protected Response convert(List<Object> rawResponse) {
        Response.Builder responseBuilder = new Response.Builder();
        boolean isIndexBodyResp = rawResponse != null && !rawResponse.isEmpty() && this.objectIsIndexBodyResp(rawResponse.get(0));
        for (Object o : rawResponse) {
            this.convertSingleResponse(responseBuilder, isIndexBodyResp, o);
        }
        return responseBuilder.build();
    }

    private boolean objectIsIndexBodyResp(Object o) {
        return o instanceof RiakKvPB.RpbIndexBodyResp;
    }

    private void convertSingleResponse(Response.Builder responseBuilder, boolean isIndexBodyResp, Object o) {
        if (isIndexBodyResp) {
            this.convertIndexBodyResp(responseBuilder, o);
        } else {
            this.convertIndexResp(responseBuilder, o);
        }
    }

    private void convertIndexBodyResp(Response.Builder responseBuilder, Object o) {
        assert (this.pbReq.getReturnBody());
        RiakKvPB.RpbIndexBodyResp bodyResp = (RiakKvPB.RpbIndexBodyResp)o;
        SecondaryIndexQueryOperation.convertBodies(responseBuilder, bodyResp);
        if (bodyResp.hasContinuation()) {
            responseBuilder.withContinuation(BinaryValue.unsafeCreate(bodyResp.getContinuation().toByteArray()));
        }
    }

    private void convertIndexResp(Response.Builder responseBuilder, Object o) {
        RiakKvPB.RpbIndexResp pbEntry = (RiakKvPB.RpbIndexResp)o;
        if (this.pbReq.getReturnTerms() && !this.query.indexName.toString().equalsIgnoreCase("$key")) {
            this.convertTerms(responseBuilder, pbEntry);
        } else {
            SecondaryIndexQueryOperation.convertKeys(responseBuilder, pbEntry);
        }
        if (pbEntry.hasContinuation()) {
            responseBuilder.withContinuation(BinaryValue.unsafeCreate(pbEntry.getContinuation().toByteArray()));
        }
    }

    private static void convertKeys(Response.Builder builder, RiakKvPB.RpbIndexResp pbEntry) {
        for (ByteString objKey : pbEntry.getKeysList()) {
            builder.addEntry(new Response.Entry(BinaryValue.unsafeCreate(objKey.toByteArray())));
        }
    }

    private static void convertBodies(Response.Builder builder, RiakKvPB.RpbIndexBodyResp resp) {
        for (RiakKvPB.RpbIndexObject io : resp.getObjectsList()) {
            FetchOperation.Response fr = FetchOperation.convert(io.getObject());
            builder.addEntry(new Response.Entry(BinaryValue.unsafeCreate(io.getKey().toByteArray()), fr));
        }
    }

    private void convertTerms(Response.Builder builder, RiakKvPB.RpbIndexResp pbEntry) {
        if (this.pbReq.hasRangeMin()) {
            for (RiakPB.RpbPair pair : pbEntry.getResultsList()) {
                builder.addEntry(new Response.Entry(BinaryValue.unsafeCreate(pair.getKey().toByteArray()), BinaryValue.unsafeCreate(pair.getValue().toByteArray())));
            }
        } else {
            for (ByteString objKey : pbEntry.getKeysList()) {
                builder.addEntry(new Response.Entry(BinaryValue.unsafeCreate(this.pbReq.getKey().toByteArray()), BinaryValue.unsafeCreate(objKey.toByteArray())));
            }
        }
    }

    @Override
    protected Object decode(RiakMessage rawMessage) {
        try {
            if (rawMessage.getCode() == 26) {
                return RiakKvPB.RpbIndexResp.parseFrom(rawMessage.getData());
            }
            if (rawMessage.getCode() == 42) {
                return RiakKvPB.RpbIndexBodyResp.parseFrom(rawMessage.getData());
            }
            throw new IllegalArgumentException("Invalid message received: Wrong response; expected 26 or 42 received " + rawMessage.getCode());
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Invalid message received", e);
        }
    }

    @Override
    protected boolean done(Object msg) {
        if (msg instanceof RiakKvPB.RpbIndexResp) {
            return ((RiakKvPB.RpbIndexResp)msg).getDone();
        }
        if (msg instanceof RiakKvPB.RpbIndexBodyResp) {
            return ((RiakKvPB.RpbIndexBodyResp)msg).getDone();
        }
        throw new IllegalStateException("Unsupported response message type");
    }

    @Override
    public Query getQueryInfo() {
        return this.query;
    }

    @Override
    protected Response processStreamingChunk(Object rawResponseChunk) {
        Response.Builder responseBuilder = new Response.Builder();
        boolean bodyResp = this.objectIsIndexBodyResp(rawResponseChunk);
        this.convertSingleResponse(responseBuilder, bodyResp, rawResponseChunk);
        Response response = responseBuilder.build();
        if (response.hasContinuation()) {
            RiakKvPB.RpbIndexResp continuationOnlyResponse = RiakKvPB.RpbIndexResp.newBuilder().setContinuation(ByteString.copyFrom(response.getContinuation().unsafeGetValue())).build();
            this.processBatchMessage(continuationOnlyResponse);
        }
        return response;
    }

    public static class Response
    implements Iterable<Entry> {
        private final BinaryValue continuation;
        private final List<Entry> entryList;

        private Response(Builder builder) {
            this.continuation = builder.continuation;
            this.entryList = builder.entryList;
        }

        public boolean hasContinuation() {
            return this.continuation != null;
        }

        public BinaryValue getContinuation() {
            return this.continuation;
        }

        public List<Entry> getEntryList() {
            return this.entryList;
        }

        @Override
        public Iterator<Entry> iterator() {
            return this.getEntryList().iterator();
        }

        static class Builder {
            private BinaryValue continuation;
            private List<Entry> entryList = new ArrayList<Entry>();

            Builder() {
            }

            Builder withContinuation(BinaryValue continuation) {
                this.continuation = continuation;
                return this;
            }

            Builder addEntry(Entry entry) {
                this.entryList.add(entry);
                return this;
            }

            Builder addAllEntries(Collection<? extends Entry> entries) {
                this.entryList.addAll(entries);
                return this;
            }

            Response build() {
                return new Response(this);
            }
        }

        public static class Entry {
            private final BinaryValue indexKey;
            private final BinaryValue objectKey;
            private final FetchOperation.Response fetchResponse;

            Entry(BinaryValue objectKey, FetchOperation.Response fr) {
                this(null, objectKey, fr);
            }

            Entry(BinaryValue objectKey) {
                this(null, objectKey);
            }

            Entry(BinaryValue indexKey, BinaryValue objectKey) {
                this(indexKey, objectKey, null);
            }

            Entry(BinaryValue indexKey, BinaryValue objectKey, FetchOperation.Response fr) {
                this.indexKey = indexKey;
                this.objectKey = objectKey;
                this.fetchResponse = fr;
            }

            public boolean hasIndexKey() {
                return this.indexKey != null;
            }

            public BinaryValue getIndexKey() {
                return this.indexKey;
            }

            public BinaryValue getObjectKey() {
                return this.objectKey;
            }

            public boolean hasBody() {
                return this.fetchResponse != null;
            }

            public FetchOperation.Response getBody() {
                return this.fetchResponse;
            }
        }
    }

    public static class Query {
        private final Namespace namespace;
        private final BinaryValue indexName;
        private final BinaryValue indexKey;
        private final BinaryValue rangeStart;
        private final BinaryValue rangeEnd;
        private final boolean returnKeyAndIndex;
        private final Integer maxResults;
        private final BinaryValue continuation;
        private final Boolean paginationSort;
        private final BinaryValue termFilter;
        private final Integer timeout;
        private final byte[] coverageContext;
        private final boolean returnBody;

        private Query(Builder builder) {
            this.indexName = builder.indexName;
            this.indexKey = builder.indexKey;
            this.rangeStart = builder.rangeStart;
            this.rangeEnd = builder.rangeEnd;
            this.returnKeyAndIndex = builder.returnKeyAndIndex;
            this.maxResults = builder.maxResults;
            this.continuation = builder.continuation;
            this.paginationSort = builder.paginationSort;
            this.termFilter = builder.termFilter;
            this.namespace = builder.namespace;
            this.timeout = builder.timeout;
            this.coverageContext = builder.coverageContext;
            this.returnBody = builder.returnBody;
        }

        public Namespace getNamespace() {
            return this.namespace;
        }

        public BinaryValue getIndexName() {
            return this.indexName;
        }

        public BinaryValue getIndexKey() {
            return this.indexKey;
        }

        public BinaryValue getRangeStart() {
            return this.rangeStart;
        }

        public BinaryValue getRangeEnd() {
            return this.rangeEnd;
        }

        public boolean isReturnKeyAndIndex() {
            return this.returnKeyAndIndex;
        }

        public int getMaxResults() {
            return this.maxResults;
        }

        public BinaryValue getContinuation() {
            return this.continuation;
        }

        public boolean isPaginationSort() {
            return this.paginationSort;
        }

        public BinaryValue getTermFilter() {
            return this.termFilter;
        }

        public Integer getTimeout() {
            return this.timeout;
        }

        public byte[] getCoverageContext() {
            return this.coverageContext;
        }

        public boolean isReturnBody() {
            return this.returnBody;
        }

        public static class Builder {
            private final Namespace namespace;
            private final BinaryValue indexName;
            private BinaryValue indexKey;
            private BinaryValue rangeStart;
            private BinaryValue rangeEnd;
            private boolean returnKeyAndIndex;
            private Integer maxResults;
            private BinaryValue continuation;
            private Boolean paginationSort;
            private BinaryValue termFilter;
            private Integer timeout;
            private byte[] coverageContext;
            private boolean returnBody;

            public Builder(Namespace namespace, BinaryValue indexName) {
                if (namespace == null) {
                    throw new IllegalArgumentException("Namespace cannot be null");
                }
                if (null == indexName || indexName.length() == 0) {
                    throw new IllegalArgumentException("Index name cannot be null or zero length");
                }
                this.indexName = indexName;
                this.namespace = namespace;
            }

            public Builder withIndexKey(BinaryValue key) {
                this.indexKey = key;
                return this;
            }

            public Builder withRangeStart(BinaryValue startingIndex) {
                this.rangeStart = startingIndex;
                return this;
            }

            public Builder withRangeEnd(BinaryValue endIndex) {
                this.rangeEnd = endIndex;
                return this;
            }

            public Builder withReturnKeyAndIndex(boolean returnBoth) {
                this.returnKeyAndIndex = returnBoth;
                return this;
            }

            public Builder withMaxResults(int maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public Builder withContinuation(BinaryValue continuation) {
                this.continuation = continuation;
                return this;
            }

            public Builder withPaginationSort(boolean orderByKey) {
                this.paginationSort = orderByKey;
                return this;
            }

            public Builder withRegexTermFilter(BinaryValue filter) {
                this.termFilter = filter;
                return this;
            }

            public Builder withTimeout(int timeout) {
                this.timeout = timeout;
                return this;
            }

            public Builder withCoverageContext(byte[] coverageContext) {
                this.coverageContext = coverageContext;
                return this;
            }

            public Builder withReturnBody(boolean returnBody) {
                this.returnBody = returnBody;
                return this;
            }

            public Query build() {
                if (this.rangeStart == null && this.rangeEnd == null && this.indexKey == null && this.coverageContext == null) {
                    throw new IllegalArgumentException("An index key or range or coverageContext must be supplied");
                }
                if (this.rangeStart != null && this.rangeEnd == null || this.rangeEnd != null && this.rangeStart == null) {
                    throw new IllegalArgumentException("When specifying ranges both start and end must be Set");
                }
                if (this.rangeStart != null && this.indexKey != null) {
                    throw new IllegalArgumentException("Cannot specify single index key and range");
                }
                if (this.maxResults != null && this.paginationSort != null && !this.paginationSort.booleanValue()) {
                    throw new IllegalArgumentException("Cannot set paginationSort=false while setting maxResults");
                }
                if (this.termFilter != null && this.indexName.toStringUtf8().endsWith("_int")) {
                    throw new IllegalArgumentException("Cannot use term regular expression in integer query");
                }
                return new Query(this);
            }
        }
    }

    public static class Builder {
        private final RiakKvPB.RpbIndexReq.Builder pbReqBuilder = RiakKvPB.RpbIndexReq.newBuilder();
        private final Query query;
        private boolean streamResults = false;

        public Builder(Query query) {
            if (query == null) {
                throw new IllegalArgumentException("Query cannot be null.");
            }
            if (query.returnBody && query.returnKeyAndIndex) {
                throw new IllegalArgumentException("Contradictory query options: returnBody and returnKeyAndIndex");
            }
            this.query = query;
            this.pbReqBuilder.setBucket(ByteString.copyFrom(query.namespace.getBucketName().unsafeGetValue())).setType(ByteString.copyFrom(query.namespace.getBucketType().unsafeGetValue())).setIndex(ByteString.copyFrom(query.indexName.unsafeGetValue())).setReturnTerms(query.returnKeyAndIndex).setReturnBody(query.returnBody);
            if (query.indexKey != null) {
                this.pbReqBuilder.setKey(ByteString.copyFrom(query.indexKey.unsafeGetValue())).setQtype(RiakKvPB.RpbIndexReq.IndexQueryType.eq);
            } else if (query.getRangeStart() != null) {
                this.pbReqBuilder.setRangeMin(ByteString.copyFrom(query.rangeStart.unsafeGetValue())).setRangeMax(ByteString.copyFrom(query.rangeEnd.unsafeGetValue())).setQtype(RiakKvPB.RpbIndexReq.IndexQueryType.range);
            } else {
                assert (query.coverageContext != null);
                this.pbReqBuilder.setCoverContext(ByteString.copyFrom(query.coverageContext)).setKey(ByteString.EMPTY).setIndex(ByteString.copyFromUtf8("$bucket")).clearReturnTerms().setQtype(RiakKvPB.RpbIndexReq.IndexQueryType.eq);
            }
            if (query.maxResults != null) {
                this.pbReqBuilder.setMaxResults(query.maxResults);
            }
            if (query.continuation != null) {
                this.pbReqBuilder.setContinuation(ByteString.copyFrom(query.continuation.unsafeGetValue()));
            }
            if (query.paginationSort != null) {
                this.pbReqBuilder.setPaginationSort(query.paginationSort);
            }
            if (query.termFilter != null) {
                this.pbReqBuilder.setTermRegex(ByteString.copyFrom(query.termFilter.unsafeGetValue()));
            }
            if (query.timeout != null) {
                this.pbReqBuilder.setTimeout(query.timeout);
            }
            if (query.coverageContext != null) {
                this.pbReqBuilder.setCoverContext(ByteString.copyFrom(query.coverageContext));
            }
        }

        public Builder streamResults(boolean streamResults) {
            this.streamResults = streamResults;
            return this;
        }

        public SecondaryIndexQueryOperation build() {
            return new SecondaryIndexQueryOperation(this);
        }
    }
}

