/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.operations;

import com.basho.riak.client.core.FutureOperation;
import com.basho.riak.client.core.RiakMessage;
import com.basho.riak.client.core.operations.Operations;
import com.basho.riak.client.core.query.Namespace;
import com.basho.riak.client.core.query.functions.Function;
import java.util.List;
import shaded.com.basho.riak.protobuf.RiakPB;
import shaded.com.google.protobuf.ByteString;

public class StoreBucketPropsOperation
extends FutureOperation<Void, Void, Namespace> {
    private final Namespace namespace;
    private final RiakPB.RpbSetBucketReq.Builder reqBuilder;

    private StoreBucketPropsOperation(Builder builder) {
        this.reqBuilder = builder.reqBuilder;
        this.namespace = builder.namespace;
    }

    @Override
    protected Void convert(List<Void> rawResponse) {
        return null;
    }

    @Override
    protected RiakMessage createChannelMessage() {
        RiakPB.RpbSetBucketReq req = this.reqBuilder.build();
        return new RiakMessage(21, req.toByteArray());
    }

    @Override
    protected Void decode(RiakMessage rawMessage) {
        Operations.checkPBMessageType(rawMessage, (byte)22);
        return null;
    }

    @Override
    public Namespace getQueryInfo() {
        return this.namespace;
    }

    public static class Builder
    extends PropsBuilder<Builder> {
        private final RiakPB.RpbSetBucketReq.Builder reqBuilder = RiakPB.RpbSetBucketReq.newBuilder();
        private final Namespace namespace;

        public Builder(Namespace namespace) {
            if (namespace == null) {
                throw new IllegalArgumentException("Namespace cannot be null");
            }
            this.reqBuilder.setBucket(ByteString.copyFrom(namespace.getBucketName().unsafeGetValue()));
            this.reqBuilder.setType(ByteString.copyFrom(namespace.getBucketType().unsafeGetValue()));
            this.namespace = namespace;
        }

        @Override
        protected Builder self() {
            return this;
        }

        public StoreBucketPropsOperation build() {
            this.reqBuilder.setProps(this.propsBuilder);
            return new StoreBucketPropsOperation(this);
        }
    }

    static abstract class PropsBuilder<T extends PropsBuilder<T>> {
        protected final RiakPB.RpbBucketProps.Builder propsBuilder = RiakPB.RpbBucketProps.newBuilder();

        PropsBuilder() {
        }

        protected abstract T self();

        public T withAllowMulti(boolean allow) {
            this.propsBuilder.setAllowMult(allow);
            return this.self();
        }

        public T withBackend(String backend) {
            if (null == backend || backend.length() == 0) {
                throw new IllegalArgumentException("Backend can not be null or zero length");
            }
            this.propsBuilder.setBackend(ByteString.copyFromUtf8(backend));
            return this.self();
        }

        public T withBasicQuorum(boolean use) {
            this.propsBuilder.setBasicQuorum(use);
            return this.self();
        }

        public T withBigVClock(Long bigVClock) {
            this.propsBuilder.setBigVclock(bigVClock.intValue());
            return this.self();
        }

        public T withChashkeyFunction(Function func) {
            this.verifyErlangFunc(func);
            this.propsBuilder.setChashKeyfun(this.convertModFun(func));
            return this.self();
        }

        public T withLastWriteWins(boolean wins) {
            this.propsBuilder.setLastWriteWins(wins);
            return this.self();
        }

        public T withLinkwalkFunction(Function func) {
            this.verifyErlangFunc(func);
            this.propsBuilder.setLinkfun(this.convertModFun(func));
            return this.self();
        }

        public T withRw(int rw) {
            this.propsBuilder.setRw(rw);
            return this.self();
        }

        public T withDw(int dw) {
            this.propsBuilder.setDw(dw);
            return this.self();
        }

        public T withW(int w) {
            this.propsBuilder.setW(w);
            return this.self();
        }

        public T withR(int r) {
            this.propsBuilder.setR(r);
            return this.self();
        }

        public T withPr(int pr) {
            this.propsBuilder.setPr(pr);
            return this.self();
        }

        public T withPw(int pw) {
            this.propsBuilder.setPw(pw);
            return this.self();
        }

        public T withNotFoundOk(boolean ok) {
            this.propsBuilder.setNotfoundOk(ok);
            return this.self();
        }

        public T withPrecommitHook(Function hook) {
            if (null == hook || hook.isJavascript() && !hook.isNamed()) {
                throw new IllegalArgumentException("Must be a named JS or Erlang function.");
            }
            this.propsBuilder.addPrecommit(this.convertHook(hook));
            return this.self();
        }

        public T withPostcommitHook(Function hook) {
            this.verifyErlangFunc(hook);
            this.propsBuilder.addPostcommit(this.convertHook(hook));
            return this.self();
        }

        public T withOldVClock(Long oldVClock) {
            this.propsBuilder.setOldVclock(oldVClock.intValue());
            return this.self();
        }

        public T withYoungVClock(Long youngVClock) {
            this.propsBuilder.setYoungVclock(youngVClock.intValue());
            return this.self();
        }

        public T withSmallVClock(Long smallVClock) {
            this.propsBuilder.setSmallVclock(smallVClock.intValue());
            return this.self();
        }

        public T withNVal(int nVal) {
            if (nVal <= 0) {
                throw new IllegalArgumentException("nVal must be >= 1");
            }
            this.propsBuilder.setNVal(nVal);
            return this.self();
        }

        public T withLegacyRiakSearchEnabled(boolean enable) {
            this.propsBuilder.setSearch(enable);
            return this.self();
        }

        public T withSearchIndex(String indexName) {
            if (null == indexName || indexName.length() == 0) {
                throw new IllegalArgumentException("Index name cannot be null or zero length");
            }
            this.propsBuilder.setSearchIndex(ByteString.copyFromUtf8(indexName));
            return this.self();
        }

        public T withHllPrecision(int precision) {
            if (precision < 4 || precision > 16) {
                throw new IllegalArgumentException("Precision must be between 4 and 16, inclusive.");
            }
            this.propsBuilder.setHllPrecision(precision);
            return this.self();
        }

        private void verifyErlangFunc(Function f) {
            if (null == f || f.isJavascript()) {
                throw new IllegalArgumentException("Must be an Erlang Function.");
            }
        }

        private RiakPB.RpbModFun convertModFun(Function f) {
            return RiakPB.RpbModFun.newBuilder().setModule(ByteString.copyFromUtf8(f.getModule())).setFunction(ByteString.copyFromUtf8(f.getFunction())).build();
        }

        private RiakPB.RpbCommitHook convertHook(Function hook) {
            RiakPB.RpbCommitHook.Builder builder = RiakPB.RpbCommitHook.newBuilder();
            RiakPB.RpbModFun.Builder mfBuilder = RiakPB.RpbModFun.newBuilder();
            if (hook.isJavascript()) {
                builder.setName(ByteString.copyFromUtf8(hook.getName()));
            } else {
                mfBuilder.setModule(ByteString.copyFromUtf8(hook.getModule()));
                mfBuilder.setFunction(ByteString.copyFromUtf8(hook.getFunction()));
                builder.setModfun(mfBuilder);
            }
            return builder.build();
        }
    }
}

