/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.operations;

import com.basho.riak.client.core.FutureOperation;
import com.basho.riak.client.core.RiakMessage;
import com.basho.riak.client.core.operations.Operations;

public abstract class TTBFutureOperation<T, S>
extends FutureOperation<T, byte[], S> {
    protected final byte reqMessageCode = (byte)104;
    protected final byte respMessageCode = (byte)104;
    protected final TTBEncoder requestBuilder;
    protected final TTBParser<T> responseParser;

    protected TTBFutureOperation(TTBEncoder requestBuilder, TTBParser<T> responseParser) {
        this.requestBuilder = requestBuilder;
        this.responseParser = responseParser;
    }

    @Override
    protected RiakMessage createChannelMessage() {
        return new RiakMessage(104, this.requestBuilder.build(), false);
    }

    @Override
    protected byte[] decode(RiakMessage rawMessage) {
        Operations.checkPBMessageType(rawMessage, (byte)104);
        byte[] data = rawMessage.getData();
        if (data.length == 0) {
            return null;
        }
        return data;
    }

    public static interface TTBParser<T> {
        public T parseFrom(byte[] var1);
    }

    public static interface TTBEncoder {
        public byte[] build();
    }
}

