/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.operations.ts;

import com.basho.riak.client.core.operations.PBFutureOperation;
import com.basho.riak.client.core.query.timeseries.ColumnDescription;
import com.basho.riak.client.core.query.timeseries.FullColumnDescription;
import com.basho.riak.client.core.query.timeseries.Quantum;
import com.basho.riak.client.core.query.timeseries.TableDefinition;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import shaded.com.basho.riak.protobuf.RiakTsPB;
import shaded.com.google.protobuf.ByteString;

public class CreateTableOperation
extends PBFutureOperation<Void, RiakTsPB.TsQueryResp, String> {
    private final String queryText;

    private CreateTableOperation(AbstractBuilder builder) {
        super((byte)90, (byte)91, builder.reqBuilder, RiakTsPB.TsQueryResp.PARSER);
        this.queryText = builder.queryText;
    }

    @Override
    protected Void convert(List<RiakTsPB.TsQueryResp> rawResponse) {
        return null;
    }

    @Override
    public String getQueryInfo() {
        return this.queryText;
    }

    public static abstract class AbstractBuilder<R, THIS extends AbstractBuilder> {
        private RiakTsPB.TsQueryReq.Builder reqBuilder;
        private String queryText;
        private int quantum;
        private char quantumUnit;
        private final TableDefinition tableDefinition;

        public AbstractBuilder(TableDefinition tableDefinition) {
            if (tableDefinition == null) {
                throw new IllegalArgumentException("TableDefinition cannot be null.");
            }
            String tableName = tableDefinition.getTableName();
            if (tableName == null || tableName.length() == 0) {
                throw new IllegalArgumentException("Table Name cannot be null or empty");
            }
            this.tableDefinition = tableDefinition;
            this.findQuantumInfoInColumnDescriptions();
        }

        public abstract R build();

        public CreateTableOperation buildOperation() {
            String keys = AbstractBuilder.generateKeys(this.tableDefinition, this.quantum, this.quantumUnit).toString();
            this.queryText = String.format("CREATE TABLE %s (%s,\n\n PRIMARY KEY (%s))", this.tableDefinition.getTableName(), AbstractBuilder.generateColumns(this.tableDefinition), keys);
            this.reqBuilder = RiakTsPB.TsQueryReq.newBuilder().setQuery(RiakTsPB.TsInterpolation.newBuilder().setBase(ByteString.copyFromUtf8(this.queryText)));
            return new CreateTableOperation(this);
        }

        public THIS withQuantum(int quantum, TimeUnit tu) {
            this.quantumUnit = Quantum.getTimeUnitChar(tu);
            this.quantum = quantum;
            return (THIS)this;
        }

        private void findQuantumInfoInColumnDescriptions() {
            for (FullColumnDescription fullColumnDescription : this.tableDefinition.getPartitionKeyColumnDescriptions()) {
                if (!fullColumnDescription.hasQuantum()) continue;
                Quantum quantum = fullColumnDescription.getQuantum();
                this.quantum = quantum.getInterval();
                this.quantumUnit = quantum.getUnitAsChar();
            }
        }

        private static StringBuilder generateColumns(TableDefinition tableDefinition) {
            StringBuilder sb = new StringBuilder();
            for (FullColumnDescription fd : tableDefinition.getFullColumnDescriptions()) {
                if (sb.length() > 0) {
                    sb.append(",\n ");
                }
                sb.append(fd.getName()).append(' ').append(fd.getType().name());
                if (fd.isNullable()) continue;
                sb.append(" not null");
            }
            return sb;
        }

        private static StringBuilder generateKeys(TableDefinition tableDefinition, int quantum, char quantumUnit) {
            Collection<FullColumnDescription> pks = tableDefinition.getPartitionKeyColumnDescriptions();
            if (pks == null || pks.isEmpty()) {
                throw new IllegalArgumentException("No defined primary keys, at least one primary key should be defined.");
            }
            boolean quantumGenerated = false;
            StringBuilder sb = new StringBuilder();
            for (FullColumnDescription k : pks) {
                if (sb.length() > 0) {
                    sb.append(", ");
                } else {
                    sb.append('(');
                }
                if (!quantumGenerated && ColumnDescription.ColumnType.TIMESTAMP.equals((Object)k.getType())) {
                    sb.append("quantum(").append(k.getName()).append(',').append(quantum).append(',').append(quantumUnit).append(')');
                    quantumGenerated = true;
                    continue;
                }
                sb.append(k.getName());
            }
            sb.append(')');
            for (FullColumnDescription lk : tableDefinition.getLocalKeyColumnDescriptions()) {
                sb.append(", ").append(lk.getName());
                if (!lk.hasKeyOrder()) continue;
                sb.append(" ");
                sb.append(lk.getKeyOrder().toString());
            }
            return sb;
        }
    }
}

