/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.operations.ts;

import com.basho.riak.client.core.operations.TTBFutureOperation;
import com.basho.riak.client.core.operations.ts.TTBConverters;
import com.basho.riak.client.core.query.timeseries.Cell;
import com.basho.riak.client.core.query.timeseries.QueryResult;
import java.util.List;

public class FetchOperation
extends TTBFutureOperation<QueryResult, String> {
    private final Builder builder;
    private String queryInfoMessage;

    private FetchOperation(Builder builder) {
        super(new TTBConverters.FetchEncoder(builder), new TTBConverters.QueryResultDecoder());
        this.builder = builder;
    }

    @Override
    protected QueryResult convert(List<byte[]> responses) {
        byte[] bytes = this.checkAndGetSingleResponse(responses);
        return (QueryResult)this.responseParser.parseFrom(bytes);
    }

    @Override
    public String getQueryInfo() {
        if (this.queryInfoMessage == null) {
            this.queryInfoMessage = this.createQueryInfoMessage();
        }
        return this.queryInfoMessage;
    }

    private String createQueryInfoMessage() {
        StringBuilder sb = new StringBuilder();
        for (Cell cell : this.builder.keyValues) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(cell == null ? "NULL" : cell.toString());
        }
        return String.format("SELECT * FROM %s WHERE PRIMARY KEY = { %s }", this.builder.tableName, sb.toString());
    }

    public static class Builder {
        private final String tableName;
        private final Iterable<Cell> keyValues;
        private int timeout;

        public Builder(String tableName, Iterable<Cell> keyValues) {
            if (tableName == null || tableName.length() == 0) {
                throw new IllegalArgumentException("Table Name cannot be null or an empty string.");
            }
            if (keyValues == null || !keyValues.iterator().hasNext()) {
                throw new IllegalArgumentException("Key Values cannot be null or an empty.");
            }
            this.tableName = tableName;
            this.keyValues = keyValues;
        }

        public Builder withTimeout(int timeout) {
            if (timeout < 1) {
                throw new IllegalArgumentException("Timeout must be a positive integer");
            }
            this.timeout = timeout;
            return this;
        }

        public FetchOperation build() {
            return new FetchOperation(this);
        }

        public String getTableName() {
            return this.tableName;
        }

        public Iterable<Cell> getKeyValues() {
            return this.keyValues;
        }

        public int getTimeout() {
            return this.timeout;
        }
    }
}

