/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.operations.ts;

import com.basho.riak.client.core.operations.TTBFutureOperation;
import com.basho.riak.client.core.operations.ts.TTBConverters;
import com.basho.riak.client.core.query.timeseries.QueryResult;
import java.util.List;
import shaded.com.basho.riak.protobuf.RiakTsPB;
import shaded.com.google.protobuf.ByteString;

public class QueryOperation
extends TTBFutureOperation<QueryResult, String> {
    private final String queryText;

    private QueryOperation(Builder builder) {
        super(new TTBConverters.QueryEncoder(builder), new TTBConverters.QueryResultDecoder());
        this.queryText = builder.queryText;
    }

    @Override
    protected QueryResult convert(List<byte[]> responses) {
        byte[] response = this.checkAndGetSingleResponse(responses);
        return (QueryResult)this.responseParser.parseFrom(response);
    }

    @Override
    public String getQueryInfo() {
        return this.queryText;
    }

    public static class Builder {
        private final String queryText;
        private final RiakTsPB.TsQueryReq.Builder reqBuilder = RiakTsPB.TsQueryReq.newBuilder();
        private byte[] coverageContext;

        public Builder(String queryText) {
            if (queryText == null || queryText.length() == 0) {
                throw new IllegalArgumentException("QueryText cannot be null or empty");
            }
            this.queryText = queryText;
            RiakTsPB.TsInterpolation.Builder interpolationBuilder = RiakTsPB.TsInterpolation.newBuilder().setBase(ByteString.copyFromUtf8(queryText));
            this.reqBuilder.setQuery(interpolationBuilder);
        }

        public Builder withCoverageContext(byte[] coverageContext) {
            if (coverageContext != null) {
                this.coverageContext = coverageContext;
            }
            return this;
        }

        public String getQueryText() {
            return this.queryText;
        }

        public byte[] getCoverageContext() {
            return this.coverageContext;
        }

        public QueryOperation build() {
            return new QueryOperation(this);
        }
    }
}

