/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.operations.ts;

import com.basho.riak.client.core.operations.TTBFutureOperation;
import com.basho.riak.client.core.operations.ts.TTBConverters;
import com.basho.riak.client.core.query.timeseries.ColumnDescription;
import com.basho.riak.client.core.query.timeseries.Row;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StoreOperation
extends TTBFutureOperation<Void, String> {
    private final Builder builder;
    private String queryInfoMessage;

    private StoreOperation(Builder builder) {
        super(new TTBConverters.StoreEncoder(builder), new TTBConverters.VoidDecoder());
        this.builder = builder;
    }

    @Override
    protected Void convert(List<byte[]> responses) {
        this.checkAndGetSingleResponse(responses);
        return null;
    }

    @Override
    public String getQueryInfo() {
        if (this.queryInfoMessage == null) {
            this.queryInfoMessage = this.createQueryInfoMessage();
        }
        return this.queryInfoMessage;
    }

    private String createQueryInfoMessage() {
        return "INSERT into " + this.builder.tableName;
    }

    public static class Builder {
        private final String tableName;
        private Collection<Row> rows;
        private Collection<String> columns;

        public Builder(String tableName) {
            if (tableName == null || tableName.length() == 0) {
                throw new IllegalArgumentException("TableName can not be null or empty");
            }
            this.tableName = tableName;
        }

        public Builder withColumns(Collection<String> columnNames) {
            this.columns = columnNames;
            return this;
        }

        public Builder withColumnDescriptions(Collection<? extends ColumnDescription> columns) {
            columns = new ArrayList<ColumnDescription>(columns.size());
            for (ColumnDescription columnDescription : columns) {
                this.columns.add(columnDescription.getName());
            }
            return this;
        }

        public Builder withRows(Collection<Row> rows) {
            this.rows = rows;
            return this;
        }

        public String getTableName() {
            return this.tableName;
        }

        public Collection<Row> getRows() {
            return this.rows;
        }

        public Collection<String> getColumns() {
            return this.columns;
        }

        public StoreOperation build() {
            return new StoreOperation(this);
        }
    }
}

