/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.query;

import com.basho.riak.client.api.cap.Quorum;
import com.basho.riak.client.core.query.functions.Function;
import java.util.LinkedList;
import java.util.List;

public class BucketProperties {
    private final Function linkwalkFunction;
    private final Function chashKeyFunction;
    private final Quorum rw;
    private final Quorum dw;
    private final Quorum w;
    private final Quorum r;
    private final Quorum pr;
    private final Quorum pw;
    private final Boolean notFoundOk;
    private final Boolean basicQuorum;
    private final List<Function> precommitHooks;
    private final List<Function> postcommitHooks;
    private final Long oldVClock;
    private final Long youngVClock;
    private final Long bigVClock;
    private final Long smallVClock;
    private final String backend;
    private final Integer nVal;
    private final Boolean lastWriteWins;
    private final Boolean allowSiblings;
    private final Boolean search;
    private final String yokozunaIndex;
    private final Integer hllPrecision;

    private BucketProperties(Builder builder) {
        this.allowSiblings = builder.allowSiblings;
        this.backend = builder.backend;
        this.basicQuorum = builder.basicQuorum;
        this.bigVClock = builder.bigVClock;
        this.chashKeyFunction = builder.chashKeyFunction;
        this.dw = builder.dw;
        this.lastWriteWins = builder.lastWriteWins;
        this.linkwalkFunction = builder.linkwalkFunction;
        this.nVal = builder.nVal;
        this.notFoundOk = builder.notFoundOk;
        this.oldVClock = builder.oldVClock;
        this.postcommitHooks = builder.postcommitHooks;
        this.pr = builder.pr;
        this.precommitHooks = builder.precommitHooks;
        this.pw = builder.pw;
        this.r = builder.r;
        this.rw = builder.rw;
        this.search = builder.search;
        this.smallVClock = builder.smallVClock;
        this.w = builder.w;
        this.yokozunaIndex = builder.yokozunaIndex;
        this.youngVClock = builder.youngVClock;
        this.hllPrecision = builder.hllPrecision;
    }

    public boolean hasLinkwalkFunction() {
        return this.linkwalkFunction != null;
    }

    public Function getLinkwalkFunction() {
        return this.linkwalkFunction;
    }

    public boolean hasChashKeyFunction() {
        return this.chashKeyFunction != null;
    }

    public Function getChashKeyFunction() {
        return this.chashKeyFunction;
    }

    public boolean hasRw() {
        return this.rw != null;
    }

    public Quorum getRw() {
        return this.rw;
    }

    public boolean hasDw() {
        return this.rw != null;
    }

    public Quorum getDw() {
        return this.dw;
    }

    public boolean hasW() {
        return this.w != null;
    }

    public Quorum getW() {
        return this.w;
    }

    public boolean hasR() {
        return this.r != null;
    }

    public Quorum getR() {
        return this.r;
    }

    public boolean hasPr() {
        return this.pr != null;
    }

    public Quorum getPr() {
        return this.pr;
    }

    public boolean hasPw() {
        return this.pw != null;
    }

    public Quorum getPw() {
        return this.pw;
    }

    public boolean hasNotFoundOk() {
        return this.notFoundOk != null;
    }

    public Boolean getNotFoundOk() {
        return this.notFoundOk;
    }

    public boolean hasBasicQuorum() {
        return this.basicQuorum != null;
    }

    public Boolean getBasicQuorum() {
        return this.basicQuorum;
    }

    public boolean hasPrecommitHooks() {
        return !this.precommitHooks.isEmpty();
    }

    public List<Function> getPrecommitHooks() {
        return this.precommitHooks;
    }

    public boolean hasPostcommitHooks() {
        return !this.postcommitHooks.isEmpty();
    }

    public List<Function> getPostcommitHooks() {
        return this.postcommitHooks;
    }

    public boolean hasOldVClock() {
        return this.oldVClock != null;
    }

    public Long getOldVClock() {
        return this.oldVClock;
    }

    public boolean hasYoungVClock() {
        return this.youngVClock != null;
    }

    public Long getYoungVClock() {
        return this.youngVClock;
    }

    public boolean hasBigVClock() {
        return this.bigVClock != null;
    }

    public Long getBigVClock() {
        return this.bigVClock;
    }

    public boolean hasSmallVClock() {
        return this.smallVClock != null;
    }

    public Long getSmallVClock() {
        return this.smallVClock;
    }

    public boolean hasBackend() {
        return this.backend != null;
    }

    public String getBackend() {
        return this.backend;
    }

    public boolean hasNVal() {
        return this.nVal != null;
    }

    public Integer getNVal() {
        return this.nVal;
    }

    public boolean hasLastWriteWins() {
        return this.lastWriteWins != null;
    }

    public Boolean getLastWriteWins() {
        return this.lastWriteWins;
    }

    public boolean hasAllowMulti() {
        return this.allowSiblings != null;
    }

    public Boolean getAllowMulti() {
        return this.allowSiblings;
    }

    public boolean hasLegacyRiakSearchEnabled() {
        return this.search != null;
    }

    public Boolean getLegacyRiakSearchEnabled() {
        return this.search;
    }

    public boolean hasSearchIndex() {
        return this.yokozunaIndex != null;
    }

    public String getSearchIndex() {
        return this.yokozunaIndex;
    }

    public boolean hasHllPrecision() {
        return this.hllPrecision != null;
    }

    public Integer getHllPrecision() {
        return this.hllPrecision;
    }

    public String toString() {
        return String.format("DefaultBucketProperties [allowSiblings=%s, lastWriteWins=%s, nVal=%s, backend=%s,  capProps=[rw=%s,dw=%s,w=%s,r=%s,pr=%s,pw=%s],vclockProps=[oldVClock=%s, youngVClock=%s, bigVClock=%s, smallVClock=%s],precommitHooks=%s, postcommitHooks=%s, , chashKeyFunction=%s, linkWalkFunction=%s, search=%s,yokozunaIndex=%s, hllPrecision=%s]", this.allowSiblings, this.lastWriteWins, this.nVal, this.backend, this.rw, this.dw, this.w, this.r, this.pr, this.pw, this.oldVClock, this.youngVClock, this.bigVClock, this.smallVClock, this.precommitHooks, this.postcommitHooks, this.chashKeyFunction, this.linkwalkFunction, this.search, this.yokozunaIndex, this.hllPrecision);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BucketProperties that = (BucketProperties)o;
        if (this.linkwalkFunction != null ? !this.linkwalkFunction.equals(that.linkwalkFunction) : that.linkwalkFunction != null) {
            return false;
        }
        if (this.chashKeyFunction != null ? !this.chashKeyFunction.equals(that.chashKeyFunction) : that.chashKeyFunction != null) {
            return false;
        }
        if (this.rw != null ? !this.rw.equals(that.rw) : that.rw != null) {
            return false;
        }
        if (this.dw != null ? !this.dw.equals(that.dw) : that.dw != null) {
            return false;
        }
        if (this.w != null ? !this.w.equals(that.w) : that.w != null) {
            return false;
        }
        if (this.r != null ? !this.r.equals(that.r) : that.r != null) {
            return false;
        }
        if (this.pr != null ? !this.pr.equals(that.pr) : that.pr != null) {
            return false;
        }
        if (this.pw != null ? !this.pw.equals(that.pw) : that.pw != null) {
            return false;
        }
        if (this.notFoundOk != null ? !this.notFoundOk.equals(that.notFoundOk) : that.notFoundOk != null) {
            return false;
        }
        if (this.basicQuorum != null ? !this.basicQuorum.equals(that.basicQuorum) : that.basicQuorum != null) {
            return false;
        }
        if (this.precommitHooks != null ? !this.precommitHooks.equals(that.precommitHooks) : that.precommitHooks != null) {
            return false;
        }
        if (this.postcommitHooks != null ? !this.postcommitHooks.equals(that.postcommitHooks) : that.postcommitHooks != null) {
            return false;
        }
        if (this.oldVClock != null ? !this.oldVClock.equals(that.oldVClock) : that.oldVClock != null) {
            return false;
        }
        if (this.youngVClock != null ? !this.youngVClock.equals(that.youngVClock) : that.youngVClock != null) {
            return false;
        }
        if (this.bigVClock != null ? !this.bigVClock.equals(that.bigVClock) : that.bigVClock != null) {
            return false;
        }
        if (this.smallVClock != null ? !this.smallVClock.equals(that.smallVClock) : that.smallVClock != null) {
            return false;
        }
        if (this.backend != null ? !this.backend.equals(that.backend) : that.backend != null) {
            return false;
        }
        if (this.nVal != null ? !this.nVal.equals(that.nVal) : that.nVal != null) {
            return false;
        }
        if (this.lastWriteWins != null ? !this.lastWriteWins.equals(that.lastWriteWins) : that.lastWriteWins != null) {
            return false;
        }
        if (this.allowSiblings != null ? !this.allowSiblings.equals(that.allowSiblings) : that.allowSiblings != null) {
            return false;
        }
        if (this.search != null ? !this.search.equals(that.search) : that.search != null) {
            return false;
        }
        if (this.yokozunaIndex != null ? !this.yokozunaIndex.equals(that.yokozunaIndex) : that.yokozunaIndex != null) {
            return false;
        }
        return this.hllPrecision != null ? this.hllPrecision.equals(that.hllPrecision) : that.hllPrecision == null;
    }

    public int hashCode() {
        int result = this.linkwalkFunction != null ? this.linkwalkFunction.hashCode() : 0;
        result = 31 * result + (this.chashKeyFunction != null ? this.chashKeyFunction.hashCode() : 0);
        result = 31 * result + (this.rw != null ? this.rw.hashCode() : 0);
        result = 31 * result + (this.dw != null ? this.dw.hashCode() : 0);
        result = 31 * result + (this.w != null ? this.w.hashCode() : 0);
        result = 31 * result + (this.r != null ? this.r.hashCode() : 0);
        result = 31 * result + (this.pr != null ? this.pr.hashCode() : 0);
        result = 31 * result + (this.pw != null ? this.pw.hashCode() : 0);
        result = 31 * result + (this.notFoundOk != null ? this.notFoundOk.hashCode() : 0);
        result = 31 * result + (this.basicQuorum != null ? this.basicQuorum.hashCode() : 0);
        result = 31 * result + (this.precommitHooks != null ? this.precommitHooks.hashCode() : 0);
        result = 31 * result + (this.postcommitHooks != null ? this.postcommitHooks.hashCode() : 0);
        result = 31 * result + (this.oldVClock != null ? this.oldVClock.hashCode() : 0);
        result = 31 * result + (this.youngVClock != null ? this.youngVClock.hashCode() : 0);
        result = 31 * result + (this.bigVClock != null ? this.bigVClock.hashCode() : 0);
        result = 31 * result + (this.smallVClock != null ? this.smallVClock.hashCode() : 0);
        result = 31 * result + (this.backend != null ? this.backend.hashCode() : 0);
        result = 31 * result + (this.nVal != null ? this.nVal.hashCode() : 0);
        result = 31 * result + (this.lastWriteWins != null ? this.lastWriteWins.hashCode() : 0);
        result = 31 * result + (this.allowSiblings != null ? this.allowSiblings.hashCode() : 0);
        result = 31 * result + (this.search != null ? this.search.hashCode() : 0);
        result = 31 * result + (this.yokozunaIndex != null ? this.yokozunaIndex.hashCode() : 0);
        result = 31 * result + (this.hllPrecision != null ? this.hllPrecision.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private Function linkwalkFunction;
        private Function chashKeyFunction;
        private Quorum rw;
        private Quorum dw;
        private Quorum w;
        private Quorum r;
        private Quorum pr;
        private Quorum pw;
        private Boolean notFoundOk;
        private Boolean basicQuorum;
        private final List<Function> precommitHooks = new LinkedList<Function>();
        private final List<Function> postcommitHooks = new LinkedList<Function>();
        private Long oldVClock;
        private Long youngVClock;
        private Long bigVClock;
        private Long smallVClock;
        private String backend;
        private Integer nVal;
        private Boolean lastWriteWins;
        private Boolean allowSiblings;
        private Boolean search;
        private String yokozunaIndex;
        private Integer hllPrecision;

        public Builder withAllowMulti(boolean allow) {
            this.allowSiblings = allow;
            return this;
        }

        public Builder withBackend(String backend) {
            if (null == backend || backend.length() == 0) {
                throw new IllegalArgumentException("Backend can not be null or zero length");
            }
            this.backend = backend;
            return this;
        }

        public Builder withBasicQuorum(boolean use) {
            this.basicQuorum = use;
            return this;
        }

        public Builder withBigVClock(long bigVClock) {
            this.bigVClock = bigVClock;
            return this;
        }

        public Builder withChashkeyFunction(Function func) {
            this.verifyErlangFunc(func);
            this.chashKeyFunction = func;
            return this;
        }

        public Builder withLastWriteWins(boolean wins) {
            this.lastWriteWins = wins;
            return this;
        }

        public Builder withLinkwalkFunction(Function func) {
            this.verifyErlangFunc(func);
            this.linkwalkFunction = func;
            return this;
        }

        public Builder withRw(int rw) {
            this.rw = new Quorum(rw);
            return this;
        }

        public Builder withRw(Quorum rw) {
            this.rw = rw;
            return this;
        }

        public Builder withDw(int dw) {
            this.dw = new Quorum(dw);
            return this;
        }

        public Builder withW(int w) {
            this.w = new Quorum(w);
            return this;
        }

        public Builder withW(Quorum w) {
            this.w = w;
            return this;
        }

        public Builder withR(int r) {
            this.r = new Quorum(r);
            return this;
        }

        public Builder withR(Quorum r) {
            this.r = r;
            return this;
        }

        public Builder withPr(int pr) {
            this.pr = new Quorum(pr);
            return this;
        }

        public Builder withPr(Quorum pr) {
            this.pr = pr;
            return this;
        }

        public Builder withPw(int pw) {
            this.pw = new Quorum(pw);
            return this;
        }

        public Builder withPw(Quorum pw) {
            this.pw = pw;
            return this;
        }

        public Builder withNotFoundOk(boolean ok) {
            this.notFoundOk = ok;
            return this;
        }

        public Builder withPrecommitHook(Function hook) {
            if (null == hook || hook.isJavascript() && !hook.isNamed()) {
                throw new IllegalArgumentException("Must be a named JS or Erlang function.");
            }
            this.precommitHooks.add(hook);
            return this;
        }

        public Builder withPostcommitHook(Function hook) {
            this.verifyErlangFunc(hook);
            this.postcommitHooks.add(hook);
            return this;
        }

        public Builder withOldVClock(long oldVClock) {
            this.oldVClock = oldVClock;
            return this;
        }

        public Builder withYoungVClock(long youngVClock) {
            this.youngVClock = youngVClock;
            return this;
        }

        public Builder withSmallVClock(long smallVClock) {
            this.smallVClock = smallVClock;
            return this;
        }

        public Builder withNVal(int nVal) {
            if (nVal <= 0) {
                throw new IllegalArgumentException("nVal must be >= 1");
            }
            this.nVal = nVal;
            return this;
        }

        public Builder withLegacyRiakSearchEnabled(boolean enable) {
            this.search = enable;
            return this;
        }

        public Builder withSearchIndex(String indexName) {
            if (null == indexName || indexName.length() == 0) {
                throw new IllegalArgumentException("Index name cannot be null or zero length");
            }
            this.yokozunaIndex = indexName;
            return this;
        }

        public Builder withHllPrecision(int precision) {
            if (precision < 4 || precision > 16) {
                throw new IllegalArgumentException("Precision must be between 4 and 16, inclusive.");
            }
            this.hllPrecision = precision;
            return this;
        }

        public BucketProperties build() {
            return new BucketProperties(this);
        }

        private void verifyErlangFunc(Function f) {
            if (null == f || f.isJavascript()) {
                throw new IllegalArgumentException("Must be an Erlang Function.");
            }
        }
    }
}

