/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.query;

import com.basho.riak.client.core.util.BinaryValue;
import com.basho.riak.client.core.util.DefaultCharset;
import java.nio.charset.Charset;

public class Namespace {
    public static final String DEFAULT_BUCKET_TYPE = "default";
    private static final BinaryValue DEFAULT_TYPE = BinaryValue.createFromUtf8("default");
    private final BinaryValue type;
    private final BinaryValue bucket;

    public Namespace(BinaryValue bucketType, BinaryValue bucketName) {
        if (null == bucketName || bucketName.length() == 0) {
            throw new IllegalArgumentException("Bucket name cannot be null or zero length.");
        }
        if (null == bucketType || bucketType.length() == 0) {
            throw new IllegalArgumentException("Bucket type cannot be null or zero length.");
        }
        this.bucket = bucketName;
        this.type = bucketType;
    }

    public Namespace(String bucketType, String bucketName, Charset charset) {
        if (bucketName == null || bucketName.isEmpty()) {
            throw new IllegalArgumentException("Bucket name cannot be null or zero length");
        }
        if (bucketType == null || bucketType.isEmpty()) {
            throw new IllegalArgumentException("Bucket type cannot be null or zero length");
        }
        if (charset == null) {
            throw new IllegalArgumentException("Charset cannot be null");
        }
        this.bucket = BinaryValue.create(bucketName, charset);
        this.type = BinaryValue.createFromUtf8(bucketType);
    }

    public Namespace(String bucketType, String bucketName) {
        this(bucketType, bucketName, DefaultCharset.get());
    }

    public Namespace(BinaryValue bucketName) {
        this(DEFAULT_TYPE, bucketName);
    }

    public Namespace(String bucketName, Charset charset) {
        this(DEFAULT_BUCKET_TYPE, bucketName, charset);
    }

    public Namespace(String bucketName) {
        this(bucketName, DefaultCharset.get());
    }

    public BinaryValue getBucketType() {
        return this.type;
    }

    public String getBucketTypeAsString() {
        return this.type.toString();
    }

    public String getBucketTypeAsString(Charset charset) {
        return this.type.toString(charset);
    }

    public BinaryValue getBucketName() {
        return this.bucket;
    }

    public String getBucketNameAsString() {
        return this.bucket.toString();
    }

    public String getBucketNameAsString(Charset charset) {
        return this.bucket.toString(charset);
    }

    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + (this.type != null ? this.type.hashCode() : 0);
        hash = 37 * hash + (this.bucket != null ? this.bucket.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Namespace other = (Namespace)obj;
        if (!(this.type == other.type || this.type != null && this.type.equals(other.type))) {
            return false;
        }
        return this.bucket == other.bucket || this.bucket != null && this.bucket.equals(other.bucket);
    }

    public String toString() {
        return "{type: " + this.type + ", bucket: " + this.bucket + "}";
    }
}

