/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.query;

import com.basho.riak.client.api.annotations.RiakVClock;
import com.basho.riak.client.api.cap.VClock;
import com.basho.riak.client.core.query.UserMetadata.RiakUserMetadata;
import com.basho.riak.client.core.query.indexes.RiakIndexes;
import com.basho.riak.client.core.query.links.RiakLinks;
import com.basho.riak.client.core.util.BinaryValue;
import com.basho.riak.client.core.util.CharsetUtils;

public final class RiakObject {
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    private volatile BinaryValue value;
    private volatile RiakIndexes riakIndexes;
    private volatile RiakLinks links;
    private volatile RiakUserMetadata userMeta;
    private volatile String contentType = "application/octet-stream";
    private volatile String charset;
    private volatile String vtag;
    private volatile boolean isDeleted;
    private volatile boolean isModified;
    @RiakVClock
    private volatile VClock vclock;
    private volatile long lastModified;

    public boolean hasValue() {
        return this.value != null;
    }

    public BinaryValue getValue() {
        return this.value;
    }

    public RiakObject setValue(BinaryValue value) {
        if (value != null && value.length() == 0) {
            throw new IllegalArgumentException("value can not be zero length");
        }
        this.value = value;
        return this;
    }

    public VClock getVClock() {
        return this.vclock;
    }

    public RiakObject setVClock(VClock vclock) {
        this.vclock = vclock;
        return this;
    }

    public String getVTag() {
        return this.vtag;
    }

    public RiakObject setVTag(String vtag) {
        if (vtag != null && vtag.isEmpty()) {
            throw new IllegalArgumentException("vtag can not be zero length");
        }
        this.vtag = vtag;
        return this;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public RiakObject setLastModified(long lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public RiakObject setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public boolean hasCharset() {
        return this.charset != null || CharsetUtils.hasCharset(this.contentType);
    }

    public String getCharset() {
        if (this.charset != null) {
            return this.charset;
        }
        return CharsetUtils.getDeclaredCharset(this.contentType);
    }

    public RiakObject setCharset(String charset) {
        this.charset = charset;
        return this;
    }

    public boolean hasIndexes() {
        return this.riakIndexes != null && !this.riakIndexes.isEmpty();
    }

    public synchronized RiakIndexes getIndexes() {
        if (null == this.riakIndexes) {
            this.riakIndexes = new RiakIndexes();
        }
        return this.riakIndexes;
    }

    public boolean hasLinks() {
        return this.links != null && !this.links.isEmpty();
    }

    public synchronized RiakLinks getLinks() {
        if (null == this.links) {
            this.links = new RiakLinks();
        }
        return this.links;
    }

    public boolean hasUserMeta() {
        return this.userMeta != null && !this.userMeta.isEmpty();
    }

    public synchronized RiakUserMetadata getUserMeta() {
        if (null == this.userMeta) {
            this.userMeta = new RiakUserMetadata();
        }
        return this.userMeta;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public RiakObject setDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RiakObject that = (RiakObject)o;
        if (this.isDeleted != that.isDeleted) {
            return false;
        }
        if (this.isModified != that.isModified) {
            return false;
        }
        if (this.lastModified != that.lastModified) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        if (this.riakIndexes != null ? !this.riakIndexes.equals(that.riakIndexes) : that.riakIndexes != null) {
            return false;
        }
        if (this.links != null ? !this.links.equals(that.links) : that.links != null) {
            return false;
        }
        if (this.userMeta != null ? !this.userMeta.equals(that.userMeta) : that.userMeta != null) {
            return false;
        }
        if (this.contentType != null ? !this.contentType.equals(that.contentType) : that.contentType != null) {
            return false;
        }
        if (this.charset != null ? !this.charset.equals(that.charset) : that.charset != null) {
            return false;
        }
        if (this.vtag != null ? !this.vtag.equals(that.vtag) : that.vtag != null) {
            return false;
        }
        return !(this.vclock != null ? !this.vclock.equals(that.vclock) : that.vclock != null);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + (this.riakIndexes != null ? this.riakIndexes.hashCode() : 0);
        result = 31 * result + (this.links != null ? this.links.hashCode() : 0);
        result = 31 * result + (this.userMeta != null ? this.userMeta.hashCode() : 0);
        result = 31 * result + (this.contentType != null ? this.contentType.hashCode() : 0);
        result = 31 * result + (this.charset != null ? this.charset.hashCode() : 0);
        result = 31 * result + (this.vtag != null ? this.vtag.hashCode() : 0);
        result = 31 * result + (this.isDeleted ? 1 : 0);
        result = 31 * result + (this.isModified ? 1 : 0);
        result = 31 * result + (this.vclock != null ? this.vclock.hashCode() : 0);
        result = 31 * result + (int)(this.lastModified ^ this.lastModified >>> 32);
        return result;
    }

    public String toString() {
        return "RiakObject{contentType: " + this.contentType + ", value: " + this.value + ", riakIndexes: " + this.riakIndexes + ", links: " + this.links + ", userMeta: " + this.userMeta + ", vtag: " + this.vtag + ", isDeleted: " + this.isDeleted + ", isModified: " + this.isModified + ", vclock: " + this.vclock + ", lastModified: " + this.lastModified + '}';
    }
}

