/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.query.UserMetadata;

import com.basho.riak.client.core.util.BinaryValue;
import com.basho.riak.client.core.util.DefaultCharset;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class RiakUserMetadata {
    private final ConcurrentHashMap<BinaryValue, BinaryValue> meta = new ConcurrentHashMap();

    public boolean isEmpty() {
        return this.meta.isEmpty();
    }

    public boolean containsKey(String key) {
        return this.containsKey(key, DefaultCharset.get());
    }

    public boolean containsKey(String key, Charset charset) {
        return this.meta.containsKey(BinaryValue.unsafeCreate(key.getBytes(charset)));
    }

    public String get(String key) {
        return this.get(key, DefaultCharset.get());
    }

    public String get(String key, Charset charset) {
        BinaryValue wrappedKey = BinaryValue.unsafeCreate(key.getBytes(charset));
        BinaryValue value = this.meta.get(wrappedKey);
        if (value != null) {
            return value.toString(charset);
        }
        return null;
    }

    public BinaryValue get(BinaryValue key) {
        return this.meta.get(key);
    }

    public Set<Map.Entry<BinaryValue, BinaryValue>> getUserMetadata() {
        return Collections.unmodifiableSet(this.meta.entrySet());
    }

    public void put(String key, String value) {
        this.put(key, value, DefaultCharset.get());
    }

    public void put(String key, String value, Charset charset) {
        BinaryValue wrappedKey = BinaryValue.unsafeCreate(key.getBytes(charset));
        BinaryValue wrappedValue = BinaryValue.unsafeCreate(value.getBytes(charset));
        this.meta.put(wrappedKey, wrappedValue);
    }

    public void put(BinaryValue key, BinaryValue value) {
        this.meta.put(key, value);
    }

    public void remove(BinaryValue key) {
        this.meta.remove(key);
    }

    public void remove(String key, Charset charset) {
        BinaryValue wrappedKey = BinaryValue.unsafeCreate(key.getBytes(charset));
        this.remove(wrappedKey);
    }

    public void remove(String key) {
        this.remove(key, DefaultCharset.get());
    }

    public RiakUserMetadata put(Map<String, String> metaMap) {
        for (Map.Entry<String, String> e : metaMap.entrySet()) {
            BinaryValue wrappedKey = BinaryValue.unsafeCreate(e.getKey().getBytes());
            BinaryValue wrappedValue = BinaryValue.unsafeCreate(e.getValue().getBytes());
            this.meta.put(wrappedKey, wrappedValue);
        }
        return this;
    }

    public void clear() {
        this.meta.clear();
    }

    public int size() {
        return this.meta.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RiakUserMetadata that = (RiakUserMetadata)o;
        return this.meta.equals(that.meta);
    }

    public int hashCode() {
        return this.meta.hashCode();
    }

    public String toString() {
        return "RiakUserMetadata{meta: " + this.meta + '}';
    }
}

