/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.query.indexes;

import com.basho.riak.client.core.query.indexes.IndexType;
import com.basho.riak.client.core.util.BinaryValue;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class RiakIndex<T>
implements Iterable<T> {
    private final Set<BinaryValue> values;
    private final IndexType type;
    private final String name;

    protected RiakIndex(Name<?> name) {
        this.name = name.name;
        this.type = name.type;
        this.values = ((Name)name).values != null ? ((Name)name).values : Collections.newSetFromMap(new ConcurrentHashMap());
    }

    public final RiakIndex<T> add(T value) {
        this.values.add(this.convert(value));
        return this;
    }

    public final RiakIndex<T> add(Collection<T> values) {
        for (T value : values) {
            this.add(value);
        }
        return this;
    }

    public final boolean hasValue(T value) {
        return this.values.contains(this.convert(value));
    }

    public final RiakIndex<T> remove(T value) {
        this.values.remove(this.convert(value));
        return this;
    }

    public final RiakIndex<T> remove(Collection<T> values) {
        for (T value : values) {
            this.remove(value);
        }
        return this;
    }

    public final RiakIndex<T> removeAll() {
        this.values.clear();
        return this;
    }

    @Override
    public final Iterator<T> iterator() {
        return new Iterator<T>(){
            private Iterator<BinaryValue> i;
            {
                this.i = RiakIndex.this.values.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public T next() {
                return RiakIndex.this.convert(this.i.next());
            }

            @Override
            public void remove() {
                this.i.remove();
            }
        };
    }

    public final int size() {
        return this.values.size();
    }

    public final boolean isEmpty() {
        return this.values.isEmpty();
    }

    public final Set<BinaryValue> rawValues() {
        return Collections.unmodifiableSet(this.values);
    }

    public final Set<T> values() {
        HashSet<T> convertedValues = new HashSet<T>();
        for (BinaryValue baw : this.values) {
            convertedValues.add(this.convert(baw));
        }
        return Collections.unmodifiableSet(convertedValues);
    }

    public final IndexType getType() {
        return this.type;
    }

    public final String getName() {
        return this.name;
    }

    public final String getFullname() {
        return this.name + this.type.suffix();
    }

    protected abstract BinaryValue convert(T var1);

    protected abstract T convert(BinaryValue var1);

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getFullname() == null ? 0 : this.getFullname().hashCode());
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RiakIndex)) {
            return false;
        }
        RiakIndex other = (RiakIndex)obj;
        if (this.getType() != other.getType()) {
            return false;
        }
        return this.getName().equals(other.getName());
    }

    public String toString() {
        return String.format("RiakIndex [name=%s, type=%s]", new Object[]{this.name, this.type});
    }

    public static abstract class Name<T extends RiakIndex<?>> {
        protected final String name;
        protected final IndexType type;
        private volatile Set<BinaryValue> values;

        protected Name(String name, IndexType type) {
            name = name.toLowerCase();
            this.name = this.stripSuffix(name, type);
            this.type = type;
        }

        private String stripSuffix(String name, IndexType type) {
            if (name.endsWith(type.suffix())) {
                return name.substring(0, name.indexOf(type.suffix()));
            }
            return name;
        }

        public final String getName() {
            return this.name;
        }

        public final String getFullname() {
            return this.name + this.type.suffix();
        }

        public final IndexType getType() {
            return this.type;
        }

        final Name<T> wrap(RiakIndex<?> otherIndex) {
            this.values = ((RiakIndex)otherIndex).values;
            return this;
        }

        final Name<T> copyFrom(RiakIndex<?> otherIndex) {
            this.values = Collections.newSetFromMap(new ConcurrentHashMap());
            for (BinaryValue baw : ((RiakIndex)otherIndex).values) {
                this.values.add(baw);
            }
            return this;
        }

        abstract T createIndex();
    }
}

