/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.query.links;

import com.basho.riak.client.core.query.links.RiakLink;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class RiakLinks
implements Iterable<RiakLink> {
    private final Set<RiakLink> links = Collections.newSetFromMap(new ConcurrentHashMap());

    public boolean isEmpty() {
        return this.links.isEmpty();
    }

    public int size() {
        return this.links.size();
    }

    public boolean hasLink(RiakLink link) {
        return this.links.contains(link);
    }

    public RiakLinks addLinks(Collection<RiakLink> links) {
        this.links.addAll(links);
        return this;
    }

    public RiakLinks addLink(RiakLink link) {
        this.links.add(link);
        return this;
    }

    public boolean removeLink(RiakLink link) {
        return this.links.remove(link);
    }

    public void removeAllLinks() {
        this.links.clear();
    }

    public Set<RiakLink> getLinks() {
        return new HashSet<RiakLink>(this.links);
    }

    @Override
    public Iterator<RiakLink> iterator() {
        return this.links.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RiakLinks riakLinks = (RiakLinks)o;
        return this.links.equals(riakLinks.links);
    }

    public int hashCode() {
        return this.links.hashCode();
    }

    public String toString() {
        return "RiakLinks{links: " + this.links + '}';
    }
}

