/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.query.timeseries;

import com.basho.riak.client.core.util.BinaryValue;
import com.basho.riak.client.core.util.CharsetUtils;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import javax.xml.bind.DatatypeConverter;
import shaded.com.basho.riak.protobuf.RiakTsPB;
import shaded.com.google.protobuf.ByteString;

public class Cell {
    private static final int VARCHAR_MASK = 1;
    private static final int SINT64_MASK = 2;
    private static final int DOUBLE_MASK = 4;
    private static final int TIMESTAMP_MASK = 8;
    private static final int BOOLEAN_MASK = 16;
    private static final int BLOB_MASK = 17;
    private int typeBitfield = 0;
    private String varcharValue = "";
    private long sint64Value = 0L;
    private double doubleValue = 0.0;
    private long timestampValue = 0L;
    private boolean booleanValue = false;
    private byte[] blobValue = new byte[0];

    public Cell(String varcharValue) {
        if (varcharValue == null) {
            throw new IllegalArgumentException("String value cannot be NULL.");
        }
        this.initVarchar(varcharValue);
    }

    public Cell(BinaryValue varcharValue) {
        if (varcharValue == null) {
            throw new IllegalArgumentException("BinaryValue value cannot be NULL.");
        }
        this.initVarchar(varcharValue.toStringUtf8());
    }

    public Cell(long sint64Value) {
        this.initSInt64(sint64Value);
    }

    public Cell(double doubleValue) {
        this.initDouble(doubleValue);
    }

    public Cell(boolean booleanValue) {
        this.initBoolean(booleanValue);
    }

    public Cell(Calendar timestampValue) {
        if (timestampValue == null) {
            throw new IllegalArgumentException("Calendar object for timestamp value cannot be NULL.");
        }
        this.initTimestamp(timestampValue.getTimeInMillis());
    }

    public Cell(Date timestampValue) {
        if (timestampValue == null) {
            throw new IllegalArgumentException("Date object for timestamp value cannot be NULL.");
        }
        this.initTimestamp(timestampValue.getTime());
    }

    public Cell(byte[] blobValue) {
        if (blobValue == null) {
            throw new IllegalArgumentException("Value for BLOB value cannot be NULL.");
        }
        this.initBlob(blobValue);
    }

    Cell(RiakTsPB.TsCell pbCell, RiakTsPB.TsColumnDescription columnDescription) {
        if (pbCell.hasBooleanValue()) {
            this.initBoolean(pbCell.getBooleanValue());
        } else if (pbCell.hasDoubleValue()) {
            this.initDouble(pbCell.getDoubleValue());
        } else if (pbCell.hasSint64Value()) {
            this.initSInt64(pbCell.getSint64Value());
        } else if (pbCell.hasTimestampValue()) {
            this.initTimestamp(pbCell.getTimestampValue());
        } else if (pbCell.hasVarcharValue()) {
            RiakTsPB.TsColumnType type = columnDescription == null ? RiakTsPB.TsColumnType.VARCHAR : columnDescription.getType();
            switch (type) {
                case VARCHAR: {
                    this.initVarchar(pbCell.getVarcharValue().toStringUtf8());
                    break;
                }
                case BLOB: {
                    this.initBlob(pbCell.getVarcharValue().toByteArray());
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Type '%s' from the provided ColumnDefinition contradicts to the actual VARCHAR value", type.name()));
                }
            }
        } else {
            throw new IllegalArgumentException("Unknown PB Cell encountered.");
        }
    }

    private Cell() {
    }

    public static Cell newTimestamp(long rawTimestampValue) {
        Cell cell = new Cell();
        cell.initTimestamp(rawTimestampValue);
        return cell;
    }

    private void initBoolean(boolean booleanValue) {
        this.setBitfieldType(16);
        this.booleanValue = booleanValue;
    }

    private void initTimestamp(long timestampValue) {
        this.setBitfieldType(8);
        this.timestampValue = timestampValue;
    }

    private void initDouble(double doubleValue) {
        this.setBitfieldType(4);
        this.doubleValue = doubleValue;
    }

    private void initSInt64(long longValue) {
        this.setBitfieldType(2);
        this.sint64Value = longValue;
    }

    private void initVarchar(String stringValue) {
        this.setBitfieldType(1);
        this.varcharValue = stringValue;
    }

    private void initBlob(byte[] blobValue) {
        this.setBitfieldType(17);
        this.blobValue = blobValue;
    }

    private void setBitfieldType(int mask) {
        this.typeBitfield |= mask;
    }

    private boolean bitfieldHasType(int mask) {
        return this.typeBitfield == mask;
    }

    public boolean hasVarcharValue() {
        return this.bitfieldHasType(1);
    }

    public boolean hasLong() {
        return this.bitfieldHasType(2);
    }

    public boolean hasDouble() {
        return this.bitfieldHasType(4);
    }

    public boolean hasTimestamp() {
        return this.bitfieldHasType(8);
    }

    public boolean hasBoolean() {
        return this.bitfieldHasType(16);
    }

    public boolean hasBlob() {
        return this.bitfieldHasType(17);
    }

    public String getVarcharAsUTF8String() {
        return this.varcharValue;
    }

    public BinaryValue getVarcharValue() {
        return BinaryValue.unsafeCreate(this.varcharValue.getBytes(CharsetUtils.UTF_8));
    }

    public long getLong() {
        return this.sint64Value;
    }

    public double getDouble() {
        return this.doubleValue;
    }

    public long getTimestamp() {
        return this.timestampValue;
    }

    public boolean getBoolean() {
        return this.booleanValue;
    }

    public byte[] getBlob() {
        return this.blobValue;
    }

    RiakTsPB.TsCell getPbCell() {
        RiakTsPB.TsCell.Builder builder = RiakTsPB.TsCell.newBuilder();
        if (this.hasVarcharValue()) {
            builder.setVarcharValue(ByteString.copyFromUtf8(this.varcharValue));
        } else if (this.hasLong()) {
            builder.setSint64Value(this.sint64Value);
        } else if (this.hasTimestamp()) {
            builder.setTimestampValue(this.timestampValue);
        } else if (this.hasBoolean()) {
            builder.setBooleanValue(this.booleanValue);
        } else if (this.hasDouble()) {
            builder.setDoubleValue(this.doubleValue);
        } else if (this.hasBlob()) {
            builder.setVarcharValue(ByteString.copyFrom(this.blobValue));
        }
        return builder.build();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Cell{ ");
        if (this.hasVarcharValue()) {
            String value = this.getVarcharAsUTF8String();
            if (value.length() > 32) {
                sb.append(value.substring(0, 32));
                sb.append("...");
            } else {
                sb.append(value);
            }
        } else if (this.hasLong()) {
            sb.append(this.getLong());
        } else if (this.hasDouble()) {
            sb.append(this.getDouble());
        } else if (this.hasTimestamp()) {
            sb.append(this.getTimestamp());
        } else if (this.hasBoolean()) {
            sb.append(this.getBoolean());
        } else if (this.hasBlob()) {
            int length = this.blobValue.length > 8 ? 8 : this.blobValue.length;
            byte[] blobBlurb = Arrays.copyOfRange(this.blobValue, 0, length);
            sb.append("0x");
            sb.append(DatatypeConverter.printHexBinary((byte[])blobBlurb));
        }
        sb.append(" }");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cell cell = (Cell)o;
        if (this.typeBitfield != cell.typeBitfield) {
            return false;
        }
        if (this.sint64Value != cell.sint64Value) {
            return false;
        }
        if (Double.compare(cell.doubleValue, this.doubleValue) != 0) {
            return false;
        }
        if (this.timestampValue != cell.timestampValue) {
            return false;
        }
        if (this.booleanValue != cell.booleanValue) {
            return false;
        }
        if (this.varcharValue != null ? !this.varcharValue.equals(cell.varcharValue) : cell.varcharValue != null) {
            return false;
        }
        return Arrays.equals(this.blobValue, cell.blobValue);
    }

    public int hashCode() {
        int result = this.typeBitfield;
        result = 31 * result + (this.varcharValue != null ? this.varcharValue.hashCode() : 0);
        result = 31 * result + (int)(this.sint64Value ^ this.sint64Value >>> 32);
        long temp = Double.doubleToLongBits(this.doubleValue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (int)(this.timestampValue ^ this.timestampValue >>> 32);
        result = 31 * result + (this.booleanValue ? 1 : 0);
        result = 31 * result + Arrays.hashCode(this.blobValue);
        return result;
    }
}

