/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.query.timeseries;

import com.basho.riak.client.core.query.timeseries.ColumnDescription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import shaded.com.basho.riak.protobuf.RiakTsPB;
import shaded.com.google.protobuf.ByteString;

public final class CollectionConverters {
    private CollectionConverters() {
    }

    public static Collection<RiakTsPB.TsColumnDescription> convertColumnDescriptionsToPb(Collection<ColumnDescription> columns) {
        ArrayList<RiakTsPB.TsColumnDescription> pbColumns = new ArrayList<RiakTsPB.TsColumnDescription>(columns.size());
        for (ColumnDescription column : columns) {
            pbColumns.add(CollectionConverters.convertColumnDescriptionToPb(column));
        }
        return pbColumns;
    }

    private static RiakTsPB.TsColumnDescription convertColumnDescriptionToPb(ColumnDescription column) {
        RiakTsPB.TsColumnDescription.Builder columnBuilder = RiakTsPB.TsColumnDescription.newBuilder();
        columnBuilder.setName(ByteString.copyFromUtf8(column.getName()));
        columnBuilder.setType(RiakTsPB.TsColumnType.valueOf(column.getType().ordinal()));
        return columnBuilder.build();
    }

    public static List<ColumnDescription> convertPBColumnDescriptions(List<RiakTsPB.TsColumnDescription> pbColumns) {
        if (pbColumns == null) {
            return Collections.emptyList();
        }
        ArrayList<ColumnDescription> columns = new ArrayList<ColumnDescription>(pbColumns.size());
        for (RiakTsPB.TsColumnDescription pbColumn : pbColumns) {
            ColumnDescription columnDescription = CollectionConverters.convertPBColumnDescription(pbColumn);
            columns.add(columnDescription);
        }
        return columns;
    }

    private static ColumnDescription convertPBColumnDescription(RiakTsPB.TsColumnDescription pbColumn) {
        String name = pbColumn.getName().toStringUtf8();
        ColumnDescription.ColumnType type = ColumnDescription.ColumnType.values()[pbColumn.getType().getNumber()];
        return new ColumnDescription(name, type);
    }
}

