/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.query.timeseries;

import com.basho.riak.client.core.query.ConvertibleIterator;
import com.basho.riak.client.core.query.timeseries.Cell;
import com.basho.riak.client.core.query.timeseries.Row;
import java.util.Iterator;
import shaded.com.basho.riak.protobuf.RiakTsPB;

class ConvertibleIteratorUtils {
    private static final RiakTsPB.TsCell NullTSCell = RiakTsPB.TsCell.newBuilder().build();

    private ConvertibleIteratorUtils() {
    }

    public static ConvertibleIterator<RiakTsPB.TsRow, Row> iterateAsRow(Iterator<RiakTsPB.TsRow> iterator, Iterable<RiakTsPB.TsColumnDescription> columnDescriptions) {
        return new ImmutableRowIterator(iterator, columnDescriptions);
    }

    public static ConvertibleIterator<Cell, RiakTsPB.TsCell> iterateAsPbCell(Iterator<Cell> iterator) {
        return new ImmutablePBCellIterator(iterator);
    }

    public static ConvertibleZipperator<RiakTsPB.TsCell, RiakTsPB.TsColumnDescription, Cell> iterateAsCell(Iterator<RiakTsPB.TsCell> cellIterator, Iterator<RiakTsPB.TsColumnDescription> columnDescriptionIterator) {
        return new ImmutableCellIterator(cellIterator, columnDescriptionIterator);
    }

    private static class ImmutableRowIterator
    extends ConvertibleIterator<RiakTsPB.TsRow, Row> {
        private final Iterable<RiakTsPB.TsColumnDescription> columnDescriptions;

        public ImmutableRowIterator(Iterator<RiakTsPB.TsRow> iterator, Iterable<RiakTsPB.TsColumnDescription> columnDescriptions) {
            super(iterator);
            this.columnDescriptions = columnDescriptions;
        }

        @Override
        protected Row convert(RiakTsPB.TsRow source) {
            return new Row(source, this.columnDescriptions);
        }
    }

    private static class ImmutableCellIterator
    extends ConvertibleZipperator<RiakTsPB.TsCell, RiakTsPB.TsColumnDescription, Cell> {
        public ImmutableCellIterator(Iterator<RiakTsPB.TsCell> cellIterator, Iterator<RiakTsPB.TsColumnDescription> descriptionIterator) {
            super(cellIterator, descriptionIterator);
        }

        @Override
        protected Cell convert(RiakTsPB.TsCell pbCell, RiakTsPB.TsColumnDescription columnDescription) {
            if (pbCell.equals(NullTSCell)) {
                return null;
            }
            return new Cell(pbCell, columnDescription);
        }

        @Override
        public boolean hasNext() {
            return this.iterator1.hasNext();
        }

        @Override
        public Cell next() {
            RiakTsPB.TsColumnDescription description = this.iterator2.hasNext() ? (RiakTsPB.TsColumnDescription)this.iterator2.next() : null;
            return this.convert((RiakTsPB.TsCell)this.iterator1.next(), description);
        }
    }

    private static abstract class ConvertibleZipperator<S, S2, D>
    implements Iterator<D> {
        protected final Iterator<S> iterator1;
        protected final Iterator<S2> iterator2;

        public ConvertibleZipperator(Iterator<S> iterator, Iterator<S2> iterator2) {
            this.iterator1 = iterator;
            this.iterator2 = iterator2;
        }

        protected abstract D convert(S var1, S2 var2);

        @Override
        public boolean hasNext() {
            return this.iterator1.hasNext() && this.iterator2.hasNext();
        }

        @Override
        public D next() {
            return this.convert(this.iterator1.next(), this.iterator2.next());
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ImmutablePBCellIterator
    extends ConvertibleIterator<Cell, RiakTsPB.TsCell> {
        public ImmutablePBCellIterator(Iterator<Cell> iterator) {
            super(iterator);
        }

        @Override
        protected RiakTsPB.TsCell convert(Cell cell) {
            if (cell == null) {
                return NullTSCell;
            }
            return cell.getPbCell();
        }
    }
}

