/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.query.timeseries;

import com.basho.riak.client.core.query.timeseries.Cell;
import com.basho.riak.client.core.query.timeseries.ColumnDescription;
import com.basho.riak.client.core.query.timeseries.FullColumnDescription;
import com.basho.riak.client.core.query.timeseries.Quantum;
import com.basho.riak.client.core.query.timeseries.QueryResult;
import com.basho.riak.client.core.query.timeseries.Row;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

class DescribeQueryResultParser {
    private static final int NAME_IDX = 0;
    private static final int TYPE_IDX = 1;
    private static final int NULLABLE_IDX = 2;
    private static final int PARTITION_KEY_IDX = 3;
    private static final int LOCAL_KEY_IDX = 4;
    private static final int QUANTUM_INTERVAL_IDX = 5;
    private static final int QUANTUM_UNIT_IDX = 6;
    private static final int SORT_ORDER_IDX = 7;

    DescribeQueryResultParser() {
    }

    static List<FullColumnDescription> ConvertToColumnDescriptions(QueryResult queryResult) {
        ArrayList<FullColumnDescription> fullColumnDescriptions = new ArrayList<FullColumnDescription>(queryResult.getRowsCount());
        for (Row row : queryResult) {
            fullColumnDescriptions.add(DescribeQueryResultParser.convertDescribeResultRowToFullColumnDescription(row));
        }
        return fullColumnDescriptions;
    }

    private static FullColumnDescription convertDescribeResultRowToFullColumnDescription(Row row) {
        List<Cell> cells = row.getCellsCopy();
        assert (DescribeQueryResultParser.DescribeFnRowResultIsValid(cells));
        String name = cells.get(0).getVarcharAsUTF8String();
        String typeString = cells.get(1).getVarcharAsUTF8String();
        boolean isNullable = cells.get(2).getBoolean();
        Integer partitionKeyOrdinal = DescribeQueryResultParser.parseKeyCell(cells.get(3));
        Integer localKeyOrdinal = DescribeQueryResultParser.parseKeyCell(cells.get(4));
        ColumnDescription.ColumnType type = ColumnDescription.ColumnType.valueOf(typeString.toUpperCase(Locale.ENGLISH));
        Quantum quantum = DescribeQueryResultParser.parseQuantumCells(cells);
        FullColumnDescription.KeyOrder keyOrder = DescribeQueryResultParser.parseSortOrder(cells);
        return new FullColumnDescription(name, type, isNullable, partitionKeyOrdinal, localKeyOrdinal, quantum, keyOrder);
    }

    private static Integer parseKeyCell(Cell keyCell) {
        boolean isKeyMember = keyCell != null;
        return isKeyMember ? Integer.valueOf(new Long(keyCell.getLong()).intValue()) : null;
    }

    private static Quantum parseQuantumCells(List<Cell> cells) {
        boolean hasQuantum;
        if (cells.size() < 7) {
            return null;
        }
        Cell quantumIntervalCell = cells.get(5);
        Cell quantumUnitCell = cells.get(6);
        boolean bl = hasQuantum = quantumIntervalCell != null && quantumUnitCell != null;
        if (!hasQuantum) {
            return null;
        }
        Long quantumInterval = quantumIntervalCell.getLong();
        TimeUnit quantumUnit = Quantum.parseTimeUnit(quantumUnitCell.getVarcharAsUTF8String());
        return new Quantum(quantumInterval.intValue(), quantumUnit);
    }

    private static FullColumnDescription.KeyOrder parseSortOrder(List<Cell> cells) {
        if (cells.size() < 8) {
            return null;
        }
        Cell sortCell = cells.get(7);
        if (sortCell == null || !sortCell.hasVarcharValue()) {
            return null;
        }
        if (sortCell.getVarcharAsUTF8String().equalsIgnoreCase("ASC")) {
            return FullColumnDescription.KeyOrder.ASC;
        }
        if (sortCell.getVarcharAsUTF8String().equalsIgnoreCase("DESC")) {
            return FullColumnDescription.KeyOrder.DESC;
        }
        return null;
    }

    private static boolean DescribeFnRowResultIsValid(List<Cell> cells) {
        boolean describeBaseIsValid = DescribeQueryResultParser.DescribeRowV1ChunkIsValid(cells);
        boolean isValidV1Description = describeBaseIsValid && cells.size() == 5;
        boolean isValidV2Description = describeBaseIsValid && cells.size() == 7 && DescribeQueryResultParser.DescribeRowV2ChunkIsValid(cells);
        boolean isValidV3Description = describeBaseIsValid && cells.size() == 8 && DescribeQueryResultParser.DescribeRowV3ChunkIsValid(cells);
        return isValidV1Description || isValidV2Description || isValidV3Description;
    }

    private static boolean DescribeRowV1ChunkIsValid(List<Cell> cells) {
        if (cells.size() < 5) {
            return false;
        }
        Cell partitionKeyCell = cells.get(3);
        Cell localKeyCell = cells.get(4);
        return cells.get(0).hasVarcharValue() && cells.get(1).hasVarcharValue() && cells.get(2).hasBoolean() && partitionKeyCell != null ? partitionKeyCell.hasLong() : (localKeyCell != null ? localKeyCell.hasLong() : true);
    }

    private static boolean DescribeRowV2ChunkIsValid(List<Cell> cells) {
        if (cells.size() < 7) {
            return false;
        }
        Cell quantumIntervalCell = cells.get(5);
        Cell quantumUnitCell = cells.get(6);
        return quantumIntervalCell != null ? quantumIntervalCell.hasLong() : (quantumUnitCell != null ? quantumUnitCell.hasVarcharValue() : true);
    }

    private static boolean DescribeRowV3ChunkIsValid(List<Cell> cells) {
        if (cells.size() < 8) {
            return false;
        }
        Cell sortOrderCell = cells.get(7);
        return sortOrderCell != null ? sortOrderCell.hasVarcharValue() : true;
    }
}

