/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.query.timeseries;

import com.basho.riak.client.core.query.timeseries.ColumnDescription;
import com.basho.riak.client.core.query.timeseries.Quantum;

public class FullColumnDescription
extends ColumnDescription {
    private final boolean isNullable;
    private final Integer partitionKeyOrdinal;
    private final Integer localKeyOrdinal;
    private final Quantum quantum;
    private final KeyOrder keyOrder;

    public FullColumnDescription(String name, ColumnDescription.ColumnType type, boolean isNullable) {
        this(name, type, isNullable, null, null, null, null);
    }

    public FullColumnDescription(String name, ColumnDescription.ColumnType type, boolean isNullable, Integer keyOrdinal) {
        this(name, type, isNullable, keyOrdinal, keyOrdinal);
    }

    public FullColumnDescription(String name, ColumnDescription.ColumnType type, boolean isNullable, Integer keyOrdinal, KeyOrder keyOrder) {
        this(name, type, isNullable, keyOrdinal, keyOrdinal, null, keyOrder);
    }

    public FullColumnDescription(String name, ColumnDescription.ColumnType type, boolean isNullable, Integer keyOrdinal, Quantum quantum) {
        this(name, type, isNullable, keyOrdinal, keyOrdinal, quantum, null);
    }

    public FullColumnDescription(String name, ColumnDescription.ColumnType type, boolean isNullable, Integer partitionKeyOrdinal, Integer localKeyOrdinal) {
        this(name, type, isNullable, partitionKeyOrdinal, localKeyOrdinal, null, null);
    }

    public FullColumnDescription(String name, ColumnDescription.ColumnType type, boolean isNullable, Integer partitionKeyOrdinal, Integer localKeyOrdinal, KeyOrder keyOrder) {
        this(name, type, isNullable, partitionKeyOrdinal, localKeyOrdinal, null, keyOrder);
    }

    public FullColumnDescription(String name, ColumnDescription.ColumnType type, boolean isNullable, Integer partitionKeyOrdinal, Integer localKeyOrdinal, Quantum quantum) {
        this(name, type, isNullable, partitionKeyOrdinal, localKeyOrdinal, quantum, null);
    }

    public FullColumnDescription(String name, ColumnDescription.ColumnType type, boolean isNullable, Integer partitionKeyOrdinal, Integer localKeyOrdinal, Quantum quantum, KeyOrder keyOrder) {
        super(name, type);
        this.isNullable = isNullable;
        this.partitionKeyOrdinal = partitionKeyOrdinal;
        this.localKeyOrdinal = localKeyOrdinal;
        this.validateQuantumUsage(type, partitionKeyOrdinal, quantum);
        this.quantum = quantum;
        this.keyOrder = keyOrder;
    }

    private void validateQuantumUsage(ColumnDescription.ColumnType type, Integer partitionKeyOrdinal, Quantum quantum) {
        if (quantum != null) {
            if (type != ColumnDescription.ColumnType.TIMESTAMP) {
                throw new IllegalArgumentException(String.format("Cannot apply a quantum to a non-Timestamp type column, current column is %s.", new Object[]{type}));
            }
            if (partitionKeyOrdinal == null) {
                throw new IllegalArgumentException("Cannot apply a quantum to a column that is not part of the partition key.");
            }
        }
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public boolean isPartitionKeyMember() {
        return this.partitionKeyOrdinal != null;
    }

    public boolean isLocalKeyMember() {
        return this.localKeyOrdinal != null;
    }

    public Integer getPartitionKeyOrdinal() {
        return this.partitionKeyOrdinal;
    }

    public Integer getLocalKeyOrdinal() {
        return this.localKeyOrdinal;
    }

    public Quantum getQuantum() {
        return this.quantum;
    }

    public boolean hasQuantum() {
        return this.quantum != null;
    }

    public KeyOrder getKeyOrder() {
        return this.keyOrder;
    }

    public boolean hasKeyOrder() {
        return this.keyOrder != null;
    }

    public static enum KeyOrder {
        ASC,
        DESC;

    }
}

