/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.query.timeseries;

import com.basho.riak.client.core.query.timeseries.CoverageEntry;
import com.basho.riak.client.core.query.timeseries.CoveragePlanResult;
import com.basho.riak.client.core.query.timeseries.DescribeQueryResultParser;
import com.basho.riak.client.core.query.timeseries.FlatteningIterable;
import com.basho.riak.client.core.query.timeseries.QueryResult;
import com.basho.riak.client.core.query.timeseries.TableDefinition;
import java.util.List;
import org.slf4j.LoggerFactory;
import shaded.com.basho.riak.protobuf.RiakTsPB;

public final class PbResultFactory {
    private PbResultFactory() {
    }

    public static QueryResult convertPbQueryResp(RiakTsPB.TsQueryResp response) {
        if (response == null) {
            return QueryResult.EMPTY;
        }
        return new QueryResult(response.getColumnsList(), response.getRowsList());
    }

    public static QueryResult convertPbGetResp(RiakTsPB.TsGetResp response) {
        if (response == null) {
            return QueryResult.EMPTY;
        }
        return new QueryResult(response.getColumnsList(), response.getRowsList());
    }

    public static QueryResult convertPbListKeysResp(List<RiakTsPB.TsListKeysResp> responseChunks) {
        if (responseChunks == null) {
            return QueryResult.EMPTY;
        }
        int totalKeyCount = 0;
        for (RiakTsPB.TsListKeysResp responseChunk : responseChunks) {
            totalKeyCount += responseChunk.getKeysCount();
        }
        FlatteningIterable flatIterable = new FlatteningIterable(responseChunks, provider -> provider.getKeysList().iterator());
        return new QueryResult(flatIterable, totalKeyCount);
    }

    public static TableDefinition convertDescribeResp(String tableName, RiakTsPB.TsQueryResp response) {
        if (response == null || response.getRowsCount() == 0) {
            return null;
        }
        QueryResult intermediaryQueryResult = new QueryResult(response.getColumnsList(), response.getRowsList());
        return new TableDefinition(tableName, DescribeQueryResultParser.ConvertToColumnDescriptions(intermediaryQueryResult));
    }

    public static CoveragePlanResult convertCoverageResp(String tableName, RiakTsPB.TsCoverageResp response) {
        if (response == null || response.getEntriesCount() == 0) {
            return null;
        }
        CoveragePlanResult r = new CoveragePlanResult();
        for (RiakTsPB.TsCoverageEntry e : response.getEntriesList()) {
            CoverageEntry ce = new CoverageEntry();
            ce.setCoverageContext(e.getCoverContext().toByteArray());
            if (e.hasRange()) {
                RiakTsPB.TsRange range = e.getRange();
                ce.setFieldName(range.getFieldName().toStringUtf8());
                ce.setLowerBound(range.getLowerBound());
                ce.setLowerBoundInclusive(range.getLowerBoundInclusive());
                ce.setUpperBound(range.getUpperBound());
                ce.setUpperBoundInclusive(range.getUpperBoundInclusive());
                ce.setDescription(range.getDesc().toStringUtf8());
            }
            ce.setHost(e.getIp().toStringUtf8());
            ce.setPort(e.getPort());
            if ("0.0.0.0".equals(ce.getHost())) {
                LoggerFactory.getLogger(CoveragePlanResult.class).error("CoveragePlanOperation returns at least one coverage entry: '{}' -- with IP address '0.0.0.0'.\nExecution will be failed due to the imposibility of using IP '0.0.0.0' for querying data from the remote Riak.", (Object)ce);
                throw new RuntimeException("CoveragePlanOperation returns at least one coverage entry with ip '0.0.0.0'.");
            }
            r.addEntry(ce);
        }
        return r;
    }
}

