/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.query.timeseries;

import com.basho.riak.client.core.query.timeseries.CollectionConverters;
import com.basho.riak.client.core.query.timeseries.ColumnDescription;
import com.basho.riak.client.core.query.timeseries.ConvertibleIteratorUtils;
import com.basho.riak.client.core.query.timeseries.Row;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import shaded.com.basho.riak.protobuf.RiakTsPB;

public class QueryResult
implements Iterable<Row> {
    public static final QueryResult EMPTY = new QueryResult();
    private final Iterable<RiakTsPB.TsRow> pbRows;
    private final Row[] rows;
    private final int rowCount;
    private final List<RiakTsPB.TsColumnDescription> pbColumnDescriptions;

    private QueryResult() {
        this.pbRows = Collections.emptyList();
        this.rowCount = 0;
        this.pbColumnDescriptions = Collections.emptyList();
        this.rows = null;
    }

    public QueryResult(List<RiakTsPB.TsRow> tsRows) {
        this(Collections.emptyList(), tsRows);
    }

    public QueryResult(Iterable<RiakTsPB.TsRow> tsRowsIterator, int rowCount) {
        this.pbColumnDescriptions = null;
        this.pbRows = tsRowsIterator;
        this.rowCount = rowCount;
        this.rows = null;
    }

    public QueryResult(List<RiakTsPB.TsColumnDescription> columnsList, List<RiakTsPB.TsRow> rowsList) {
        this.pbColumnDescriptions = columnsList;
        this.pbRows = rowsList;
        this.rowCount = rowsList.size();
        this.rows = null;
    }

    public QueryResult(Row[] rows) {
        this.rows = rows;
        this.rowCount = rows.length;
        this.pbRows = Collections.emptyList();
        this.pbColumnDescriptions = Collections.emptyList();
    }

    public List<ColumnDescription> getColumnDescriptionsCopy() {
        return CollectionConverters.convertPBColumnDescriptions(this.pbColumnDescriptions);
    }

    @Override
    public Iterator<Row> iterator() {
        if (this.rows != null) {
            return Arrays.asList(this.rows).iterator();
        }
        return ConvertibleIteratorUtils.iterateAsRow(this.pbRows.iterator(), this.pbColumnDescriptions);
    }

    public int getRowsCount() {
        return this.rowCount;
    }

    public List<Row> getRowsCopy() {
        ArrayList<Row> rows = new ArrayList<Row>(this.getRowsCount());
        for (Row cells : this) {
            rows.add(cells);
        }
        return rows;
    }
}

