/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.query.timeseries;

import com.basho.riak.client.core.query.timeseries.Cell;
import com.basho.riak.client.core.query.timeseries.ConvertibleIterable;
import com.basho.riak.client.core.query.timeseries.ConvertibleIteratorUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import shaded.com.basho.riak.protobuf.RiakTsPB;

public class Row
implements Iterable<Cell> {
    private final RiakTsPB.TsRow pbRow;
    private final Iterable<RiakTsPB.TsColumnDescription> pbColumnDescriptions;
    private final Iterable<Cell> cells;
    private final int cellCount;

    public Row(Iterable<Cell> cells) {
        this.pbRow = null;
        this.pbColumnDescriptions = null;
        this.cells = cells;
        int cellCount = 0;
        for (Cell ignored : this.cells) {
            ++cellCount;
        }
        this.cellCount = cellCount;
    }

    public Row(Cell ... cells) {
        this.pbRow = null;
        this.pbColumnDescriptions = null;
        this.cells = Arrays.asList(cells);
        this.cellCount = cells.length;
    }

    Row(RiakTsPB.TsRow pbRow, Iterable<RiakTsPB.TsColumnDescription> pbColumnDescriptions) {
        this.pbRow = pbRow;
        this.pbColumnDescriptions = pbColumnDescriptions;
        this.cells = null;
        this.cellCount = pbRow.getCellsCount();
    }

    public int getCellsCount() {
        return this.cellCount;
    }

    public List<Cell> getCellsCopy() {
        ArrayList<Cell> cells = new ArrayList<Cell>(this.getCellsCount());
        for (Cell c : this) {
            cells.add(c);
        }
        return cells;
    }

    public RiakTsPB.TsRow getPbRow() {
        if (this.pbRow != null) {
            return this.pbRow;
        }
        RiakTsPB.TsRow.Builder builder = RiakTsPB.TsRow.newBuilder();
        builder.addAllCells(ConvertibleIterable.asIterablePbCell(this.cells));
        return builder.build();
    }

    @Override
    public Iterator<Cell> iterator() {
        if (this.cells != null) {
            return this.cells.iterator();
        }
        assert (this.pbRow != null);
        return ConvertibleIteratorUtils.iterateAsCell(this.pbRow.getCellsList().iterator(), this.pbColumnDescriptions == null ? Collections.emptyIterator() : this.pbColumnDescriptions.iterator());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Row cells1 = (Row)o;
        if (this.cellCount != cells1.cellCount) {
            return false;
        }
        return this.getCellsCopy().equals(cells1.getCellsCopy());
    }

    public int hashCode() {
        int result = this.pbRow != null ? this.pbRow.hashCode() : 0;
        result = 31 * result + (this.cells != null ? this.cells.hashCode() : 0);
        result = 31 * result + this.cellCount;
        return result;
    }
}

