/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.util;

import com.basho.riak.client.core.util.DefaultCharset;
import java.nio.charset.Charset;
import java.util.Arrays;

public final class BinaryValue {
    private static final Charset theUTF8 = Charset.forName("UTF-8");
    private final byte[] data;

    private BinaryValue(byte[] data) {
        this.data = data;
    }

    public static BinaryValue create(byte[] data) {
        if (data != null) {
            data = Arrays.copyOf(data, data.length);
        }
        return new BinaryValue(data);
    }

    public static BinaryValue create(String data) {
        return BinaryValue.create(data, DefaultCharset.get());
    }

    public static BinaryValue createFromUtf8(String data) {
        return BinaryValue.create(data, theUTF8);
    }

    public static BinaryValue create(String data, Charset charset) {
        byte[] bytes = null;
        if (data != null) {
            bytes = data.getBytes(charset);
        }
        return new BinaryValue(bytes);
    }

    public static BinaryValue unsafeCreate(byte[] data) {
        return new BinaryValue(data);
    }

    public byte[] getValue() {
        if (this.data != null) {
            return Arrays.copyOf(this.data, this.data.length);
        }
        return null;
    }

    public byte[] unsafeGetValue() {
        return this.data;
    }

    public boolean equals(Object other) {
        if (!(other instanceof BinaryValue)) {
            return false;
        }
        return Arrays.equals(this.data, ((BinaryValue)other).data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public String toString() {
        return this.toString(DefaultCharset.get());
    }

    public String toStringUtf8() {
        return this.toString(theUTF8);
    }

    public String toString(Charset charset) {
        if (this.data != null) {
            return new String(this.data, charset);
        }
        return null;
    }

    public int length() {
        return this.data.length;
    }
}

