/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jackson.rison;

import com.bazaarvoice.jackson.rison.ModuleVersion;
import com.bazaarvoice.jackson.rison.RisonGenerator;
import com.bazaarvoice.jackson.rison.RisonParser;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.format.InputAccessor;
import com.fasterxml.jackson.core.format.MatchStrength;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class RisonFactory
extends JsonFactory {
    public static final String FORMAT_NAME_RISON = "Rison";
    static final int DEFAULT_RISON_PARSER_FEATURE_FLAGS = RisonParser.Feature.collectDefaults();
    static final int DEFAULT_RISON_GENERATOR_FEATURE_FLAGS = RisonGenerator.Feature.collectDefaults();
    protected int _risonParserFeatures = DEFAULT_RISON_PARSER_FEATURE_FLAGS;
    protected int _risonGeneratorFeatures = DEFAULT_RISON_GENERATOR_FEATURE_FLAGS;

    public RisonFactory() {
        this(null);
    }

    public RisonFactory(ObjectCodec codec) {
        super(codec);
    }

    public RisonFactory copy() {
        this._checkInvalidCopy(RisonFactory.class);
        return new RisonFactory(null);
    }

    protected Object readResolve() {
        return new RisonFactory(this._objectCodec);
    }

    public String getFormatName() {
        return FORMAT_NAME_RISON;
    }

    public MatchStrength hasFormat(InputAccessor acc) throws IOException {
        return MatchStrength.SOLID_MATCH;
    }

    public Version version() {
        return ModuleVersion.instance.version();
    }

    public final RisonFactory configure(RisonParser.Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public RisonFactory enable(RisonParser.Feature f) {
        this._risonParserFeatures |= f.getMask();
        return this;
    }

    public RisonFactory disable(RisonParser.Feature f) {
        this._risonParserFeatures &= ~f.getMask();
        return this;
    }

    public boolean isEnabled(RisonParser.Feature f) {
        return (this._risonParserFeatures & f.getMask()) != 0;
    }

    public RisonFactory configure(RisonGenerator.Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public RisonFactory enable(RisonGenerator.Feature f) {
        this._risonGeneratorFeatures |= f.getMask();
        return this;
    }

    public RisonFactory disable(RisonGenerator.Feature f) {
        this._risonGeneratorFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(RisonGenerator.Feature f) {
        return (this._risonGeneratorFeatures & f.getMask()) != 0;
    }

    protected RisonParser _createParser(InputStream in, IOContext ctxt) throws IOException, JsonParseException {
        return this._createJsonParser(in, ctxt);
    }

    protected RisonParser _createParser(Reader r, IOContext ctxt) throws IOException, JsonParseException {
        return this._createJsonParser(r, ctxt);
    }

    protected RisonParser _createParser(byte[] data, int offset, int len, IOContext ctxt) throws IOException, JsonParseException {
        return this._createJsonParser(data, offset, len, ctxt);
    }

    @Deprecated
    protected RisonParser _createJsonParser(InputStream in, IOContext ctxt) throws IOException, JsonParseException {
        return this._createJsonParser(new InputStreamReader(in, "UTF-8"), ctxt);
    }

    @Deprecated
    protected RisonParser _createJsonParser(Reader r, IOContext ctxt) throws IOException, JsonParseException {
        return new RisonParser(ctxt, this._parserFeatures, this._risonParserFeatures, r, this._objectCodec, this._rootCharSymbols.makeChild(this.isEnabled(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES), this.isEnabled(JsonFactory.Feature.INTERN_FIELD_NAMES)));
    }

    @Deprecated
    protected RisonParser _createJsonParser(byte[] data, int offset, int len, IOContext ctxt) throws IOException, JsonParseException {
        return this._createJsonParser(new ByteArrayInputStream(data, offset, len), ctxt);
    }

    protected RisonGenerator _createGenerator(Writer out, IOContext ctxt) throws IOException {
        return this._createJsonGenerator(out, ctxt);
    }

    @Deprecated
    protected RisonGenerator _createJsonGenerator(Writer out, IOContext ctxt) throws IOException {
        RisonGenerator gen = new RisonGenerator(ctxt, this._generatorFeatures, this._risonGeneratorFeatures, this._objectCodec, out);
        SerializableString rootSep = this._rootValueSeparator;
        if (rootSep != DefaultPrettyPrinter.DEFAULT_ROOT_VALUE_SEPARATOR) {
            gen.setRootValueSeparator(rootSep);
        }
        return gen;
    }

    protected RisonGenerator _createUTF8Generator(OutputStream out, IOContext ctxt) throws IOException {
        return this._createUTF8JsonGenerator(out, ctxt);
    }

    @Deprecated
    protected RisonGenerator _createUTF8JsonGenerator(OutputStream out, IOContext ctxt) throws IOException {
        return this._createJsonGenerator(this._createWriter(out, JsonEncoding.UTF8, ctxt), ctxt);
    }
}

