/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.config.apidoc;

import io.swagger.v3.oas.models.info.Info;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.customizers.ActuatorOpenApiCustomizer;
import org.springdoc.core.customizers.ActuatorOperationCustomizer;
import org.springdoc.core.customizers.OpenApiCustomizer;
import org.springdoc.core.customizers.OperationCustomizer;
import org.springdoc.core.models.GroupedOpenApi;
import org.springdoc.core.utils.SpringDocUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import tech.jhipster.config.JHipsterProperties;
import tech.jhipster.config.apidoc.customizer.JHipsterOpenApiCustomizer;

@Configuration
public class JHipsterSpringDocGroupsConfiguration {
    public static final String MANAGEMENT_GROUP_NAME = "management";
    static final String MANAGEMENT_TITLE_SUFFIX = "Management API";
    static final String MANAGEMENT_DESCRIPTION = "Management endpoints documentation";
    private final Logger log = LoggerFactory.getLogger(JHipsterSpringDocGroupsConfiguration.class);
    private final JHipsterProperties.ApiDocs properties;

    public JHipsterSpringDocGroupsConfiguration(JHipsterProperties jHipsterProperties) {
        this.properties = jHipsterProperties.getApiDocs();
    }

    @Bean
    public JHipsterOpenApiCustomizer jhipsterOpenApiCustomizer() {
        this.log.debug("Initializing JHipster OpenApi customizer");
        return new JHipsterOpenApiCustomizer(this.properties);
    }

    @Bean
    @ConditionalOnMissingBean(name={"openAPIDefaultGroupedOpenAPI"})
    public GroupedOpenApi openAPIDefaultGroupedOpenAPI(List<OpenApiCustomizer> openApiCustomizers, List<OperationCustomizer> operationCustomizers, @Qualifier(value="apiFirstGroupedOpenAPI") Optional<GroupedOpenApi> apiFirstGroupedOpenAPI) {
        this.log.debug("Initializing JHipster OpenApi default group");
        GroupedOpenApi.Builder builder = GroupedOpenApi.builder().group("springdocDefault").pathsToMatch(this.properties.getDefaultIncludePattern());
        openApiCustomizers.stream().filter(customizer -> !(customizer instanceof ActuatorOpenApiCustomizer)).forEach(arg_0 -> ((GroupedOpenApi.Builder)builder).addOpenApiCustomizer(arg_0));
        operationCustomizers.stream().filter(customizer -> !(customizer instanceof ActuatorOperationCustomizer)).forEach(arg_0 -> ((GroupedOpenApi.Builder)builder).addOperationCustomizer(arg_0));
        apiFirstGroupedOpenAPI.map(GroupedOpenApi::getPackagesToScan).ifPresent(packagesToScan -> packagesToScan.forEach(xva$0 -> builder.packagesToExclude(new String[]{xva$0})));
        return builder.build();
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties"})
    @ConditionalOnMissingBean(name={"openAPIManagementGroupedOpenAPI"})
    @ConditionalOnProperty(value={"springdoc.show-actuator"})
    public GroupedOpenApi openAPIManagementGroupedOpenAPI(@Value(value="${spring.application.name:application}") String appName) {
        this.log.debug("Initializing JHipster OpenApi management group");
        return GroupedOpenApi.builder().group(MANAGEMENT_GROUP_NAME).addOpenApiCustomizer(openApi -> openApi.info(new Info().title(StringUtils.capitalize((String)appName) + " Management API").description(MANAGEMENT_DESCRIPTION).version(this.properties.getVersion()))).pathsToMatch(this.properties.getManagementIncludePattern()).build();
    }

    static {
        SpringDocUtils.getConfig().replaceWithClass(ByteBuffer.class, String.class);
    }
}

