/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.service;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.List;
import java.util.Objects;
import tech.jhipster.service.aggregate.Aggregate;
import tech.jhipster.service.aggregate.DateTimeGroupBy;
import tech.jhipster.service.aggregate.GroupByExpress;
import tech.jhipster.service.aggregate.NumberAggregate;

public class AggregateUtil {
    public static void buildAggregate(Aggregate filter, String field, List<Selection<?>> selects, CriteriaBuilder cb, Root<?> root) {
        if (Objects.equals(filter.getCount(), true)) {
            selects.add(cb.countDistinct((Expression)root.get(field)).alias(field + "_count"));
        }
    }

    public static void buildAggregate(NumberAggregate filter, String field, List<Selection<?>> selects, CriteriaBuilder cb, Root<?> root) {
        if (Objects.equals(filter.getSum(), true)) {
            selects.add(cb.sum((Expression)root.get(field)).alias(field + "_sum"));
        }
        if (Objects.equals(filter.getAvg(), true)) {
            selects.add(cb.avg((Expression)root.get(field)).alias(field + "_avg"));
        }
        if (Objects.equals(filter.getMin(), true)) {
            selects.add(cb.min((Expression)root.get(field)).alias(field + "_min"));
        }
        if (Objects.equals(filter.getMax(), true)) {
            selects.add(cb.max((Expression)root.get(field)).alias(field + "_max"));
        }
    }

    public static void buildGroupBy(GroupByExpress groupByExpress, String field, List<Expression<?>> groupBys, List<Selection<?>> selects, CriteriaBuilder cb, Root<?> root) {
        if (Objects.equals(groupByExpress.getJoin(), true)) {
            groupBys.add((Expression<?>)root.get(field));
            selects.add((Selection<?>)root.get(field));
        }
    }

    public static void buildGroupBy(DateTimeGroupBy groupByExpress, String field, List<Expression<?>> groupBys, List<Selection<?>> selects, CriteriaBuilder cb, String databaseProductName, Root<?> root) {
        if (Objects.nonNull(groupByExpress)) {
            Expression fieldExpress;
            boolean isAdded = false;
            if (Objects.equals(groupByExpress.getYear(), true)) {
                fieldExpress = null;
                switch (databaseProductName.trim().toLowerCase()) {
                    case "mysql": 
                    case "mariadb": 
                    case "h2": 
                    case "db2": 
                    case "hsql": 
                    case "dm": 
                    case "kingbase_es": 
                    case "gbase": 
                    case "ocean_base": 
                    case "oscar": {
                        fieldExpress = cb.function("year", Integer.class, new Expression[]{cb.literal((Object)field)});
                        break;
                    }
                    case "oracle": 
                    case "gauss": {
                        fieldExpress = cb.function("to_char", Integer.class, new Expression[]{cb.literal((Object)field), cb.literal((Object)"yyyy")});
                        break;
                    }
                    case "sql_server": {
                        fieldExpress = cb.function("datepart", Integer.class, new Expression[]{cb.literal((Object)"year"), cb.literal((Object)field)});
                        break;
                    }
                    case "postgresql": {
                        fieldExpress = cb.function("date_part", Integer.class, new Expression[]{cb.literal((Object)"year"), cb.literal((Object)field)});
                        break;
                    }
                    case "sqlite": {
                        fieldExpress = cb.function("strftime", Integer.class, new Expression[]{cb.literal((Object)"%Y"), cb.literal((Object)field)});
                        break;
                    }
                    default: {
                        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b");
                    }
                }
                fieldExpress.alias(field + "_year");
                selects.add((Selection<?>)fieldExpress);
                groupBys.add(fieldExpress);
                isAdded = true;
            }
            if (Objects.equals(groupByExpress.getMonth(), true)) {
                fieldExpress = null;
                switch (databaseProductName.trim().toLowerCase()) {
                    case "mysql": 
                    case "db2": 
                    case "h2": 
                    case "hsql": 
                    case "dm": 
                    case "kingbase_es": 
                    case "gbase": 
                    case "ocean_base": 
                    case "oscar": {
                        fieldExpress = cb.function("month", Integer.class, new Expression[]{cb.literal((Object)field)});
                        break;
                    }
                    case "oracle": 
                    case "gauss": {
                        fieldExpress = cb.function("to_char", Integer.class, new Expression[]{cb.literal((Object)field), cb.literal((Object)"mm")});
                        break;
                    }
                    case "sql_server": {
                        fieldExpress = cb.function("datepart", Integer.class, new Expression[]{cb.literal((Object)"month"), cb.literal((Object)field)});
                        break;
                    }
                    case "postgresql": {
                        fieldExpress = cb.function("date_part", Integer.class, new Expression[]{cb.literal((Object)"month"), cb.literal((Object)field)});
                        break;
                    }
                    case "sqlite": {
                        fieldExpress = cb.function("strftime", Integer.class, new Expression[]{cb.literal((Object)"%m"), cb.literal((Object)field)});
                        break;
                    }
                    default: {
                        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b");
                    }
                }
                fieldExpress.alias(field + "_month");
                selects.add((Selection<?>)fieldExpress);
                groupBys.add(fieldExpress);
                isAdded = true;
            }
            if (Objects.equals(groupByExpress.getDay(), true)) {
                fieldExpress = null;
                switch (databaseProductName.trim().toLowerCase()) {
                    case "mysql": 
                    case "db2": 
                    case "h2": 
                    case "hsql": 
                    case "dm": 
                    case "kingbase_es": 
                    case "gbase": 
                    case "ocean_base": 
                    case "oscar": {
                        fieldExpress = cb.function("day", Integer.class, new Expression[]{cb.literal((Object)field)});
                        break;
                    }
                    case "oracle": 
                    case "gauss": {
                        fieldExpress = cb.function("to_char", Integer.class, new Expression[]{cb.literal((Object)field), cb.literal((Object)"dd")});
                        break;
                    }
                    case "sql_server": {
                        fieldExpress = cb.function("datepart", Integer.class, new Expression[]{cb.literal((Object)"day"), cb.literal((Object)field)});
                        break;
                    }
                    case "postgresql": {
                        fieldExpress = cb.function("date_part", Integer.class, new Expression[]{cb.literal((Object)"day"), cb.literal((Object)field)});
                        break;
                    }
                    case "sqlite": {
                        fieldExpress = cb.function("strftime", Integer.class, new Expression[]{cb.literal((Object)"%d"), cb.literal((Object)field)});
                        break;
                    }
                    default: {
                        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b");
                    }
                }
                fieldExpress.alias(field + "_day");
                selects.add((Selection<?>)fieldExpress);
                groupBys.add(fieldExpress);
                isAdded = true;
            }
            if (Objects.equals(groupByExpress.getHour(), true)) {
                fieldExpress = null;
                switch (databaseProductName.trim().toLowerCase()) {
                    case "mysql": 
                    case "db2": 
                    case "h2": 
                    case "hsql": 
                    case "dm": 
                    case "kingbase_es": 
                    case "gbase": 
                    case "ocean_base": 
                    case "oscar": {
                        fieldExpress = cb.function("hour", Integer.class, new Expression[]{cb.literal((Object)field)});
                        break;
                    }
                    case "oracle": 
                    case "gauss": {
                        fieldExpress = cb.function("to_char", Integer.class, new Expression[]{cb.literal((Object)field), cb.literal((Object)"hh24")});
                        break;
                    }
                    case "sql_server": {
                        fieldExpress = cb.function("datepart", Integer.class, new Expression[]{cb.literal((Object)"hour"), cb.literal((Object)field)});
                        break;
                    }
                    case "postgresql": {
                        fieldExpress = cb.function("date_part", Integer.class, new Expression[]{cb.literal((Object)"hour"), cb.literal((Object)field)});
                        break;
                    }
                    case "sqlite": {
                        fieldExpress = cb.function("strftime", Integer.class, new Expression[]{cb.literal((Object)"%H"), cb.literal((Object)field)});
                        break;
                    }
                    default: {
                        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b");
                    }
                }
                fieldExpress.alias(field + "_hour");
                selects.add((Selection<?>)fieldExpress);
                groupBys.add(fieldExpress);
                isAdded = true;
            }
            if (!isAdded && Objects.equals(groupByExpress.getJoin(), Boolean.TRUE)) {
                groupBys.add((Expression<?>)root.get(field));
            }
        }
    }
}

