/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.service.filter;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import org.springframework.format.annotation.DateTimeFormat;
import tech.jhipster.service.filter.RangeFilter;

public class LocalDateFilter
extends RangeFilter<LocalDate> {
    private static final long serialVersionUID = 1L;

    public LocalDateFilter() {
    }

    public LocalDateFilter(String[] values) {
        Comparable[] dates;
        if (values != null && values.length > 0 && (dates = (LocalDate[])Arrays.stream(values).map(value -> LocalDate.parse(value, DateTimeFormatter.ISO_LOCAL_DATE)).toArray(LocalDate[]::new)).length > 0) {
            this.setBetween(dates);
        }
    }

    public LocalDateFilter(LocalDateFilter filter) {
        super(filter);
    }

    @Override
    public LocalDateFilter copy() {
        return new LocalDateFilter(this);
    }

    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    public LocalDateFilter setEquals(LocalDate equals) {
        super.setEquals(equals);
        return this;
    }

    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    public LocalDateFilter setNotEquals(LocalDate equals) {
        super.setNotEquals(equals);
        return this;
    }

    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    public LocalDateFilter setIn(List<LocalDate> in) {
        super.setIn(in);
        return this;
    }

    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    public LocalDateFilter setNotIn(List<LocalDate> notIn) {
        super.setNotIn(notIn);
        return this;
    }

    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    public LocalDateFilter setGreaterThan(LocalDate equals) {
        super.setGreaterThan(equals);
        return this;
    }

    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    public LocalDateFilter setLessThan(LocalDate equals) {
        super.setLessThan(equals);
        return this;
    }

    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    public LocalDateFilter setGreaterThanOrEqual(LocalDate equals) {
        super.setGreaterThanOrEqual(equals);
        return this;
    }

    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    public LocalDateFilter setLessThanOrEqual(LocalDate equals) {
        super.setLessThanOrEqual(equals);
        return this;
    }
}

