/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.service.mybatis;

import com.baomidou.mybatisplus.annotation.DbType;
import java.util.List;
import java.util.Objects;
import tech.jhipster.service.aggregate.Aggregate;
import tech.jhipster.service.aggregate.DateTimeGroupBy;
import tech.jhipster.service.aggregate.GroupByExpress;
import tech.jhipster.service.aggregate.NumberAggregate;

public class AggregateUtil {
    public static void buildAggregate(Aggregate filter, String field, List<String> selects) {
        if (Objects.equals(filter.getCount(), true)) {
            String onlyFieldName = field.replace("self.", "");
            selects.add("count(" + field + ") as " + onlyFieldName + "_count");
        }
    }

    public static void buildAggregate(NumberAggregate filter, String field, List<String> selects) {
        String onlyFieldName = field.replace("self.", "");
        if (Objects.equals(filter.getSum(), true)) {
            selects.add("sum(" + field + ") as " + onlyFieldName + "_sum");
        }
        if (Objects.equals(filter.getAvg(), true)) {
            selects.add("avg(" + field + ") as " + onlyFieldName + "_avg");
        }
        if (Objects.equals(filter.getMin(), true)) {
            selects.add("min(" + field + ") as " + onlyFieldName + "_min");
        }
        if (Objects.equals(filter.getMax(), true)) {
            selects.add("max(" + field + ") as " + onlyFieldName + "_max");
        }
    }

    public static void buildGroupBy(GroupByExpress groupByExpress, String field, List<String> groupBys, List<String> selects) {
        if (Objects.equals(groupByExpress.getJoin(), true)) {
            groupBys.add(field);
            selects.add(field);
        }
    }

    public static void buildGroupBy(DateTimeGroupBy groupByExpress, String field, List<String> groupBys, List<String> selects) {
        if (Objects.nonNull(groupByExpress)) {
            Object fieldExpress;
            DbType databaseTypeEnum = DbType.MYSQL;
            String onlyFieldName = field.replace("self.", "");
            boolean isAdded = false;
            if (Objects.equals(groupByExpress.getYear(), true)) {
                fieldExpress = "";
                switch (databaseTypeEnum) {
                    case MYSQL: {
                        fieldExpress = "year(" + field + ")";
                        break;
                    }
                    case ORACLE: {
                        fieldExpress = "to_char(" + field + ",'yyyy')";
                        break;
                    }
                    case SQL_SERVER: {
                        fieldExpress = "datepart(year," + field + ")";
                        break;
                    }
                    case DB2: {
                        fieldExpress = "year(" + field + ")";
                        break;
                    }
                    case H2: {
                        fieldExpress = "year(" + field + ")";
                        break;
                    }
                    case POSTGRE_SQL: {
                        fieldExpress = "date_part('year'," + field + ")";
                        break;
                    }
                    case HSQL: {
                        fieldExpress = "year(" + field + ")";
                        break;
                    }
                    case SQLITE: {
                        fieldExpress = "strftime('%Y'," + field + ")";
                        break;
                    }
                    case DM: {
                        fieldExpress = "year(" + field + ")";
                        break;
                    }
                    case KINGBASE_ES: {
                        fieldExpress = "year(" + field + ")";
                        break;
                    }
                    case GAUSS: {
                        fieldExpress = "to_char(" + field + ",'yyyy')";
                        break;
                    }
                    case GBASE: {
                        fieldExpress = "year(" + field + ")";
                        break;
                    }
                    case OCEAN_BASE: {
                        fieldExpress = "year(" + field + ")";
                        break;
                    }
                    case OSCAR: {
                        fieldExpress = "year(" + field + ")";
                        break;
                    }
                    default: {
                        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b");
                    }
                }
                selects.add((String)fieldExpress + " as " + onlyFieldName + "_year");
                groupBys.add(onlyFieldName + "_year");
                isAdded = true;
            }
            if (Objects.equals(groupByExpress.getMonth(), true)) {
                fieldExpress = "";
                switch (databaseTypeEnum) {
                    case MYSQL: {
                        fieldExpress = "month(" + field + ")";
                        break;
                    }
                    case ORACLE: {
                        fieldExpress = "to_char(" + field + ",'mm')";
                        break;
                    }
                    case SQL_SERVER: {
                        fieldExpress = "datepart(month," + field + ")";
                        break;
                    }
                    case DB2: {
                        fieldExpress = "month(" + field + ")";
                        break;
                    }
                    case H2: {
                        fieldExpress = "month(" + field + ")";
                        break;
                    }
                    case POSTGRE_SQL: {
                        fieldExpress = "date_part('month'," + field + ")";
                        break;
                    }
                    case HSQL: {
                        fieldExpress = "month(" + field + ")";
                        break;
                    }
                    case SQLITE: {
                        fieldExpress = "strftime('%m'," + field + ")";
                        break;
                    }
                    case DM: {
                        fieldExpress = "month(" + field + ")";
                        break;
                    }
                    case KINGBASE_ES: {
                        fieldExpress = "month(" + field + ")";
                        break;
                    }
                    case GAUSS: {
                        fieldExpress = "to_char(" + field + ",'mm')";
                        break;
                    }
                    case GBASE: {
                        fieldExpress = "month(" + field + ")";
                        break;
                    }
                    case OCEAN_BASE: {
                        fieldExpress = "month(" + field + ")";
                        break;
                    }
                    case OSCAR: {
                        fieldExpress = "month(" + field + ")";
                        break;
                    }
                    default: {
                        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b");
                    }
                }
                selects.add((String)fieldExpress + " as " + onlyFieldName + "_month");
                groupBys.add(onlyFieldName + "_month");
                isAdded = true;
            }
            if (Objects.equals(groupByExpress.getDay(), true)) {
                fieldExpress = "";
                switch (databaseTypeEnum) {
                    case MYSQL: {
                        fieldExpress = "day(" + field + ")";
                        break;
                    }
                    case ORACLE: {
                        fieldExpress = "to_char(" + field + ",'dd')";
                        break;
                    }
                    case SQL_SERVER: {
                        fieldExpress = "datepart(day," + field + ")";
                        break;
                    }
                    case DB2: {
                        fieldExpress = "day(" + field + ")";
                        break;
                    }
                    case H2: {
                        fieldExpress = "day(" + field + ")";
                        break;
                    }
                    case POSTGRE_SQL: {
                        fieldExpress = "date_part('day'," + field + ")";
                        break;
                    }
                    case HSQL: {
                        fieldExpress = "day(" + field + ")";
                        break;
                    }
                    case SQLITE: {
                        fieldExpress = "strftime('%d'," + field + ")";
                        break;
                    }
                    case DM: {
                        fieldExpress = "day(" + field + ")";
                        break;
                    }
                    case KINGBASE_ES: {
                        fieldExpress = "day(" + field + ")";
                        break;
                    }
                    case GAUSS: {
                        fieldExpress = "to_char(" + field + ",'dd')";
                        break;
                    }
                    case GBASE: {
                        fieldExpress = "day(" + field + ")";
                        break;
                    }
                    case OCEAN_BASE: {
                        fieldExpress = "day(" + field + ")";
                        break;
                    }
                    case OSCAR: {
                        fieldExpress = "day(" + field + ")";
                        break;
                    }
                    default: {
                        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b");
                    }
                }
                selects.add((String)fieldExpress + " as " + onlyFieldName + "_day");
                groupBys.add(onlyFieldName + "_day");
                isAdded = true;
            }
            if (Objects.equals(groupByExpress.getHour(), true)) {
                Object hourFieldExpress = "";
                switch (databaseTypeEnum) {
                    case MYSQL: {
                        hourFieldExpress = "hour(" + field + ")";
                        break;
                    }
                    case ORACLE: {
                        hourFieldExpress = "to_char(" + field + ",'hh24')";
                        break;
                    }
                    case SQL_SERVER: {
                        hourFieldExpress = "datepart(hour," + field + ")";
                        break;
                    }
                    case DB2: {
                        hourFieldExpress = "hour(" + field + ")";
                        break;
                    }
                    case H2: {
                        hourFieldExpress = "hour(" + field + ")";
                        break;
                    }
                    case POSTGRE_SQL: {
                        hourFieldExpress = "date_part('hour'," + field + ")";
                        break;
                    }
                    case HSQL: {
                        hourFieldExpress = "hour(" + field + ")";
                        break;
                    }
                    case SQLITE: {
                        hourFieldExpress = "strftime('%H'," + field + ")";
                        break;
                    }
                    case DM: {
                        hourFieldExpress = "hour(" + field + ")";
                        break;
                    }
                    case KINGBASE_ES: {
                        hourFieldExpress = "hour(" + field + ")";
                        break;
                    }
                    case GAUSS: {
                        hourFieldExpress = "to_char(" + field + ",'hh24')";
                        break;
                    }
                    case GBASE: {
                        hourFieldExpress = "hour(" + field + ")";
                        break;
                    }
                    case OCEAN_BASE: {
                        hourFieldExpress = "hour(" + field + ")";
                        break;
                    }
                    case OSCAR: {
                        hourFieldExpress = "hour(" + field + ")";
                        break;
                    }
                    default: {
                        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b");
                    }
                }
                selects.add((String)hourFieldExpress + " as " + onlyFieldName + "_hour");
                groupBys.add(onlyFieldName + "_hour");
                isAdded = true;
            }
            if (!isAdded && Objects.equals(groupByExpress.getJoin(), Boolean.TRUE)) {
                groupBys.add(onlyFieldName);
            }
        }
    }
}

