/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.service.mybatis;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.diboot.core.binding.QueryBuilder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import tech.jhipster.service.Criteria;
import tech.jhipster.service.aggregate.DateTimeGroupBy;
import tech.jhipster.service.aggregate.NumberAggregate;
import tech.jhipster.service.filter.Filter;
import tech.jhipster.service.filter.RangeFilter;
import tech.jhipster.service.filter.StringFilter;
import tech.jhipster.service.mybatis.AggregateUtil;
import tech.jhipster.service.mybatis.CriteriaUtil;

public interface QueryService<ENTITY> {
    default public <X> Consumer<QueryWrapper<ENTITY>> buildSpecification(Filter<X> filter, String field) {
        return this.buildSpecification(filter, field, (Boolean)false);
    }

    default public <X> Consumer<QueryWrapper<ENTITY>> buildSpecification(Filter<X> filter, String field, Boolean useOr) {
        return queryWrapper -> {
            boolean noFilter = true;
            if (filter.getEquals() != null) {
                if (useOr.booleanValue()) {
                    queryWrapper.or(q -> q.eq((Object)field, filter.getEquals()));
                } else {
                    queryWrapper.eq((Object)field, filter.getEquals());
                }
                noFilter = false;
            }
            if (filter.getIn() != null && !filter.getIn().isEmpty()) {
                if (useOr.booleanValue()) {
                    queryWrapper.or(q -> q.in((Object)field, filter.getIn()));
                } else {
                    queryWrapper.in((Object)field, filter.getIn());
                }
                noFilter = false;
            }
            if (filter.getNotIn() != null && !filter.getNotIn().isEmpty()) {
                if (useOr.booleanValue()) {
                    queryWrapper.or(q -> q.notIn((Object)field, filter.getNotIn()));
                } else {
                    queryWrapper.notIn((Object)field, filter.getNotIn());
                }
                noFilter = false;
            }
            if (filter.getNotEquals() != null) {
                if (useOr.booleanValue()) {
                    queryWrapper.or(q -> q.ne((Object)field, filter.getNotEquals()));
                } else {
                    queryWrapper.ne((Object)field, filter.getNotEquals());
                }
                noFilter = false;
            }
            if (filter.getSpecified() != null) {
                if (filter.getSpecified().booleanValue()) {
                    if (useOr.booleanValue()) {
                        queryWrapper.or(q -> q.isNotNull((Object)field));
                    } else {
                        queryWrapper.isNotNull((Object)field);
                    }
                } else if (useOr.booleanValue()) {
                    queryWrapper.or(q -> q.isNull((Object)field));
                } else {
                    queryWrapper.isNull((Object)field);
                }
                noFilter = false;
            }
            if (noFilter) {
                if (useOr.booleanValue()) {
                    queryWrapper.or(q -> q.eq((Object)"1", (Object)1));
                } else {
                    queryWrapper.eq((Object)"1", (Object)1);
                }
            }
        };
    }

    default public Consumer<QueryWrapper<ENTITY>> buildStringSpecification(StringFilter filter, String field) {
        return this.buildSpecification(filter, field, (Boolean)false);
    }

    default public Consumer<QueryWrapper<ENTITY>> buildStringSpecification(StringFilter filter, String field, Boolean useOr) {
        return this.buildSpecification(filter, field, useOr);
    }

    default public Consumer<QueryWrapper<ENTITY>> buildSpecification(StringFilter filter, String field, Boolean useOr) {
        return queryWrapper -> {
            boolean noFilter = true;
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)filter.getEquals()))) {
                if (useOr.booleanValue()) {
                    queryWrapper.or(q -> q.eq((Object)field, filter.getEquals()));
                } else {
                    queryWrapper.eq((Object)field, filter.getEquals());
                }
                noFilter = false;
            }
            if (filter.getIn() != null && !filter.getIn().isEmpty()) {
                if (useOr.booleanValue()) {
                    queryWrapper.or(q -> q.in((Object)field, filter.getIn()));
                } else {
                    queryWrapper.in((Object)field, filter.getIn());
                }
                noFilter = false;
            }
            if (filter.getNotIn() != null && !filter.getNotIn().isEmpty()) {
                if (useOr.booleanValue()) {
                    queryWrapper.or(q -> q.notIn((Object)field, filter.getNotIn()));
                } else {
                    queryWrapper.notIn((Object)field, filter.getNotIn());
                }
                noFilter = false;
            }
            if (StringUtils.isNotBlank((CharSequence)filter.getContains())) {
                if (useOr.booleanValue()) {
                    queryWrapper.or(q -> q.like((Object)field, (Object)filter.getContains()));
                } else {
                    queryWrapper.like((Object)field, (Object)filter.getContains());
                }
                noFilter = false;
            }
            if (StringUtils.isNotBlank((CharSequence)filter.getContainsLeft())) {
                if (useOr.booleanValue()) {
                    queryWrapper.or(q -> q.likeLeft((Object)field, (Object)filter.getContainsLeft()));
                } else {
                    queryWrapper.likeLeft((Object)field, (Object)filter.getContainsLeft());
                }
                noFilter = false;
            }
            if (StringUtils.isNotBlank((CharSequence)filter.getContainsRight())) {
                if (useOr.booleanValue()) {
                    queryWrapper.or(q -> q.likeRight((Object)field, (Object)filter.getContainsRight()));
                } else {
                    queryWrapper.likeRight((Object)field, (Object)filter.getContainsRight());
                }
                noFilter = false;
            }
            if (StringUtils.isNotBlank((CharSequence)filter.getDoesNotContain())) {
                if (useOr.booleanValue()) {
                    queryWrapper.or(q -> q.notLike((Object)field, (Object)filter.getDoesNotContain()));
                } else {
                    queryWrapper.notLike((Object)field, (Object)filter.getDoesNotContain());
                }
                noFilter = false;
            }
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)filter.getNotEquals()))) {
                if (useOr.booleanValue()) {
                    queryWrapper.or(q -> q.ne((Object)field, filter.getNotEquals()));
                } else {
                    queryWrapper.ne((Object)field, filter.getNotEquals());
                }
                noFilter = false;
            }
            if (filter.getSpecified() != null) {
                if (filter.getSpecified().booleanValue()) {
                    if (useOr.booleanValue()) {
                        queryWrapper.or(q -> q.isNotNull((Object)field));
                    } else {
                        queryWrapper.isNotNull((Object)field);
                    }
                } else if (useOr.booleanValue()) {
                    queryWrapper.or(q -> q.isNull((Object)field));
                } else {
                    queryWrapper.isNull((Object)field);
                }
                noFilter = false;
            }
            if (noFilter) {
                queryWrapper.eq((Object)"1", (Object)1);
            }
        };
    }

    default public <X extends Comparable<? super X>> Consumer<QueryWrapper<ENTITY>> buildRangeSpecification(RangeFilter<X> filter, String field) {
        return this.buildSpecification(filter, field, (Boolean)false);
    }

    default public <X extends Comparable<? super X>> Consumer<QueryWrapper<ENTITY>> buildRangeSpecification(RangeFilter<X> filter, String field, Boolean useOr) {
        return this.buildSpecification(filter, field, useOr);
    }

    default public <X extends Comparable<? super X>> Consumer<QueryWrapper<ENTITY>> buildSpecification(RangeFilter<X> filter, String field, Boolean useOr) {
        return queryWrapper -> {
            boolean noFilter = true;
            if (filter.getEquals() != null) {
                if (useOr.booleanValue()) {
                    queryWrapper.or(q -> q.eq((Object)field, filter.getEquals()));
                } else {
                    queryWrapper.eq((Object)field, filter.getEquals());
                }
                noFilter = false;
            }
            if (filter.getIn() != null && !filter.getIn().isEmpty()) {
                if (useOr.booleanValue()) {
                    queryWrapper.or(q -> q.in((Object)field, filter.getIn()));
                } else {
                    queryWrapper.in((Object)field, filter.getIn());
                }
                noFilter = false;
            }
            if (filter.getNotIn() != null && !filter.getNotIn().isEmpty()) {
                if (useOr.booleanValue()) {
                    queryWrapper.or(q -> q.notIn((Object)field, filter.getNotIn()));
                } else {
                    queryWrapper.notIn((Object)field, filter.getNotIn());
                }
                noFilter = false;
            }
            if (filter.getSpecified() != null) {
                if (filter.getSpecified().booleanValue()) {
                    if (useOr.booleanValue()) {
                        queryWrapper.or(q -> q.isNotNull((Object)field));
                    } else {
                        queryWrapper.isNotNull((Object)field);
                    }
                } else if (useOr.booleanValue()) {
                    queryWrapper.or(q -> q.isNull((Object)field));
                } else {
                    queryWrapper.isNull((Object)field);
                }
                noFilter = false;
            }
            if (filter.getNotEquals() != null) {
                if (useOr.booleanValue()) {
                    queryWrapper.or(q -> q.ne((Object)field, filter.getNotEquals()));
                } else {
                    queryWrapper.ne((Object)field, filter.getNotEquals());
                }
                noFilter = false;
            }
            if (filter.getGreaterThan() != null) {
                if (useOr.booleanValue()) {
                    queryWrapper.or(q -> q.gt((Object)field, filter.getGreaterThan()));
                } else {
                    queryWrapper.gt((Object)field, filter.getGreaterThan());
                }
                noFilter = false;
            }
            if (filter.getGreaterThanOrEqual() != null) {
                if (useOr.booleanValue()) {
                    queryWrapper.or(q -> q.ge((Object)field, filter.getGreaterThanOrEqual()));
                } else {
                    queryWrapper.ge((Object)field, filter.getGreaterThanOrEqual());
                }
                noFilter = false;
            }
            if (filter.getLessThan() != null) {
                if (useOr.booleanValue()) {
                    queryWrapper.or(q -> q.lt((Object)field, filter.getLessThan()));
                } else {
                    queryWrapper.lt((Object)field, filter.getLessThan());
                }
                noFilter = false;
            }
            if (filter.getLessThanOrEqual() != null) {
                if (useOr.booleanValue()) {
                    queryWrapper.or(q -> q.le((Object)field, filter.getLessThanOrEqual()));
                } else {
                    queryWrapper.le((Object)field, filter.getLessThanOrEqual());
                }
                noFilter = false;
            }
            if (filter.getBetween() != null) {
                if (useOr.booleanValue()) {
                    if (filter.getBetween().length >= 2) {
                        if (Objects.nonNull(filter.getBetween()[0]) && Objects.nonNull(filter.getBetween()[1])) {
                            queryWrapper.or(q -> q.between((Object)field, (Object)filter.getBetween()[0], (Object)filter.getBetween()[1]));
                        } else if (Objects.nonNull(filter.getBetween()[0])) {
                            queryWrapper.or(q -> q.ge((Object)field, (Object)filter.getBetween()[0]));
                        } else {
                            queryWrapper.or(q -> q.le((Object)field, (Object)filter.getBetween()[1]));
                        }
                    } else if (filter.getBetween().length == 1) {
                        queryWrapper.ge((Object)field, (Object)filter.getBetween()[0]);
                    }
                } else if (filter.getBetween().length >= 2) {
                    if (Objects.nonNull(filter.getBetween()[0]) && Objects.nonNull(filter.getBetween()[1])) {
                        queryWrapper.between((Object)field, (Object)filter.getBetween()[0], (Object)filter.getBetween()[1]);
                    } else if (Objects.nonNull(filter.getBetween()[0])) {
                        queryWrapper.ge((Object)field, (Object)filter.getBetween()[0]);
                    } else {
                        queryWrapper.le((Object)field, (Object)filter.getBetween()[1]);
                    }
                } else if (filter.getBetween().length == 1) {
                    queryWrapper.ge((Object)field, (Object)filter.getBetween()[0]);
                }
                noFilter = false;
            }
            if (noFilter) {
                queryWrapper.eq((Object)"1", (Object)1);
            }
        };
    }

    default public <C extends Criteria> QueryWrapper<ENTITY> createQueryWrapper(QueryWrapper<ENTITY> queryWrapper, Boolean useOr, C criteria, Class<ENTITY> entityClass) {
        if (criteria != null) {
            Map stringObjectMap;
            Map queryWrapperMapMap;
            Map.Entry queryWrapperMapEntry;
            Map fieldMap;
            if (useOr == null) {
                useOr = false;
            }
            if (MapUtils.isNotEmpty((Map)(fieldMap = (Map)(queryWrapperMapEntry = (Map.Entry)(queryWrapperMapMap = QueryBuilder.criteriaToWrapper(criteria, entityClass)).entrySet().stream().findFirst().orElseThrow()).getValue()))) {
                if (queryWrapper == null) {
                    queryWrapper = (QueryWrapper<ENTITY>)queryWrapperMapEntry.getKey();
                }
                QueryWrapper<ENTITY> finalQueryWrapper = queryWrapper;
                Boolean finalUseOr = useOr;
                fieldMap.forEach((arg_0, arg_1) -> this.lambda$createQueryWrapper$33(finalUseOr, (QueryWrapper)finalQueryWrapper, arg_0, arg_1));
            }
            if (criteria.getAnd() != null) {
                stringObjectMap = BeanUtil.beanToMap((Object)criteria.getAnd(), (boolean)false, (boolean)true);
                if (!(stringObjectMap.containsKey("useOr") && stringObjectMap.keySet().size() == 1 || ObjectUtils.isEmpty((Object)stringObjectMap))) {
                    if (queryWrapper != null) {
                        queryWrapper.and(q -> this.createQueryWrapper((QueryWrapper<ENTITY>)q, criteria.getAnd().getUseOr(), (Criteria)criteria.getAnd(), entityClass));
                    } else {
                        queryWrapper = this.createQueryWrapper(null, criteria.getAnd().getUseOr(), criteria.getAnd(), entityClass);
                    }
                }
            } else if (!(criteria.getOr() == null || (stringObjectMap = BeanUtil.beanToMap((Object)criteria.getOr(), (boolean)false, (boolean)true)).containsKey("useOr") && stringObjectMap.keySet().size() == 1 || ObjectUtils.isEmpty((Object)stringObjectMap))) {
                if (queryWrapper != null) {
                    queryWrapper.or(q -> this.createQueryWrapper((QueryWrapper<ENTITY>)q, criteria.getOr().getUseOr(), (Criteria)criteria.getOr(), entityClass));
                } else {
                    queryWrapper = this.createQueryWrapper(null, criteria.getOr().getUseOr(), criteria.getOr(), entityClass);
                }
            }
        }
        return queryWrapper;
    }

    default public <C extends Criteria> QueryWrapper<ENTITY> createQueryWrapperNoJoin(QueryWrapper<ENTITY> queryWrapper, Boolean useOr, C criteria, Class<ENTITY> entityClass) {
        if (criteria != null) {
            Map stringObjectMap;
            Map queryWrapperMapMap;
            Map.Entry queryWrapperMapEntry;
            Map fieldMap;
            if (useOr == null) {
                useOr = false;
            }
            if (MapUtils.isNotEmpty((Map)(fieldMap = (Map)(queryWrapperMapEntry = (Map.Entry)(queryWrapperMapMap = QueryBuilder.criteriaToWrapperNoJoin(criteria, entityClass)).entrySet().stream().findFirst().orElseThrow()).getValue()))) {
                if (queryWrapper == null) {
                    queryWrapper = (QueryWrapper<ENTITY>)queryWrapperMapEntry.getKey();
                }
                QueryWrapper<ENTITY> finalQueryWrapper = queryWrapper;
                Boolean finalUseOr = useOr;
                fieldMap.forEach((arg_0, arg_1) -> this.lambda$createQueryWrapperNoJoin$36(finalUseOr, (QueryWrapper)finalQueryWrapper, arg_0, arg_1));
            }
            if (criteria.getAnd() != null) {
                stringObjectMap = BeanUtil.beanToMap((Object)criteria.getAnd(), (boolean)false, (boolean)true);
                if (!(stringObjectMap.containsKey("useOr") && stringObjectMap.keySet().size() == 1 || ObjectUtils.isEmpty((Object)stringObjectMap))) {
                    if (queryWrapper != null) {
                        queryWrapper.and(q -> this.createQueryWrapperNoJoin((QueryWrapper<ENTITY>)q, criteria.getAnd().getUseOr(), (Criteria)criteria.getAnd(), entityClass));
                    } else {
                        queryWrapper = this.createQueryWrapperNoJoin(null, criteria.getAnd().getUseOr(), criteria.getAnd(), entityClass);
                    }
                }
            } else if (!(criteria.getOr() == null || (stringObjectMap = BeanUtil.beanToMap((Object)criteria.getOr(), (boolean)false, (boolean)true)).containsKey("useOr") && stringObjectMap.keySet().size() == 1 || ObjectUtils.isEmpty((Object)stringObjectMap))) {
                if (queryWrapper != null) {
                    queryWrapper.or(q -> this.createQueryWrapperNoJoin((QueryWrapper<ENTITY>)q, criteria.getOr().getUseOr(), (Criteria)criteria.getOr(), entityClass));
                } else {
                    queryWrapper = this.createQueryWrapperNoJoin(null, criteria.getOr().getUseOr(), criteria.getOr(), entityClass);
                }
            }
        }
        return queryWrapper;
    }

    default public void getAggregateAndGroupBy(Filter<?> filter, String fieldName, List<String> selects, List<String> groupBys) {
        if (filter.getAggregate() != null) {
            if (filter.getAggregate() instanceof NumberAggregate) {
                AggregateUtil.buildAggregate((NumberAggregate)filter.getAggregate(), fieldName, selects);
            } else {
                AggregateUtil.buildAggregate(filter.getAggregate(), fieldName, selects);
            }
        }
        if (filter.getGroupBy() != null) {
            if (filter.getGroupBy() instanceof DateTimeGroupBy) {
                AggregateUtil.buildGroupBy((DateTimeGroupBy)filter.getGroupBy(), fieldName, groupBys, selects);
            } else {
                AggregateUtil.buildGroupBy(filter.getGroupBy(), fieldName, groupBys, selects);
            }
        }
    }

    private /* synthetic */ void lambda$createQueryWrapperNoJoin$36(Boolean finalUseOr, QueryWrapper finalQueryWrapper, String fieldName, Object filter) {
        if (filter instanceof StringFilter) {
            CriteriaUtil.build(finalUseOr, finalQueryWrapper, this.buildStringSpecification((StringFilter)filter, fieldName, finalUseOr));
        } else if (filter instanceof RangeFilter) {
            CriteriaUtil.build(finalUseOr, finalQueryWrapper, this.buildRangeSpecification((RangeFilter)filter, fieldName, finalUseOr));
        } else if (filter instanceof Filter) {
            CriteriaUtil.build(finalUseOr, finalQueryWrapper, this.buildSpecification((Filter)filter, fieldName, finalUseOr));
        }
    }

    private /* synthetic */ void lambda$createQueryWrapper$33(Boolean finalUseOr, QueryWrapper finalQueryWrapper, String fieldName, Object filter) {
        if (filter instanceof StringFilter) {
            CriteriaUtil.build(finalUseOr, finalQueryWrapper, this.buildStringSpecification((StringFilter)filter, fieldName, finalUseOr));
        } else if (filter instanceof RangeFilter) {
            CriteriaUtil.build(finalUseOr, finalQueryWrapper, this.buildRangeSpecification((RangeFilter)filter, fieldName, finalUseOr));
        } else if (filter instanceof Filter) {
            CriteriaUtil.build(finalUseOr, finalQueryWrapper, this.buildSpecification((Filter)filter, fieldName, finalUseOr));
        }
    }
}

