/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.impl;

import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.api.BrowseFacet;
import com.browseengine.bobo.api.BrowseSelection;
import com.browseengine.bobo.api.FacetIterator;
import com.browseengine.bobo.api.FacetSpec;
import com.browseengine.bobo.facets.FacetCountCollector;
import com.browseengine.bobo.facets.FacetCountCollectorSource;
import com.browseengine.bobo.facets.FacetHandler;
import com.browseengine.bobo.facets.data.FacetDataCache;
import com.browseengine.bobo.facets.data.TermListFactory;
import com.browseengine.bobo.facets.data.TermStringList;
import com.browseengine.bobo.facets.data.TermValueList;
import com.browseengine.bobo.facets.filter.CompactMultiValueFacetFilter;
import com.browseengine.bobo.facets.filter.EmptyFilter;
import com.browseengine.bobo.facets.filter.RandomAccessAndFilter;
import com.browseengine.bobo.facets.filter.RandomAccessFilter;
import com.browseengine.bobo.facets.filter.RandomAccessNotFilter;
import com.browseengine.bobo.facets.impl.DefaultFacetCountCollector;
import com.browseengine.bobo.query.scoring.BoboDocScorer;
import com.browseengine.bobo.query.scoring.FacetScoreable;
import com.browseengine.bobo.query.scoring.FacetTermScoringFunctionFactory;
import com.browseengine.bobo.sort.DocComparator;
import com.browseengine.bobo.sort.DocComparatorSource;
import com.browseengine.bobo.util.BigIntArray;
import com.browseengine.bobo.util.BigSegmentedArray;
import com.browseengine.bobo.util.StringArrayComparator;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.ScoreDoc;

public class CompactMultiValueFacetHandler
extends FacetHandler<FacetDataCache>
implements FacetScoreable {
    private static Logger logger = Logger.getLogger(CompactMultiValueFacetHandler.class);
    private static final int MAX_VAL_COUNT = 32;
    private final TermListFactory _termListFactory;
    private final String _indexFieldName;

    public CompactMultiValueFacetHandler(String name, String indexFieldName, TermListFactory termListFactory) {
        super(name);
        this._indexFieldName = indexFieldName;
        this._termListFactory = termListFactory;
    }

    public CompactMultiValueFacetHandler(String name, TermListFactory termListFactory) {
        this(name, name, termListFactory);
    }

    public CompactMultiValueFacetHandler(String name, String indexFieldName) {
        this(name, indexFieldName, null);
    }

    public CompactMultiValueFacetHandler(String name) {
        this(name, name, null);
    }

    @Override
    public DocComparatorSource getDocComparatorSource() {
        return new CompactMultiFacetDocComparatorSource(this);
    }

    @Override
    public RandomAccessFilter buildRandomAccessFilter(String value, Properties prop) throws IOException {
        return new CompactMultiValueFacetFilter((FacetHandler<FacetDataCache>)this, value);
    }

    @Override
    public RandomAccessFilter buildRandomAccessAndFilter(String[] vals, Properties prop) throws IOException {
        ArrayList<RandomAccessFilter> filterList = new ArrayList<RandomAccessFilter>(vals.length);
        for (String val : vals) {
            RandomAccessFilter f = this.buildRandomAccessFilter(val, prop);
            if (f == null) {
                return EmptyFilter.getInstance();
            }
            filterList.add(f);
        }
        if (filterList.size() == 1) {
            return (RandomAccessFilter)((Object)filterList.get(0));
        }
        return new RandomAccessAndFilter(filterList);
    }

    @Override
    public RandomAccessFilter buildRandomAccessOrFilter(String[] vals, Properties prop, boolean isNot) throws IOException {
        RandomAccessFilter filter = null;
        filter = vals.length > 0 ? new CompactMultiValueFacetFilter((FacetHandler<FacetDataCache>)this, vals) : EmptyFilter.getInstance();
        if (isNot) {
            filter = new RandomAccessNotFilter(filter);
        }
        return filter;
    }

    private static int countBits(int val) {
        int c = 0;
        c = 0;
        while (val > 0) {
            val &= val - 1;
            ++c;
        }
        return c;
    }

    @Override
    public int getNumItems(BoboIndexReader reader, int id) {
        FacetDataCache dataCache = (FacetDataCache)this.getFacetData(reader);
        if (dataCache == null) {
            return 0;
        }
        int encoded = dataCache.orderArray.get(id);
        return CompactMultiValueFacetHandler.countBits(encoded);
    }

    @Override
    public String[] getFieldValues(BoboIndexReader reader, int id) {
        FacetDataCache dataCache = (FacetDataCache)this.getFacetData(reader);
        if (dataCache == null) {
            return new String[0];
        }
        int encoded = dataCache.orderArray.get(id);
        if (encoded == 0) {
            return new String[]{""};
        }
        int count = 1;
        ArrayList<String> valList = new ArrayList<String>(32);
        while (encoded != 0) {
            if ((encoded & 1) != 0) {
                valList.add(dataCache.valArray.get(count));
            }
            ++count;
            encoded >>>= 1;
        }
        return valList.toArray(new String[valList.size()]);
    }

    @Override
    public Object[] getRawFieldValues(BoboIndexReader reader, int id) {
        FacetDataCache dataCache = (FacetDataCache)this.getFacetData(reader);
        if (dataCache == null) {
            return new String[0];
        }
        int encoded = dataCache.orderArray.get(id);
        if (encoded == 0) {
            return new Object[0];
        }
        int count = 1;
        ArrayList valList = new ArrayList(32);
        while (encoded != 0) {
            if ((encoded & 1) != 0) {
                valList.add(dataCache.valArray.getRawValue(count));
            }
            ++count;
            encoded >>>= 1;
        }
        return valList.toArray(new Object[valList.size()]);
    }

    @Override
    public FacetCountCollectorSource getFacetCountCollectorSource(final BrowseSelection sel, final FacetSpec ospec) {
        return new FacetCountCollectorSource(){

            @Override
            public FacetCountCollector getFacetCountCollector(BoboIndexReader reader, int docBase) {
                FacetDataCache dataCache = (FacetDataCache)CompactMultiValueFacetHandler.this.getFacetData(reader);
                return new CompactMultiValueFacetCountCollector(CompactMultiValueFacetHandler.this._name, sel, dataCache, docBase, ospec);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FacetDataCache load(BoboIndexReader reader) throws IOException {
        int maxDoc = reader.maxDoc();
        BigIntArray order = new BigIntArray(maxDoc);
        TermValueList mterms = this._termListFactory == null ? new TermStringList() : this._termListFactory.createTermList();
        IntArrayList minIDList = new IntArrayList();
        IntArrayList maxIDList = new IntArrayList();
        IntArrayList freqList = new IntArrayList();
        TermDocs termDocs = null;
        TermEnum termEnum = null;
        int t = 0;
        mterms.add(null);
        minIDList.add(-1);
        maxIDList.add(-1);
        freqList.add(0);
        ++t;
        try {
            termDocs = reader.termDocs();
            termEnum = reader.terms(new Term(this._indexFieldName, ""));
            do {
                if (termEnum == null) {
                    break;
                }
                Term term = termEnum.term();
                if (term == null) break;
                if (!this._indexFieldName.equals(term.field())) {
                    break;
                }
                if (t > 32) {
                    throw new IOException("maximum number of value cannot exceed: 32");
                }
                String val = term.text();
                mterms.add(val);
                int bit = 1 << t - 1;
                termDocs.seek(termEnum);
                int df = 0;
                int minID = -1;
                int maxID = -1;
                if (termDocs.next()) {
                    ++df;
                    int docid = termDocs.doc();
                    order.add(docid, order.get(docid) | bit);
                    minID = docid;
                    while (termDocs.next()) {
                        ++df;
                        docid = termDocs.doc();
                        order.add(docid, order.get(docid) | bit);
                    }
                    maxID = docid;
                }
                freqList.add(df);
                minIDList.add(minID);
                maxIDList.add(maxID);
                ++t;
            } while (termEnum.next());
        }
        finally {
            try {
                if (termDocs != null) {
                    termDocs.close();
                }
            }
            finally {
                if (termEnum != null) {
                    termEnum.close();
                }
            }
        }
        mterms.seal();
        return new FacetDataCache(order, mterms, freqList.toIntArray(), minIDList.toIntArray(), maxIDList.toIntArray(), FacetHandler.TermCountSize.large);
    }

    @Override
    public BoboDocScorer getDocScorer(BoboIndexReader reader, FacetTermScoringFunctionFactory scoringFunctionFactory, Map<String, Float> boostMap) {
        FacetDataCache dataCache = (FacetDataCache)this.getFacetData(reader);
        float[] boostList = BoboDocScorer.buildBoostList(dataCache.valArray, boostMap);
        return new CompactMultiValueDocScorer(dataCache, scoringFunctionFactory, boostList);
    }

    private static final class CompactMultiValueFacetCountCollector
    extends DefaultFacetCountCollector {
        private final BigSegmentedArray _array;
        private final int[] _combinationCount = new int[128];
        private int _noValCount = 0;
        private boolean _aggregated = false;

        CompactMultiValueFacetCountCollector(String name, BrowseSelection sel, FacetDataCache dataCache, int docBase, FacetSpec ospec) {
            super(name, dataCache, docBase, sel, ospec);
            this._array = this._dataCache.orderArray;
        }

        @Override
        public final void collectAll() {
            this._count = BigIntArray.fromArray(this._dataCache.freqs);
            this._aggregated = true;
        }

        @Override
        public final void collect(int docid) {
            int encoded = this._array.get(docid);
            if (encoded == 0) {
                ++this._noValCount;
            } else {
                int offset = 0;
                while (true) {
                    int n = (encoded & 0xF) + offset;
                    this._combinationCount[n] = this._combinationCount[n] + 1;
                    if ((encoded >>>= 4) == 0) break;
                    offset += 16;
                }
            }
        }

        @Override
        public BrowseFacet getFacet(String value) {
            if (!this._aggregated) {
                this.aggregateCounts();
            }
            return super.getFacet(value);
        }

        @Override
        public int getFacetHitsCount(Object value) {
            if (!this._aggregated) {
                this.aggregateCounts();
            }
            return super.getFacetHitsCount(value);
        }

        @Override
        public BigSegmentedArray getCountDistribution() {
            if (!this._aggregated) {
                this.aggregateCounts();
            }
            return this._count;
        }

        @Override
        public List<BrowseFacet> getFacets() {
            if (!this._aggregated) {
                this.aggregateCounts();
            }
            return super.getFacets();
        }

        private void aggregateCounts() {
            this._count.add(0, this._noValCount);
            for (int i = 1; i < this._combinationCount.length; ++i) {
                int count = this._combinationCount[i];
                if (count <= 0) continue;
                int offset = (i >> 4) * 4;
                int index = 1;
                for (int encoded = i & 0xF; encoded != 0; encoded >>>= 1) {
                    if ((encoded & 1) != 0) {
                        int idx = index + offset;
                        this._count.add(idx, this._count.get(idx) + count);
                    }
                    ++index;
                }
            }
            this._aggregated = true;
        }

        @Override
        public FacetIterator iterator() {
            if (!this._aggregated) {
                this.aggregateCounts();
            }
            return super.iterator();
        }
    }

    private static final class CompactMultiValueDocScorer
    extends BoboDocScorer {
        private final FacetDataCache _dataCache;

        CompactMultiValueDocScorer(FacetDataCache dataCache, FacetTermScoringFunctionFactory scoreFunctionFactory, float[] boostList) {
            super(scoreFunctionFactory.getFacetTermScoringFunction(dataCache.valArray.size(), dataCache.orderArray.size()), boostList);
            this._dataCache = dataCache;
        }

        @Override
        public Explanation explain(int doc) {
            int count = 1;
            FloatArrayList scoreList = new FloatArrayList(this._dataCache.valArray.size());
            ArrayList<Explanation> explList = new ArrayList<Explanation>(scoreList.size());
            for (int encoded = this._dataCache.orderArray.get(doc); encoded != 0; encoded >>>= 1) {
                if ((encoded & 1) != 0) {
                    int idx = count - 1;
                    scoreList.add(this._function.score(this._dataCache.freqs[idx], this._boostList[idx]));
                    explList.add(this._function.explain(this._dataCache.freqs[idx], this._boostList[idx]));
                }
                ++count;
            }
            Explanation topLevel = this._function.explain(scoreList.toFloatArray());
            for (Explanation sub : explList) {
                topLevel.addDetail(sub);
            }
            return topLevel;
        }

        @Override
        public final float score(int docid) {
            this._function.clearScores();
            int count = 1;
            for (int encoded = this._dataCache.orderArray.get(docid); encoded != 0; encoded >>>= 1) {
                int idx = count - 1;
                if ((encoded & 1) != 0) {
                    this._function.scoreAndCollect(this._dataCache.freqs[idx], this._boostList[idx]);
                }
                ++count;
            }
            return this._function.getCurrentScore();
        }
    }

    private static class CompactMultiFacetDocComparatorSource
    extends DocComparatorSource {
        private final CompactMultiValueFacetHandler _facetHandler;

        private CompactMultiFacetDocComparatorSource(CompactMultiValueFacetHandler facetHandler) {
            this._facetHandler = facetHandler;
        }

        @Override
        public DocComparator getComparator(final IndexReader reader, int docbase) throws IOException {
            if (!(reader instanceof BoboIndexReader)) {
                throw new IllegalStateException("reader must be instance of " + BoboIndexReader.class);
            }
            final FacetDataCache dataCache = (FacetDataCache)this._facetHandler.getFacetData((BoboIndexReader)reader);
            return new DocComparator(){

                @Override
                public int compare(ScoreDoc doc1, ScoreDoc doc2) {
                    int encoded1 = dataCache.orderArray.get(doc1.doc);
                    int encoded2 = dataCache.orderArray.get(doc2.doc);
                    return encoded1 - encoded2;
                }

                @Override
                public Comparable value(ScoreDoc doc) {
                    return new StringArrayComparator(CompactMultiFacetDocComparatorSource.this._facetHandler.getFieldValues((BoboIndexReader)reader, doc.doc));
                }
            };
        }
    }
}

