/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.console;

import com.bstek.ureport.console.ServletAction;
import com.bstek.ureport.exception.ReportComputeException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public abstract class BaseServletAction
implements ServletAction {
    protected String decode(String value) {
        try {
            value = URLDecoder.decode(value, "utf-8");
            value = URLDecoder.decode(value, "utf-8");
            return value;
        }
        catch (Exception ex) {
            throw new ReportComputeException(ex);
        }
    }

    protected Map<String, Object> buildParameters(HttpServletRequest req) {
        Object value;
        String name;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Enumeration names = req.getParameterNames();
        while (names.hasMoreElements()) {
            name = (String)names.nextElement();
            value = req.getParameter(name);
            if (!StringUtils.isNotBlank((String)value)) continue;
            parameters.put(name, value);
        }
        names = req.getAttributeNames();
        while (names.hasMoreElements()) {
            name = (String)names.nextElement();
            value = req.getAttribute(name);
            if (value == null) continue;
            parameters.put(name, value);
        }
        return parameters;
    }

    protected void invokeMethod(String methodName, HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        try {
            Method method = this.getClass().getMethod(methodName, HttpServletRequest.class, HttpServletResponse.class);
            method.invoke((Object)this, req, resp);
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    protected String retriveMethod(HttpServletRequest req) throws ServletException {
        String path = String.valueOf(req.getContextPath()) + "/ureport";
        String uri = req.getRequestURI();
        String targetUrl = uri.substring(path.length());
        int slashPos = targetUrl.indexOf("/", 1);
        if (slashPos > -1) {
            String methodName = targetUrl.substring(slashPos + 1).trim();
            return methodName.length() > 0 ? methodName : null;
        }
        return null;
    }
}

