/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.console.cache;

import com.bstek.ureport.cache.ReportCache;
import com.bstek.ureport.console.RequestHolder;
import com.bstek.ureport.model.Report;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class HttpSessionReportCache
implements ReportCache {
    private final String KEY = "__ureport_map";
    private final int MAX_ITEM = 3;
    private boolean disabled;

    public Report getReport(String file) {
        HttpServletRequest req = RequestHolder.getRequest();
        if (req == null) {
            return null;
        }
        Map<String, Report> map = this.getReportMap(req);
        return map.get(file);
    }

    public void storeReport(String file, Report report) {
        HttpServletRequest req = RequestHolder.getRequest();
        if (req == null) {
            return;
        }
        Map<String, Report> map = this.getReportMap(req);
        if (map.containsKey(file)) {
            map.remove(file);
        } else if (map.size() > 3) {
            String lastFile = null;
            for (Map.Entry<String, Report> entry : map.entrySet()) {
                lastFile = entry.getKey();
            }
            map.remove(lastFile);
        }
        map.put(file, report);
    }

    public boolean disabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    private Map<String, Report> getReportMap(HttpServletRequest req) {
        HttpSession session = req.getSession();
        LinkedHashMap map = (LinkedHashMap)session.getAttribute("__ureport_map");
        if (map == null) {
            map = new LinkedHashMap();
            session.setAttribute("__ureport_map", map);
        }
        return map;
    }
}

